/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterRole implements SdkPojo, Serializable, ToCopyableBuilder<DBClusterRole.Builder, DBClusterRole> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBClusterRole::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBClusterRole::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String status;

    private DBClusterRole(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Describes the state of association between the IAM role and the DB cluster. The Status property returns one of
     * the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other AWS
     * services on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume
     * the IAM role in order to access other AWS services on your behalf.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes the state of association between the IAM role and the DB cluster. The Status property returns
     *         one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other
     *         AWS services on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable
     *         to assume the IAM role in order to access other AWS services on your behalf.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterRole)) {
            return false;
        }
        DBClusterRole other = (DBClusterRole) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DBClusterRole").add("RoleArn", roleArn()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterRole, T> g) {
        return obj -> g.apply((DBClusterRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterRole> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Describes the state of association between the IAM role and the DB cluster. The Status property returns one
         * of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other AWS
         * services on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to
         * assume the IAM role in order to access other AWS services on your behalf.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Describes the state of association between the IAM role and the DB cluster. The Status property
         *        returns one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access
         *        other AWS services on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is
         *        unable to assume the IAM role in order to access other AWS services on your behalf.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterRole model) {
            roleArn(model.roleArn);
            status(model.status);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DBClusterRole build() {
            return new DBClusterRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
