/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about valid modifications that you can make to your DB instance.
 * </p>
 * <p>
 * Contains the result of a successful call to the <a>DescribeValidDBInstanceModifications</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidStorageOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidStorageOptions.Builder, ValidStorageOptions> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidStorageOptions::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<List<Range>> STORAGE_SIZE_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .getter(getter(ValidStorageOptions::storageSize))
            .setter(setter(Builder::storageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Range")
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Range").build()).build()).build()).build();

    private static final SdkField<List<Range>> PROVISIONED_IOPS_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .getter(getter(ValidStorageOptions::provisionedIops))
            .setter(setter(Builder::provisionedIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedIops").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Range")
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Range").build()).build()).build()).build();

    private static final SdkField<List<DoubleRange>> IOPS_TO_STORAGE_RATIO_FIELD = SdkField
            .<List<DoubleRange>> builder(MarshallingType.LIST)
            .getter(getter(ValidStorageOptions::iopsToStorageRatio))
            .setter(setter(Builder::iopsToStorageRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsToStorageRatio").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DoubleRange")
                            .memberFieldInfo(
                                    SdkField.<DoubleRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DoubleRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DoubleRange").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            STORAGE_SIZE_FIELD, PROVISIONED_IOPS_FIELD, IOPS_TO_STORAGE_RATIO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String storageType;

    private final List<Range> storageSize;

    private final List<Range> provisionedIops;

    private final List<DoubleRange> iopsToStorageRatio;

    private ValidStorageOptions(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.storageSize = builder.storageSize;
        this.provisionedIops = builder.provisionedIops;
        this.iopsToStorageRatio = builder.iopsToStorageRatio;
    }

    /**
     * <p>
     * The valid storage types for your DB instance. For example, gp2, io1.
     * </p>
     * 
     * @return The valid storage types for your DB instance. For example, gp2, io1.
     */
    public String storageType() {
        return storageType;
    }

    /**
     * Returns true if the StorageSize property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStorageSize() {
        return storageSize != null && !(storageSize instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid range of storage in gibibytes. For example, 100 to 16384.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStorageSize()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The valid range of storage in gibibytes. For example, 100 to 16384.
     */
    public List<Range> storageSize() {
        return storageSize;
    }

    /**
     * Returns true if the ProvisionedIops property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProvisionedIops() {
        return provisionedIops != null && !(provisionedIops instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid range of provisioned IOPS. For example, 1000-20000.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisionedIops()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The valid range of provisioned IOPS. For example, 1000-20000.
     */
    public List<Range> provisionedIops() {
        return provisionedIops;
    }

    /**
     * Returns true if the IopsToStorageRatio property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIopsToStorageRatio() {
        return iopsToStorageRatio != null && !(iopsToStorageRatio instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
     * provisioned IOPS can be between 3 and 10 times storage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIopsToStorageRatio()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means
     *         that provisioned IOPS can be between 3 and 10 times storage.
     */
    public List<DoubleRange> iopsToStorageRatio() {
        return iopsToStorageRatio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(storageSize());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedIops());
        hashCode = 31 * hashCode + Objects.hashCode(iopsToStorageRatio());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidStorageOptions)) {
            return false;
        }
        ValidStorageOptions other = (ValidStorageOptions) obj;
        return Objects.equals(storageType(), other.storageType()) && Objects.equals(storageSize(), other.storageSize())
                && Objects.equals(provisionedIops(), other.provisionedIops())
                && Objects.equals(iopsToStorageRatio(), other.iopsToStorageRatio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ValidStorageOptions").add("StorageType", storageType()).add("StorageSize", storageSize())
                .add("ProvisionedIops", provisionedIops()).add("IopsToStorageRatio", iopsToStorageRatio()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "StorageSize":
            return Optional.ofNullable(clazz.cast(storageSize()));
        case "ProvisionedIops":
            return Optional.ofNullable(clazz.cast(provisionedIops()));
        case "IopsToStorageRatio":
            return Optional.ofNullable(clazz.cast(iopsToStorageRatio()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidStorageOptions, T> g) {
        return obj -> g.apply((ValidStorageOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidStorageOptions> {
        /**
         * <p>
         * The valid storage types for your DB instance. For example, gp2, io1.
         * </p>
         * 
         * @param storageType
         *        The valid storage types for your DB instance. For example, gp2, io1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The valid range of storage in gibibytes. For example, 100 to 16384.
         * </p>
         * 
         * @param storageSize
         *        The valid range of storage in gibibytes. For example, 100 to 16384.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSize(Collection<Range> storageSize);

        /**
         * <p>
         * The valid range of storage in gibibytes. For example, 100 to 16384.
         * </p>
         * 
         * @param storageSize
         *        The valid range of storage in gibibytes. For example, 100 to 16384.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSize(Range... storageSize);

        /**
         * <p>
         * The valid range of storage in gibibytes. For example, 100 to 16384.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Range>.Builder} avoiding the need to create
         * one manually via {@link List<Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Range>.Builder#build()} is called immediately and its result
         * is passed to {@link #storageSize(List<Range>)}.
         * 
         * @param storageSize
         *        a consumer that will call methods on {@link List<Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageSize(List<Range>)
         */
        Builder storageSize(Consumer<Range.Builder>... storageSize);

        /**
         * <p>
         * The valid range of provisioned IOPS. For example, 1000-20000.
         * </p>
         * 
         * @param provisionedIops
         *        The valid range of provisioned IOPS. For example, 1000-20000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedIops(Collection<Range> provisionedIops);

        /**
         * <p>
         * The valid range of provisioned IOPS. For example, 1000-20000.
         * </p>
         * 
         * @param provisionedIops
         *        The valid range of provisioned IOPS. For example, 1000-20000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedIops(Range... provisionedIops);

        /**
         * <p>
         * The valid range of provisioned IOPS. For example, 1000-20000.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Range>.Builder} avoiding the need to create
         * one manually via {@link List<Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Range>.Builder#build()} is called immediately and its result
         * is passed to {@link #provisionedIops(List<Range>)}.
         * 
         * @param provisionedIops
         *        a consumer that will call methods on {@link List<Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedIops(List<Range>)
         */
        Builder provisionedIops(Consumer<Range.Builder>... provisionedIops);

        /**
         * <p>
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
         * provisioned IOPS can be between 3 and 10 times storage.
         * </p>
         * 
         * @param iopsToStorageRatio
         *        The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means
         *        that provisioned IOPS can be between 3 and 10 times storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio);

        /**
         * <p>
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
         * provisioned IOPS can be between 3 and 10 times storage.
         * </p>
         * 
         * @param iopsToStorageRatio
         *        The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means
         *        that provisioned IOPS can be between 3 and 10 times storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsToStorageRatio(DoubleRange... iopsToStorageRatio);

        /**
         * <p>
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
         * provisioned IOPS can be between 3 and 10 times storage.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DoubleRange>.Builder} avoiding the need to
         * create one manually via {@link List<DoubleRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DoubleRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #iopsToStorageRatio(List<DoubleRange>)}.
         * 
         * @param iopsToStorageRatio
         *        a consumer that will call methods on {@link List<DoubleRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iopsToStorageRatio(List<DoubleRange>)
         */
        Builder iopsToStorageRatio(Consumer<DoubleRange.Builder>... iopsToStorageRatio);
    }

    static final class BuilderImpl implements Builder {
        private String storageType;

        private List<Range> storageSize = DefaultSdkAutoConstructList.getInstance();

        private List<Range> provisionedIops = DefaultSdkAutoConstructList.getInstance();

        private List<DoubleRange> iopsToStorageRatio = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidStorageOptions model) {
            storageType(model.storageType);
            storageSize(model.storageSize);
            provisionedIops(model.provisionedIops);
            iopsToStorageRatio(model.iopsToStorageRatio);
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Collection<Range.Builder> getStorageSize() {
            return storageSize != null ? storageSize.stream().map(Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageSize(Collection<Range> storageSize) {
            this.storageSize = RangeListCopier.copy(storageSize);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Range... storageSize) {
            storageSize(Arrays.asList(storageSize));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Consumer<Range.Builder>... storageSize) {
            storageSize(Stream.of(storageSize).map(c -> Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageSize(Collection<Range.BuilderImpl> storageSize) {
            this.storageSize = RangeListCopier.copyFromBuilder(storageSize);
        }

        public final Collection<Range.Builder> getProvisionedIops() {
            return provisionedIops != null ? provisionedIops.stream().map(Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedIops(Collection<Range> provisionedIops) {
            this.provisionedIops = RangeListCopier.copy(provisionedIops);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Range... provisionedIops) {
            provisionedIops(Arrays.asList(provisionedIops));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Consumer<Range.Builder>... provisionedIops) {
            provisionedIops(Stream.of(provisionedIops).map(c -> Range.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedIops(Collection<Range.BuilderImpl> provisionedIops) {
            this.provisionedIops = RangeListCopier.copyFromBuilder(provisionedIops);
        }

        public final Collection<DoubleRange.Builder> getIopsToStorageRatio() {
            return iopsToStorageRatio != null ? iopsToStorageRatio.stream().map(DoubleRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copy(iopsToStorageRatio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(DoubleRange... iopsToStorageRatio) {
            iopsToStorageRatio(Arrays.asList(iopsToStorageRatio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(Consumer<DoubleRange.Builder>... iopsToStorageRatio) {
            iopsToStorageRatio(Stream.of(iopsToStorageRatio).map(c -> DoubleRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIopsToStorageRatio(Collection<DoubleRange.BuilderImpl> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copyFromBuilder(iopsToStorageRatio);
        }

        @Override
        public ValidStorageOptions build() {
            return new ValidStorageOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
