/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterFromSnapshotRequest extends NeptuneRequest implements
        ToCopyableBuilder<RestoreDbClusterFromSnapshotRequest.Builder, RestoreDbClusterFromSnapshotRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::snapshotIdentifier)).setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::dbSubnetGroupName)).setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::optionGroupName)).setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD,
            DB_SUBNET_GROUP_NAME_FIELD, DATABASE_NAME_FIELD, OPTION_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD,
            KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD));

    private final List<String> availabilityZones;

    private final String dbClusterIdentifier;

    private final String snapshotIdentifier;

    private final String engine;

    private final String engineVersion;

    private final Integer port;

    private final String dbSubnetGroupName;

    private final String databaseName;

    private final String optionGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final Boolean enableIAMDatabaseAuthentication;

    private final List<String> enableCloudwatchLogsExports;

    private final String dbClusterParameterGroupName;

    private RestoreDbClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.databaseName = builder.databaseName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
     * case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-snapshot-id</code>
     * </p>
     * 
     * @return The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-snapshot-id</code>
     */
    public String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * </p>
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can
     * use only the ARN to specify a DB snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing Snapshot.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
     *         <p>
     *         You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However,
     *         you can use only the ARN to specify a DB snapshot.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing Snapshot.
     *         </p>
     *         </li>
     */
    public String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The database engine to use for the new DB cluster.
     * </p>
     * <p>
     * Default: The same as source
     * </p>
     * <p>
     * Constraint: Must be compatible with the engine of the source
     * </p>
     * 
     * @return The database engine to use for the new DB cluster.</p>
     *         <p>
     *         Default: The same as source
     *         </p>
     *         <p>
     *         Constraint: Must be compatible with the engine of the source
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the database engine to use for the new DB cluster.
     * </p>
     * 
     * @return The version of the database engine to use for the new DB cluster.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The port number on which the new DB cluster accepts connections.
     * </p>
     * <p>
     * Constraints: Value must be <code>1150-65535</code>
     * </p>
     * <p>
     * Default: The same port as the original DB cluster.
     * </p>
     * 
     * @return The port number on which the new DB cluster accepts connections.</p>
     *         <p>
     *         Constraints: Value must be <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: The same port as the original DB cluster.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the DB subnet group to use for the new DB cluster.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return The name of the DB subnet group to use for the new DB cluster.</p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * 
     * @return Not supported.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the option group to use for the restored DB cluster.
     * </p>
     * 
     * @return The name of the option group to use for the restored DB cluster.
     */
    public String optionGroupName() {
        return optionGroupName;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the new DB cluster will belong to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VPC security groups that the new DB cluster will belong to.
     */
    public List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the restored DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be assigned to the restored DB cluster.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The AWS KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster
     * snapshot.
     * </p>
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB
     * cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster, then you
     * can use the KMS key alias instead of the ARN for the KMS encryption key.
     * </p>
     * <p>
     * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB
     * cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored
     * DB cluster is not encrypted.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The AWS KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster
     *         snapshot.</p>
     *         <p>
     *         The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring
     *         a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB
     *         cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *         </p>
     *         <p>
     *         If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the
     *         restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster
     *         snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the
     *         restored DB cluster is not encrypted.
     *         </p>
     *         </li>
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and otherwise
     * false.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
     *         otherwise false.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * Returns true if the EnableCloudwatchLogsExports property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnableCloudwatchLogsExports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
     */
    public List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with the new DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DBClusterParameterGroup.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB cluster parameter group to associate with the new DB cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DBClusterParameterGroup.
     *         </p>
     *         </li>
     */
    public String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(enableCloudwatchLogsExports());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDbClusterFromSnapshotRequest other = (RestoreDbClusterFromSnapshotRequest) obj;
        return Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreDbClusterFromSnapshotRequest").add("AvailabilityZones", availabilityZones())
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("Engine", engine()).add("EngineVersion", engineVersion()).add("Port", port())
                .add("DBSubnetGroupName", dbSubnetGroupName()).add("DatabaseName", databaseName())
                .add("OptionGroupName", optionGroupName()).add("VpcSecurityGroupIds", vpcSecurityGroupIds()).add("Tags", tags())
                .add("KmsKeyId", kmsKeyId()).add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("EnableCloudwatchLogsExports", enableCloudwatchLogsExports())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
        /**
         * <p>
         * Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
         * case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-snapshot-id</code>
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't
         *        case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-snapshot-id</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The identifier for the DB snapshot or DB cluster snapshot to restore from.
         * </p>
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you
         * can use only the ARN to specify a DB snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing Snapshot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotIdentifier
         *        The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>
         *        <p>
         *        You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot.
         *        However, you can use only the ARN to specify a DB snapshot.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing Snapshot.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The database engine to use for the new DB cluster.
         * </p>
         * <p>
         * Default: The same as source
         * </p>
         * <p>
         * Constraint: Must be compatible with the engine of the source
         * </p>
         * 
         * @param engine
         *        The database engine to use for the new DB cluster.</p>
         *        <p>
         *        Default: The same as source
         *        </p>
         *        <p>
         *        Constraint: Must be compatible with the engine of the source
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the database engine to use for the new DB cluster.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine to use for the new DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The port number on which the new DB cluster accepts connections.
         * </p>
         * <p>
         * Constraints: Value must be <code>1150-65535</code>
         * </p>
         * <p>
         * Default: The same port as the original DB cluster.
         * </p>
         * 
         * @param port
         *        The port number on which the new DB cluster accepts connections.</p>
         *        <p>
         *        Constraints: Value must be <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: The same port as the original DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the DB subnet group to use for the new DB cluster.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The name of the DB subnet group to use for the new DB cluster.</p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param databaseName
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the option group to use for the restored DB cluster.
         * </p>
         * 
         * @param optionGroupName
         *        The name of the option group to use for the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The tags to be assigned to the restored DB cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the restored DB cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the restored DB cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The AWS KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster
         * snapshot.
         * </p>
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a
         * DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster,
         * then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * </p>
         * <p>
         * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored
         * DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the
         * restored DB cluster is not encrypted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        The AWS KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB
         *        cluster snapshot.</p>
         *        <p>
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        restoring a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the
         *        new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *        </p>
         *        <p>
         *        If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the
         *        restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB
         *        cluster snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then
         *        the restored DB cluster is not encrypted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
         * otherwise false.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
         *        otherwise false.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with the new DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DBClusterParameterGroup.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with the new DB cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DBClusterParameterGroup.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterIdentifier;

        private String snapshotIdentifier;

        private String engine;

        private String engineVersion;

        private Integer port;

        private String dbSubnetGroupName;

        private String databaseName;

        private String optionGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private Boolean enableIAMDatabaseAuthentication;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterParameterGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromSnapshotRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            dbClusterIdentifier(model.dbClusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            engine(model.engine);
            engineVersion(model.engineVersion);
            port(model.port);
            dbSubnetGroupName(model.dbSubnetGroupName);
            databaseName(model.databaseName);
            optionGroupName(model.optionGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            return enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromSnapshotRequest build() {
            return new RestoreDbClusterFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
