/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDbParameterGroupRequest extends NeptuneRequest implements
        ToCopyableBuilder<CopyDbParameterGroupRequest.Builder, CopyDbParameterGroupRequest> {
    private static final SdkField<String> SOURCE_DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbParameterGroupRequest::sourceDBParameterGroupIdentifier))
            .setter(setter(Builder::sourceDBParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBParameterGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> TARGET_DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbParameterGroupRequest::targetDBParameterGroupIdentifier))
            .setter(setter(Builder::targetDBParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBParameterGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> TARGET_DB_PARAMETER_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbParameterGroupRequest::targetDBParameterGroupDescription))
            .setter(setter(Builder::targetDBParameterGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBParameterGroupDescription")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CopyDbParameterGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_DB_PARAMETER_GROUP_IDENTIFIER_FIELD, TARGET_DB_PARAMETER_GROUP_IDENTIFIER_FIELD,
            TARGET_DB_PARAMETER_GROUP_DESCRIPTION_FIELD, TAGS_FIELD));

    private final String sourceDBParameterGroupIdentifier;

    private final String targetDBParameterGroupIdentifier;

    private final String targetDBParameterGroupDescription;

    private final List<Tag> tags;

    private CopyDbParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBParameterGroupIdentifier = builder.sourceDBParameterGroupIdentifier;
        this.targetDBParameterGroupIdentifier = builder.targetDBParameterGroupIdentifier;
        this.targetDBParameterGroupDescription = builder.targetDBParameterGroupDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a
     * href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
     * Constructing an Amazon Resource Name (ARN)</a>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must specify a valid DB parameter group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid ARN.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a
     *         href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
     *         Constructing an Amazon Resource Name (ARN)</a>.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must specify a valid DB parameter group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a
     *         valid ARN.
     *         </p>
     *         </li>
     */
    public String sourceDBParameterGroupIdentifier() {
        return sourceDBParameterGroupIdentifier;
    }

    /**
     * <p>
     * The identifier for the copied DB parameter group.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cannot be null, empty, or blank.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-db-parameter-group</code>
     * </p>
     * 
     * @return The identifier for the copied DB parameter group.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot be null, empty, or blank.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-db-parameter-group</code>
     */
    public String targetDBParameterGroupIdentifier() {
        return targetDBParameterGroupIdentifier;
    }

    /**
     * <p>
     * A description for the copied DB parameter group.
     * </p>
     * 
     * @return A description for the copied DB parameter group.
     */
    public String targetDBParameterGroupDescription() {
        return targetDBParameterGroupDescription;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the copied DB parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be assigned to the copied DB parameter group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBParameterGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbParameterGroupRequest)) {
            return false;
        }
        CopyDbParameterGroupRequest other = (CopyDbParameterGroupRequest) obj;
        return Objects.equals(sourceDBParameterGroupIdentifier(), other.sourceDBParameterGroupIdentifier())
                && Objects.equals(targetDBParameterGroupIdentifier(), other.targetDBParameterGroupIdentifier())
                && Objects.equals(targetDBParameterGroupDescription(), other.targetDBParameterGroupDescription())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CopyDbParameterGroupRequest")
                .add("SourceDBParameterGroupIdentifier", sourceDBParameterGroupIdentifier())
                .add("TargetDBParameterGroupIdentifier", targetDBParameterGroupIdentifier())
                .add("TargetDBParameterGroupDescription", targetDBParameterGroupDescription()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDBParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBParameterGroupIdentifier()));
        case "TargetDBParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(targetDBParameterGroupIdentifier()));
        case "TargetDBParameterGroupDescription":
            return Optional.ofNullable(clazz.cast(targetDBParameterGroupDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbParameterGroupRequest, T> g) {
        return obj -> g.apply((CopyDbParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyDbParameterGroupRequest> {
        /**
         * <p>
         * The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a
         * href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
         * Constructing an Amazon Resource Name (ARN)</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must specify a valid DB parameter group.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid
         * ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBParameterGroupIdentifier
         *        The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a
         *        href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
         *        Constructing an Amazon Resource Name (ARN)</a>.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must specify a valid DB parameter group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a
         *        valid ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier);

        /**
         * <p>
         * The identifier for the copied DB parameter group.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cannot be null, empty, or blank.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-db-parameter-group</code>
         * </p>
         * 
         * @param targetDBParameterGroupIdentifier
         *        The identifier for the copied DB parameter group.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cannot be null, empty, or blank.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-db-parameter-group</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier);

        /**
         * <p>
         * A description for the copied DB parameter group.
         * </p>
         * 
         * @param targetDBParameterGroupDescription
         *        A description for the copied DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBParameterGroupDescription(String targetDBParameterGroupDescription);

        /**
         * <p>
         * The tags to be assigned to the copied DB parameter group.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the copied DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the copied DB parameter group.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the copied DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the copied DB parameter group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String sourceDBParameterGroupIdentifier;

        private String targetDBParameterGroupIdentifier;

        private String targetDBParameterGroupDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbParameterGroupRequest model) {
            super(model);
            sourceDBParameterGroupIdentifier(model.sourceDBParameterGroupIdentifier);
            targetDBParameterGroupIdentifier(model.targetDBParameterGroupIdentifier);
            targetDBParameterGroupDescription(model.targetDBParameterGroupDescription);
            tags(model.tags);
        }

        public final String getSourceDBParameterGroupIdentifier() {
            return sourceDBParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier) {
            this.sourceDBParameterGroupIdentifier = sourceDBParameterGroupIdentifier;
            return this;
        }

        public final void setSourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier) {
            this.sourceDBParameterGroupIdentifier = sourceDBParameterGroupIdentifier;
        }

        public final String getTargetDBParameterGroupIdentifier() {
            return targetDBParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier) {
            this.targetDBParameterGroupIdentifier = targetDBParameterGroupIdentifier;
            return this;
        }

        public final void setTargetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier) {
            this.targetDBParameterGroupIdentifier = targetDBParameterGroupIdentifier;
        }

        public final String getTargetDBParameterGroupDescription() {
            return targetDBParameterGroupDescription;
        }

        @Override
        public final Builder targetDBParameterGroupDescription(String targetDBParameterGroupDescription) {
            this.targetDBParameterGroupDescription = targetDBParameterGroupDescription;
            return this;
        }

        public final void setTargetDBParameterGroupDescription(String targetDBParameterGroupDescription) {
            this.targetDBParameterGroupDescription = targetDBParameterGroupDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbParameterGroupRequest build() {
            return new CopyDbParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
