/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbClusterParameterGroupRequest extends NeptuneRequest implements
        ToCopyableBuilder<CreateDbClusterParameterGroupRequest.Builder, CreateDbClusterParameterGroupRequest> {
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDbClusterParameterGroupRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDbClusterParameterGroupRequest::dbParameterGroupFamily))
            .setter(setter(Builder::dbParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDbClusterParameterGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateDbClusterParameterGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private final String dbClusterParameterGroupName;

    private final String dbParameterGroupFamily;

    private final String description;

    private final List<Tag> tags;

    private CreateDbClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the name of an existing DBClusterParameterGroup.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This value is stored as a lowercase string.
     * </p>
     * </note>
     * 
     * @return The name of the DB cluster parameter group.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the name of an existing DBClusterParameterGroup.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This value is stored as a lowercase string.
     *         </p>
     */
    public String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one
     * DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine
     * version compatible with that DB cluster parameter group family.
     * </p>
     * 
     * @return The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and
     *         only one DB cluster parameter group family, and can be applied only to a DB cluster running a database
     *         engine and engine version compatible with that DB cluster parameter group family.
     */
    public String dbParameterGroupFamily() {
        return dbParameterGroupFamily;
    }

    /**
     * <p>
     * The description for the DB cluster parameter group.
     * </p>
     * 
     * @return The description for the DB cluster parameter group.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the new DB cluster parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be assigned to the new DB cluster parameter group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbClusterParameterGroupRequest)) {
            return false;
        }
        CreateDbClusterParameterGroupRequest other = (CreateDbClusterParameterGroupRequest) obj;
        return Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(dbParameterGroupFamily(), other.dbParameterGroupFamily())
                && Objects.equals(description(), other.description()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDbClusterParameterGroupRequest")
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("DBParameterGroupFamily", dbParameterGroupFamily()).add("Description", description()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "DBParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(dbParameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbClusterParameterGroupRequest, T> g) {
        return obj -> g.apply((CreateDbClusterParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDbClusterParameterGroupRequest> {
        /**
         * <p>
         * The name of the DB cluster parameter group.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the name of an existing DBClusterParameterGroup.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This value is stored as a lowercase string.
         * </p>
         * </note>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the name of an existing DBClusterParameterGroup.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This value is stored as a lowercase string.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only
         * one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and
         * engine version compatible with that DB cluster parameter group family.
         * </p>
         * 
         * @param dbParameterGroupFamily
         *        The DB cluster parameter group family name. A DB cluster parameter group can be associated with one
         *        and only one DB cluster parameter group family, and can be applied only to a DB cluster running a
         *        database engine and engine version compatible with that DB cluster parameter group family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupFamily(String dbParameterGroupFamily);

        /**
         * <p>
         * The description for the DB cluster parameter group.
         * </p>
         * 
         * @param description
         *        The description for the DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to be assigned to the new DB cluster parameter group.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the new DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the new DB cluster parameter group.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the new DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the new DB cluster parameter group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterParameterGroupName;

        private String dbParameterGroupFamily;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbClusterParameterGroupRequest model) {
            super(model);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            dbParameterGroupFamily(model.dbParameterGroupFamily);
            description(model.description);
            tags(model.tags);
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final String getDbParameterGroupFamily() {
            return dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbClusterParameterGroupRequest build() {
            return new CreateDbClusterParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
