/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbClusterSnapshotAttributeResponse extends NeptuneResponse implements
        ToCopyableBuilder<ModifyDbClusterSnapshotAttributeResponse.Builder, ModifyDbClusterSnapshotAttributeResponse> {
    private static final SdkField<DBClusterSnapshotAttributesResult> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_RESULT_FIELD = SdkField
            .<DBClusterSnapshotAttributesResult> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyDbClusterSnapshotAttributeResponse::dbClusterSnapshotAttributesResult))
            .setter(setter(Builder::dbClusterSnapshotAttributesResult))
            .constructor(DBClusterSnapshotAttributesResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttributesResult")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_CLUSTER_SNAPSHOT_ATTRIBUTES_RESULT_FIELD));

    private final DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult;

    private ModifyDbClusterSnapshotAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterSnapshotAttributesResult = builder.dbClusterSnapshotAttributesResult;
    }

    /**
     * Returns the value of the DBClusterSnapshotAttributesResult property for this object.
     * 
     * @return The value of the DBClusterSnapshotAttributesResult property for this object.
     */
    public DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult() {
        return dbClusterSnapshotAttributesResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterSnapshotAttributesResult());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterSnapshotAttributeResponse)) {
            return false;
        }
        ModifyDbClusterSnapshotAttributeResponse other = (ModifyDbClusterSnapshotAttributeResponse) obj;
        return Objects.equals(dbClusterSnapshotAttributesResult(), other.dbClusterSnapshotAttributesResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyDbClusterSnapshotAttributeResponse")
                .add("DBClusterSnapshotAttributesResult", dbClusterSnapshotAttributesResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterSnapshotAttributesResult":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotAttributesResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterSnapshotAttributeResponse, T> g) {
        return obj -> g.apply((ModifyDbClusterSnapshotAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyDbClusterSnapshotAttributeResponse> {
        /**
         * Sets the value of the DBClusterSnapshotAttributesResult property for this object.
         *
         * @param dbClusterSnapshotAttributesResult
         *        The new value for the DBClusterSnapshotAttributesResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult);

        /**
         * Sets the value of the DBClusterSnapshotAttributesResult property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBClusterSnapshotAttributesResult.Builder}
         * avoiding the need to create one manually via {@link DBClusterSnapshotAttributesResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBClusterSnapshotAttributesResult.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult)}.
         * 
         * @param dbClusterSnapshotAttributesResult
         *        a consumer that will call methods on {@link DBClusterSnapshotAttributesResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult)
         */
        default Builder dbClusterSnapshotAttributesResult(
                Consumer<DBClusterSnapshotAttributesResult.Builder> dbClusterSnapshotAttributesResult) {
            return dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult.builder()
                    .applyMutation(dbClusterSnapshotAttributesResult).build());
        }
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterSnapshotAttributeResponse model) {
            super(model);
            dbClusterSnapshotAttributesResult(model.dbClusterSnapshotAttributesResult);
        }

        public final DBClusterSnapshotAttributesResult.Builder getDbClusterSnapshotAttributesResult() {
            return dbClusterSnapshotAttributesResult != null ? dbClusterSnapshotAttributesResult.toBuilder() : null;
        }

        @Override
        public final Builder dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult) {
            this.dbClusterSnapshotAttributesResult = dbClusterSnapshotAttributesResult;
            return this;
        }

        public final void setDbClusterSnapshotAttributesResult(
                DBClusterSnapshotAttributesResult.BuilderImpl dbClusterSnapshotAttributesResult) {
            this.dbClusterSnapshotAttributesResult = dbClusterSnapshotAttributesResult != null ? dbClusterSnapshotAttributesResult
                    .build() : null;
        }

        @Override
        public ModifyDbClusterSnapshotAttributeResponse build() {
            return new ModifyDbClusterSnapshotAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
