/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.ValidStorageOptions;
import software.amazon.awssdk.services.neptune.model.ValidStorageOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidDBInstanceModificationsMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
    private static final SdkField<List<ValidStorageOptions>> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Storage").getter(ValidDBInstanceModificationsMessage.getter(ValidDBInstanceModificationsMessage::storage)).setter(ValidDBInstanceModificationsMessage.setter(Builder::storage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build(), ListTrait.builder().memberLocationName("ValidStorageOptions").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidStorageOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidStorageOptions").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ValidStorageOptions> storage;

    private ValidDBInstanceModificationsMessage(BuilderImpl builder) {
        this.storage = builder.storage;
    }

    public boolean hasStorage() {
        return this.storage != null && !(this.storage instanceof SdkAutoConstructList);
    }

    public List<ValidStorageOptions> storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidDBInstanceModificationsMessage)) {
            return false;
        }
        ValidDBInstanceModificationsMessage other = (ValidDBInstanceModificationsMessage)obj;
        return Objects.equals(this.storage(), other.storage());
    }

    public String toString() {
        return ToString.builder((String)"ValidDBInstanceModificationsMessage").add("Storage", this.storage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidDBInstanceModificationsMessage, T> g) {
        return obj -> g.apply((ValidDBInstanceModificationsMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValidStorageOptions> storage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidDBInstanceModificationsMessage model) {
            this.storage(model.storage);
        }

        public final Collection<ValidStorageOptions.Builder> getStorage() {
            return this.storage != null ? (Collection)this.storage.stream().map(ValidStorageOptions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storage(Collection<ValidStorageOptions> storage) {
            this.storage = ValidStorageOptionsListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ValidStorageOptions ... storage) {
            this.storage(Arrays.asList(storage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(Consumer<ValidStorageOptions.Builder> ... storage) {
            this.storage(Stream.of(storage).map(c -> (ValidStorageOptions)((ValidStorageOptions.Builder)ValidStorageOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorage(Collection<ValidStorageOptions.BuilderImpl> storage) {
            this.storage = ValidStorageOptionsListCopier.copyFromBuilder(storage);
        }

        public ValidDBInstanceModificationsMessage build() {
            return new ValidDBInstanceModificationsMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
        public Builder storage(Collection<ValidStorageOptions> var1);

        public Builder storage(ValidStorageOptions ... var1);

        public Builder storage(Consumer<ValidStorageOptions.Builder> ... var1);
    }
}

