/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbSubnetGroupResponse extends NeptuneResponse implements
        ToCopyableBuilder<ModifyDbSubnetGroupResponse.Builder, ModifyDbSubnetGroupResponse> {
    private static final SdkField<DBSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField
            .<DBSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("DBSubnetGroup")
            .getter(getter(ModifyDbSubnetGroupResponse::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup))
            .constructor(DBSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SUBNET_GROUP_FIELD));

    private final DBSubnetGroup dbSubnetGroup;

    private ModifyDbSubnetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbSubnetGroup = builder.dbSubnetGroup;
    }

    /**
     * Returns the value of the DBSubnetGroup property for this object.
     * 
     * @return The value of the DBSubnetGroup property for this object.
     */
    public DBSubnetGroup dbSubnetGroup() {
        return dbSubnetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSubnetGroupResponse)) {
            return false;
        }
        ModifyDbSubnetGroupResponse other = (ModifyDbSubnetGroupResponse) obj;
        return Objects.equals(dbSubnetGroup(), other.dbSubnetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyDbSubnetGroupResponse").add("DBSubnetGroup", dbSubnetGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSubnetGroupResponse, T> g) {
        return obj -> g.apply((ModifyDbSubnetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbSubnetGroupResponse> {
        /**
         * Sets the value of the DBSubnetGroup property for this object.
         *
         * @param dbSubnetGroup
         *        The new value for the DBSubnetGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup);

        /**
         * Sets the value of the DBSubnetGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBSubnetGroup.Builder} avoiding the need to
         * create one manually via {@link DBSubnetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBSubnetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #dbSubnetGroup(DBSubnetGroup)}.
         * 
         * @param dbSubnetGroup
         *        a consumer that will call methods on {@link DBSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroup(DBSubnetGroup)
         */
        default Builder dbSubnetGroup(Consumer<DBSubnetGroup.Builder> dbSubnetGroup) {
            return dbSubnetGroup(DBSubnetGroup.builder().applyMutation(dbSubnetGroup).build());
        }
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private DBSubnetGroup dbSubnetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSubnetGroupResponse model) {
            super(model);
            dbSubnetGroup(model.dbSubnetGroup);
        }

        public final DBSubnetGroup.Builder getDbSubnetGroup() {
            return dbSubnetGroup != null ? dbSubnetGroup.toBuilder() : null;
        }

        @Override
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDbSubnetGroup(DBSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        @Override
        public ModifyDbSubnetGroupResponse build() {
            return new ModifyDbSubnetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
