/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <a>ModifyDBInstance</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingModifiedValues.Builder, PendingModifiedValues> {
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(PendingModifiedValues::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(PendingModifiedValues::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(PendingModifiedValues::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(PendingModifiedValues::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(PendingModifiedValues::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(PendingModifiedValues::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(PendingModifiedValues::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(PendingModifiedValues::licenseModel)).setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(PendingModifiedValues::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(PendingModifiedValues::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(PendingModifiedValues::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(PendingModifiedValues::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(PendingModifiedValues::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<PendingCloudwatchLogsExports> PENDING_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<PendingCloudwatchLogsExports> builder(MarshallingType.SDK_POJO)
            .memberName("PendingCloudwatchLogsExports")
            .getter(getter(PendingModifiedValues::pendingCloudwatchLogsExports))
            .setter(setter(Builder::pendingCloudwatchLogsExports))
            .constructor(PendingCloudwatchLogsExports::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingCloudwatchLogsExports")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_CLASS_FIELD,
            ALLOCATED_STORAGE_FIELD, MASTER_USER_PASSWORD_FIELD, PORT_FIELD, BACKUP_RETENTION_PERIOD_FIELD, MULTI_AZ_FIELD,
            ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, DB_SUBNET_GROUP_NAME_FIELD, PENDING_CLOUDWATCH_LOGS_EXPORTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbInstanceClass;

    private final Integer allocatedStorage;

    private final String masterUserPassword;

    private final Integer port;

    private final Integer backupRetentionPeriod;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final String licenseModel;

    private final Integer iops;

    private final String dbInstanceIdentifier;

    private final String storageType;

    private final String caCertificateIdentifier;

    private final String dbSubnetGroupName;

    private final PendingCloudwatchLogsExports pendingCloudwatchLogsExports;

    private PendingModifiedValues(BuilderImpl builder) {
        this.dbInstanceClass = builder.dbInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.masterUserPassword = builder.masterUserPassword;
        this.port = builder.port;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.storageType = builder.storageType;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.pendingCloudwatchLogsExports = builder.pendingCloudwatchLogsExports;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is currently being
     * applied.
     * </p>
     * 
     * @return Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is currently
     *         being applied.
     */
    public String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is currently
     * being applied.
     * </p>
     * 
     * @return Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is
     *         currently being applied.
     */
    public Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Contains the pending or currently-in-progress change of the master credentials for the DB instance.
     * </p>
     * 
     * @return Contains the pending or currently-in-progress change of the master credentials for the DB instance.
     */
    public String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * Specifies the pending port for the DB instance.
     * </p>
     * 
     * @return Specifies the pending port for the DB instance.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies the pending number of days for which automated backups are retained.
     * </p>
     * 
     * @return Specifies the pending number of days for which automated backups are retained.
     */
    public Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * </p>
     * 
     * @return Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     */
    public Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The license model for the DB instance.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     * 
     * @return The license model for the DB instance.</p>
     *         <p>
     *         Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     *         <code>general-public-license</code>
     */
    public String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.
     * </p>
     * 
     * @return Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being
     *         applied.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is currently being
     * applied.
     * </p>
     * 
     * @return Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is
     *         currently being applied.
     */
    public String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     * 
     * @return Specifies the storage type to be associated with the DB instance.
     */
    public String storageType() {
        return storageType;
    }

    /**
     * <p>
     * Specifies the identifier of the CA certificate for the DB instance.
     * </p>
     * 
     * @return Specifies the identifier of the CA certificate for the DB instance.
     */
    public String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * The new DB subnet group for the DB instance.
     * </p>
     * 
     * @return The new DB subnet group for the DB instance.
     */
    public String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs are
     * enabled and which are disabled.
     * </p>
     * 
     * @return This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch
     *         logs are enabled and which are disabled.
     */
    public PendingCloudwatchLogsExports pendingCloudwatchLogsExports() {
        return pendingCloudwatchLogsExports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(pendingCloudwatchLogsExports());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues) obj;
        return Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(masterUserPassword(), other.masterUserPassword()) && Objects.equals(port(), other.port())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(pendingCloudwatchLogsExports(), other.pendingCloudwatchLogsExports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PendingModifiedValues").add("DBInstanceClass", dbInstanceClass())
                .add("AllocatedStorage", allocatedStorage()).add("MasterUserPassword", masterUserPassword()).add("Port", port())
                .add("BackupRetentionPeriod", backupRetentionPeriod()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("LicenseModel", licenseModel()).add("Iops", iops())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("StorageType", storageType())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("DBSubnetGroupName", dbSubnetGroupName())
                .add("PendingCloudwatchLogsExports", pendingCloudwatchLogsExports()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "PendingCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(pendingCloudwatchLogsExports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedValues, T> g) {
        return obj -> g.apply((PendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingModifiedValues> {
        /**
         * <p>
         * Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is currently being
         * applied.
         * </p>
         * 
         * @param dbInstanceClass
         *        Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is currently
         *        being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is currently
         * being applied.
         * </p>
         * 
         * @param allocatedStorage
         *        Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is
         *        currently being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Contains the pending or currently-in-progress change of the master credentials for the DB instance.
         * </p>
         * 
         * @param masterUserPassword
         *        Contains the pending or currently-in-progress change of the master credentials for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * Specifies the pending port for the DB instance.
         * </p>
         * 
         * @param port
         *        Specifies the pending port for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies the pending number of days for which automated backups are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        Specifies the pending number of days for which automated backups are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
         * </p>
         * 
         * @param multiAZ
         *        Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The license model for the DB instance.
         * </p>
         * <p>
         * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
         * <code>general-public-license</code>
         * </p>
         * 
         * @param licenseModel
         *        The license model for the DB instance.</p>
         *        <p>
         *        Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
         *        <code>general-public-license</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being
         * applied.
         * </p>
         * 
         * @param iops
         *        Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently
         *        being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is currently
         * being applied.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is
         *        currently being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Specifies the storage type to be associated with the DB instance.
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type to be associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * Specifies the identifier of the CA certificate for the DB instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        Specifies the identifier of the CA certificate for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * The new DB subnet group for the DB instance.
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The new DB subnet group for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs
         * are enabled and which are disabled.
         * </p>
         * 
         * @param pendingCloudwatchLogsExports
         *        This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch
         *        logs are enabled and which are disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingCloudwatchLogsExports(PendingCloudwatchLogsExports pendingCloudwatchLogsExports);

        /**
         * <p>
         * This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs
         * are enabled and which are disabled.
         * </p>
         * This is a convenience that creates an instance of the {@link PendingCloudwatchLogsExports.Builder} avoiding
         * the need to create one manually via {@link PendingCloudwatchLogsExports#builder()}.
         *
         * When the {@link Consumer} completes, {@link PendingCloudwatchLogsExports.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingCloudwatchLogsExports(PendingCloudwatchLogsExports)}.
         * 
         * @param pendingCloudwatchLogsExports
         *        a consumer that will call methods on {@link PendingCloudwatchLogsExports.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingCloudwatchLogsExports(PendingCloudwatchLogsExports)
         */
        default Builder pendingCloudwatchLogsExports(Consumer<PendingCloudwatchLogsExports.Builder> pendingCloudwatchLogsExports) {
            return pendingCloudwatchLogsExports(PendingCloudwatchLogsExports.builder()
                    .applyMutation(pendingCloudwatchLogsExports).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceClass;

        private Integer allocatedStorage;

        private String masterUserPassword;

        private Integer port;

        private Integer backupRetentionPeriod;

        private Boolean multiAZ;

        private String engineVersion;

        private String licenseModel;

        private Integer iops;

        private String dbInstanceIdentifier;

        private String storageType;

        private String caCertificateIdentifier;

        private String dbSubnetGroupName;

        private PendingCloudwatchLogsExports pendingCloudwatchLogsExports;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            dbInstanceClass(model.dbInstanceClass);
            allocatedStorage(model.allocatedStorage);
            masterUserPassword(model.masterUserPassword);
            port(model.port);
            backupRetentionPeriod(model.backupRetentionPeriod);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            licenseModel(model.licenseModel);
            iops(model.iops);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            storageType(model.storageType);
            caCertificateIdentifier(model.caCertificateIdentifier);
            dbSubnetGroupName(model.dbSubnetGroupName);
            pendingCloudwatchLogsExports(model.pendingCloudwatchLogsExports);
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final PendingCloudwatchLogsExports.Builder getPendingCloudwatchLogsExports() {
            return pendingCloudwatchLogsExports != null ? pendingCloudwatchLogsExports.toBuilder() : null;
        }

        @Override
        public final Builder pendingCloudwatchLogsExports(PendingCloudwatchLogsExports pendingCloudwatchLogsExports) {
            this.pendingCloudwatchLogsExports = pendingCloudwatchLogsExports;
            return this;
        }

        public final void setPendingCloudwatchLogsExports(PendingCloudwatchLogsExports.BuilderImpl pendingCloudwatchLogsExports) {
            this.pendingCloudwatchLogsExports = pendingCloudwatchLogsExports != null ? pendingCloudwatchLogsExports.build()
                    : null;
        }

        @Override
        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
