/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbClusterEndpointRequest extends NeptuneRequest implements
        ToCopyableBuilder<DeleteDbClusterEndpointRequest.Builder, DeleteDbClusterEndpointRequest> {
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterEndpointIdentifier")
            .getter(getter(DeleteDbClusterEndpointRequest::dbClusterEndpointIdentifier))
            .setter(setter(Builder::dbClusterEndpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD));

    private final String dbClusterEndpointIdentifier;

    private DeleteDbClusterEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
    }

    /**
     * <p>
     * The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.
     */
    public String dbClusterEndpointIdentifier() {
        return dbClusterEndpointIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterEndpointIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterEndpointRequest)) {
            return false;
        }
        DeleteDbClusterEndpointRequest other = (DeleteDbClusterEndpointRequest) obj;
        return Objects.equals(dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDbClusterEndpointRequest")
                .add("DBClusterEndpointIdentifier", dbClusterEndpointIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterEndpointIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterEndpointIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterEndpointRequest, T> g) {
        return obj -> g.apply((DeleteDbClusterEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbClusterEndpointRequest> {
        /**
         * <p>
         * The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param dbClusterEndpointIdentifier
         *        The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterEndpointIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterEndpointRequest model) {
            super(model);
            dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
        }

        public final String getDbClusterEndpointIdentifier() {
            return dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbClusterEndpointRequest build() {
            return new DeleteDbClusterEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
