/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrderableDbInstanceOptionsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeOrderableDbInstanceOptionsResponse.Builder, DescribeOrderableDbInstanceOptionsResponse> {
    private static final SdkField<List<OrderableDBInstanceOption>> ORDERABLE_DB_INSTANCE_OPTIONS_FIELD = SdkField
            .<List<OrderableDBInstanceOption>> builder(MarshallingType.LIST)
            .memberName("OrderableDBInstanceOptions")
            .getter(getter(DescribeOrderableDbInstanceOptionsResponse::orderableDBInstanceOptions))
            .setter(setter(Builder::orderableDBInstanceOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableDBInstanceOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OrderableDBInstanceOption")
                            .memberFieldInfo(
                                    SdkField.<OrderableDBInstanceOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderableDBInstanceOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OrderableDBInstanceOption").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeOrderableDbInstanceOptionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORDERABLE_DB_INSTANCE_OPTIONS_FIELD, MARKER_FIELD));

    private final List<OrderableDBInstanceOption> orderableDBInstanceOptions;

    private final String marker;

    private DescribeOrderableDbInstanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableDBInstanceOptions = builder.orderableDBInstanceOptions;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the OrderableDBInstanceOptions property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasOrderableDBInstanceOptions() {
        return orderableDBInstanceOptions != null && !(orderableDBInstanceOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrderableDBInstanceOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB
     *         instance.
     */
    public final List<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        return orderableDBInstanceOptions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is
     * specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code> .
     * </p>
     * 
     * @return An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter
     *         is specified, the response includes only records beyond the marker, up to the value specified by
     *         <code>MaxRecords</code> .
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderableDBInstanceOptions() ? orderableDBInstanceOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableDbInstanceOptionsResponse)) {
            return false;
        }
        DescribeOrderableDbInstanceOptionsResponse other = (DescribeOrderableDbInstanceOptionsResponse) obj;
        return hasOrderableDBInstanceOptions() == other.hasOrderableDBInstanceOptions()
                && Objects.equals(orderableDBInstanceOptions(), other.orderableDBInstanceOptions())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrderableDbInstanceOptionsResponse")
                .add("OrderableDBInstanceOptions", hasOrderableDBInstanceOptions() ? orderableDBInstanceOptions() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderableDBInstanceOptions":
            return Optional.ofNullable(clazz.cast(orderableDBInstanceOptions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableDbInstanceOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOrderableDbInstanceOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsResponse> {
        /**
         * <p>
         * An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB
         * instance.
         * </p>
         * 
         * @param orderableDBInstanceOptions
         *        An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the
         *        DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions);

        /**
         * <p>
         * An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB
         * instance.
         * </p>
         * 
         * @param orderableDBInstanceOptions
         *        An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the
         *        DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableDBInstanceOptions(OrderableDBInstanceOption... orderableDBInstanceOptions);

        /**
         * <p>
         * An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB
         * instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrderableDBInstanceOption>.Builder}
         * avoiding the need to create one manually via {@link List<OrderableDBInstanceOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrderableDBInstanceOption>.Builder#build()} is called
         * immediately and its result is passed to {@link #orderableDBInstanceOptions(List<OrderableDBInstanceOption>)}.
         * 
         * @param orderableDBInstanceOptions
         *        a consumer that will call methods on {@link List<OrderableDBInstanceOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderableDBInstanceOptions(List<OrderableDBInstanceOption>)
         */
        Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder>... orderableDBInstanceOptions);

        /**
         * <p>
         * An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is
         * specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code> .
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this
         *        parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private List<OrderableDBInstanceOption> orderableDBInstanceOptions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableDbInstanceOptionsResponse model) {
            super(model);
            orderableDBInstanceOptions(model.orderableDBInstanceOptions);
            marker(model.marker);
        }

        public final Collection<OrderableDBInstanceOption.Builder> getOrderableDBInstanceOptions() {
            if (orderableDBInstanceOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return orderableDBInstanceOptions != null ? orderableDBInstanceOptions.stream()
                    .map(OrderableDBInstanceOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copy(orderableDBInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(OrderableDBInstanceOption... orderableDBInstanceOptions) {
            orderableDBInstanceOptions(Arrays.asList(orderableDBInstanceOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder>... orderableDBInstanceOptions) {
            orderableDBInstanceOptions(Stream.of(orderableDBInstanceOptions)
                    .map(c -> OrderableDBInstanceOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderableDBInstanceOptions(
                Collection<OrderableDBInstanceOption.BuilderImpl> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copyFromBuilder(orderableDBInstanceOptions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableDbInstanceOptionsResponse build() {
            return new DescribeOrderableDbInstanceOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
