/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon Neptune DB instance.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>DescribeDBInstances</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBInstance implements SdkPojo, Serializable, ToCopyableBuilder<DBInstance.Builder, DBInstance> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DBInstance::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(DBInstance::dbInstanceClass)).setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DBInstance::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> DB_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceStatus").getter(getter(DBInstance::dbInstanceStatus))
            .setter(setter(Builder::dbInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceStatus").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(DBInstance::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(DBInstance::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Endpoint").getter(getter(DBInstance::endpoint)).setter(setter(Builder::endpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(DBInstance::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InstanceCreateTime").getter(getter(DBInstance::instanceCreateTime))
            .setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(DBInstance::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(DBInstance::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<List<DBSecurityGroupMembership>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<DBSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(DBInstance::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<DBSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroup").build()).build()).build()).build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(DBInstance::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupMembership")
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupMembership").build()).build()).build())
            .build();

    private static final SdkField<List<DBParameterGroupStatus>> DB_PARAMETER_GROUPS_FIELD = SdkField
            .<List<DBParameterGroupStatus>> builder(MarshallingType.LIST)
            .memberName("DBParameterGroups")
            .getter(getter(DBInstance::dbParameterGroups))
            .setter(setter(Builder::dbParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<DBParameterGroupStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBParameterGroupStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBParameterGroup").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DBInstance::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<DBSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField
            .<DBSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("DBSubnetGroup")
            .getter(getter(DBInstance::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup)).constructor(DBSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(DBInstance::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<PendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(DBInstance::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(PendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestRestorableTime").getter(getter(DBInstance::latestRestorableTime))
            .setter(setter(Builder::latestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(DBInstance::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DBInstance::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(DBInstance::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> READ_REPLICA_SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReadReplicaSourceDBInstanceIdentifier")
            .getter(getter(DBInstance::readReplicaSourceDBInstanceIdentifier))
            .setter(setter(Builder::readReplicaSourceDBInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReadReplicaSourceDBInstanceIdentifier").build()).build();

    private static final SdkField<List<String>> READ_REPLICA_DB_INSTANCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaDBInstanceIdentifiers")
            .getter(getter(DBInstance::readReplicaDBInstanceIdentifiers))
            .setter(setter(Builder::readReplicaDBInstanceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBInstanceIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReadReplicaDBInstanceIdentifier")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReadReplicaDBInstanceIdentifier").build()).build()).build())
            .build();

    private static final SdkField<List<String>> READ_REPLICA_DB_CLUSTER_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaDBClusterIdentifiers")
            .getter(getter(DBInstance::readReplicaDBClusterIdentifiers))
            .setter(setter(Builder::readReplicaDBClusterIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBClusterIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReadReplicaDBClusterIdentifier")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReadReplicaDBClusterIdentifier").build()).build()).build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(DBInstance::licenseModel)).setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(DBInstance::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<List<OptionGroupMembership>> OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<OptionGroupMembership>> builder(MarshallingType.LIST)
            .memberName("OptionGroupMemberships")
            .getter(getter(DBInstance::optionGroupMemberships))
            .setter(setter(Builder::optionGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionGroupMembership")
                            .memberFieldInfo(
                                    SdkField.<OptionGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionGroupMembership").build()).build()).build()).build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(DBInstance::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondaryAvailabilityZone").getter(getter(DBInstance::secondaryAvailabilityZone))
            .setter(setter(Builder::secondaryAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAvailabilityZone").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(DBInstance::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<DBInstanceStatusInfo>> STATUS_INFOS_FIELD = SdkField
            .<List<DBInstanceStatusInfo>> builder(MarshallingType.LIST)
            .memberName("StatusInfos")
            .getter(getter(DBInstance::statusInfos))
            .setter(setter(Builder::statusInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBInstanceStatusInfo")
                            .memberFieldInfo(
                                    SdkField.<DBInstanceStatusInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBInstanceStatusInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBInstanceStatusInfo").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(DBInstance::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(DBInstance::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<Integer> DB_INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DbInstancePort").getter(getter(DBInstance::dbInstancePort)).setter(setter(Builder::dbInstancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstancePort").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DBInstance::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(DBInstance::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DBInstance::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(DBInstance::dbiResourceId)).setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(DBInstance::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<List<DomainMembership>> DOMAIN_MEMBERSHIPS_FIELD = SdkField
            .<List<DomainMembership>> builder(MarshallingType.LIST)
            .memberName("DomainMemberships")
            .getter(getter(DBInstance::domainMemberships))
            .setter(setter(Builder::domainMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DomainMembership")
                            .memberFieldInfo(
                                    SdkField.<DomainMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DomainMembership").build()).build()).build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(DBInstance::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(DBInstance::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> ENHANCED_MONITORING_RESOURCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoringResourceArn")
            .getter(getter(DBInstance::enhancedMonitoringResourceArn))
            .setter(setter(Builder::enhancedMonitoringResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedMonitoringResourceArn")
                    .build()).build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(DBInstance::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(DBInstance::promotionTier)).setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceArn").getter(getter(DBInstance::dbInstanceArn)).setter(setter(Builder::dbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(DBInstance::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IAMDatabaseAuthenticationEnabled")
            .getter(getter(DBInstance::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<Boolean> PERFORMANCE_INSIGHTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformanceInsightsEnabled")
            .getter(getter(DBInstance::performanceInsightsEnabled))
            .setter(setter(Builder::performanceInsightsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsEnabled").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(DBInstance::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledCloudwatchLogsExports")
            .getter(getter(DBInstance::enabledCloudwatchLogsExports))
            .setter(setter(Builder::enabledCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(DBInstance::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, DB_INSTANCE_STATUS_FIELD, MASTER_USERNAME_FIELD, DB_NAME_FIELD,
            ENDPOINT_FIELD, ALLOCATED_STORAGE_FIELD, INSTANCE_CREATE_TIME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUPS_FIELD, DB_PARAMETER_GROUPS_FIELD,
            AVAILABILITY_ZONE_FIELD, DB_SUBNET_GROUP_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD,
            LATEST_RESTORABLE_TIME_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD,
            READ_REPLICA_SOURCE_DB_INSTANCE_IDENTIFIER_FIELD, READ_REPLICA_DB_INSTANCE_IDENTIFIERS_FIELD,
            READ_REPLICA_DB_CLUSTER_IDENTIFIERS_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_MEMBERSHIPS_FIELD,
            CHARACTER_SET_NAME_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD, PUBLICLY_ACCESSIBLE_FIELD, STATUS_INFOS_FIELD,
            STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, DB_INSTANCE_PORT_FIELD, DB_CLUSTER_IDENTIFIER_FIELD,
            STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DBI_RESOURCE_ID_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD,
            DOMAIN_MEMBERSHIPS_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD,
            ENHANCED_MONITORING_RESOURCE_ARN_FIELD, MONITORING_ROLE_ARN_FIELD, PROMOTION_TIER_FIELD, DB_INSTANCE_ARN_FIELD,
            TIMEZONE_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, PERFORMANCE_INSIGHTS_ENABLED_FIELD,
            PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbInstanceIdentifier;

    private final String dbInstanceClass;

    private final String engine;

    private final String dbInstanceStatus;

    private final String masterUsername;

    private final String dbName;

    private final Endpoint endpoint;

    private final Integer allocatedStorage;

    private final Instant instanceCreateTime;

    private final String preferredBackupWindow;

    private final Integer backupRetentionPeriod;

    private final List<DBSecurityGroupMembership> dbSecurityGroups;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;

    private final List<DBParameterGroupStatus> dbParameterGroups;

    private final String availabilityZone;

    private final DBSubnetGroup dbSubnetGroup;

    private final String preferredMaintenanceWindow;

    private final PendingModifiedValues pendingModifiedValues;

    private final Instant latestRestorableTime;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final String readReplicaSourceDBInstanceIdentifier;

    private final List<String> readReplicaDBInstanceIdentifiers;

    private final List<String> readReplicaDBClusterIdentifiers;

    private final String licenseModel;

    private final Integer iops;

    private final List<OptionGroupMembership> optionGroupMemberships;

    private final String characterSetName;

    private final String secondaryAvailabilityZone;

    private final Boolean publiclyAccessible;

    private final List<DBInstanceStatusInfo> statusInfos;

    private final String storageType;

    private final String tdeCredentialArn;

    private final Integer dbInstancePort;

    private final String dbClusterIdentifier;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String dbiResourceId;

    private final String caCertificateIdentifier;

    private final List<DomainMembership> domainMemberships;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final String enhancedMonitoringResourceArn;

    private final String monitoringRoleArn;

    private final Integer promotionTier;

    private final String dbInstanceArn;

    private final String timezone;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final Boolean performanceInsightsEnabled;

    private final String performanceInsightsKMSKeyId;

    private final List<String> enabledCloudwatchLogsExports;

    private final Boolean deletionProtection;

    private DBInstance(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.dbInstanceStatus = builder.dbInstanceStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.allocatedStorage = builder.allocatedStorage;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.dbParameterGroups = builder.dbParameterGroups;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.readReplicaSourceDBInstanceIdentifier = builder.readReplicaSourceDBInstanceIdentifier;
        this.readReplicaDBInstanceIdentifiers = builder.readReplicaDBInstanceIdentifiers;
        this.readReplicaDBClusterIdentifiers = builder.readReplicaDBClusterIdentifiers;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupMemberships = builder.optionGroupMemberships;
        this.characterSetName = builder.characterSetName;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.statusInfos = builder.statusInfos;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.dbInstancePort = builder.dbInstancePort;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbiResourceId = builder.dbiResourceId;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domainMemberships = builder.domainMemberships;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.enhancedMonitoringResourceArn = builder.enhancedMonitoringResourceArn;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.promotionTier = builder.promotionTier;
        this.dbInstanceArn = builder.dbInstanceArn;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.performanceInsightsEnabled = builder.performanceInsightsEnabled;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     * </p>
     * 
     * @return Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
     *         instance.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Contains the name of the compute and memory capacity class of the DB instance.
     * </p>
     * 
     * @return Contains the name of the compute and memory capacity class of the DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Provides the name of the database engine to be used for this DB instance.
     * </p>
     * 
     * @return Provides the name of the database engine to be used for this DB instance.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Specifies the current state of this database.
     * </p>
     * 
     * @return Specifies the current state of this database.
     */
    public final String dbInstanceStatus() {
        return dbInstanceStatus;
    }

    /**
     * <p>
     * Contains the master username for the DB instance.
     * </p>
     * 
     * @return Contains the master username for the DB instance.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The database name.
     * </p>
     * 
     * @return The database name.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * Specifies the connection endpoint.
     * </p>
     * 
     * @return Specifies the connection endpoint.
     */
    public final Endpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Specifies the allocated storage size specified in gibibytes.
     * </p>
     * 
     * @return Specifies the allocated storage size specified in gibibytes.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Provides the date and time the DB instance was created.
     * </p>
     * 
     * @return Provides the date and time the DB instance was created.
     */
    public final Instant instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as
     * determined by the <code>BackupRetentionPeriod</code>.
     * </p>
     * 
     * @return Specifies the daily time range during which automated backups are created if automated backups are
     *         enabled, as determined by the <code>BackupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * Specifies the number of days for which automatic DB snapshots are retained.
     * </p>
     * 
     * @return Specifies the number of days for which automatic DB snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * Returns true if the DBSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
     * <code>DBSecurityGroup.Status</code> subelements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
     *         <code>DBSecurityGroup.Status</code> subelements.
     */
    public final List<DBSecurityGroupMembership> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * Returns true if the VpcSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of VPC security group elements that the DB instance belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides a list of VPC security group elements that the DB instance belongs to.
     */
    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * Returns true if the DBParameterGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbParameterGroups() {
        return dbParameterGroups != null && !(dbParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of DB parameter groups applied to this DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbParameterGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the list of DB parameter groups applied to this DB instance.
     */
    public final List<DBParameterGroupStatus> dbParameterGroups() {
        return dbParameterGroups;
    }

    /**
     * <p>
     * Specifies the name of the Availability Zone the DB instance is located in.
     * </p>
     * 
     * @return Specifies the name of the Availability Zone the DB instance is located in.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Specifies information on the subnet group associated with the DB instance, including the name, description, and
     * subnets in the subnet group.
     * </p>
     * 
     * @return Specifies information on the subnet group associated with the DB instance, including the name,
     *         description, and subnets in the subnet group.
     */
    public final DBSubnetGroup dbSubnetGroup() {
        return dbSubnetGroup;
    }

    /**
     * <p>
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
     *         (UTC).
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies that changes to the DB instance are pending. This element is only included when changes are pending.
     * Specific changes are identified by subelements.
     * </p>
     * 
     * @return Specifies that changes to the DB instance are pending. This element is only included when changes are
     *         pending. Specific changes are identified by subelements.
     */
    public final PendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     * </p>
     * 
     * @return Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public final Instant latestRestorableTime() {
        return latestRestorableTime;
    }

    /**
     * <p>
     * Specifies if the DB instance is a Multi-AZ deployment.
     * </p>
     * 
     * @return Specifies if the DB instance is a Multi-AZ deployment.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Indicates that minor version patches are applied automatically.
     * </p>
     * 
     * @return Indicates that minor version patches are applied automatically.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Contains the identifier of the source DB instance if this DB instance is a Read Replica.
     * </p>
     * 
     * @return Contains the identifier of the source DB instance if this DB instance is a Read Replica.
     */
    public final String readReplicaSourceDBInstanceIdentifier() {
        return readReplicaSourceDBInstanceIdentifier;
    }

    /**
     * Returns true if the ReadReplicaDBInstanceIdentifiers property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasReadReplicaDBInstanceIdentifiers() {
        return readReplicaDBInstanceIdentifiers != null && !(readReplicaDBInstanceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains one or more identifiers of the Read Replicas associated with this DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReadReplicaDBInstanceIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains one or more identifiers of the Read Replicas associated with this DB instance.
     */
    public final List<String> readReplicaDBInstanceIdentifiers() {
        return readReplicaDBInstanceIdentifiers;
    }

    /**
     * Returns true if the ReadReplicaDBClusterIdentifiers property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasReadReplicaDBClusterIdentifiers() {
        return readReplicaDBClusterIdentifiers != null && !(readReplicaDBClusterIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReadReplicaDBClusterIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
     */
    public final List<String> readReplicaDBClusterIdentifiers() {
        return readReplicaDBClusterIdentifiers;
    }

    /**
     * <p>
     * License model information for this DB instance.
     * </p>
     * 
     * @return License model information for this DB instance.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * Specifies the Provisioned IOPS (I/O operations per second) value.
     * </p>
     * 
     * @return Specifies the Provisioned IOPS (I/O operations per second) value.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * Returns true if the OptionGroupMemberships property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOptionGroupMemberships() {
        return optionGroupMemberships != null && !(optionGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptionGroupMemberships()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final List<OptionGroupMembership> optionGroupMemberships() {
        return optionGroupMemberships;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
     * </p>
     * 
     * @return If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ
     *         support.
     */
    public final String secondaryAvailabilityZone() {
        return secondaryAvailabilityZone;
    }

    /**
     * <p>
     * This flag should no longer be used.
     * </p>
     * 
     * @return This flag should no longer be used.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * Returns true if the StatusInfos property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStatusInfos() {
        return statusInfos != null && !(statusInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of a Read Replica. If the instance is not a Read Replica, this is blank.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatusInfos()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of a Read Replica. If the instance is not a Read Replica, this is blank.
     */
    public final List<DBInstanceStatusInfo> statusInfos() {
        return statusInfos;
    }

    /**
     * <p>
     * Specifies the storage type associated with DB instance.
     * </p>
     * 
     * @return Specifies the storage type associated with DB instance.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The ARN from the key store with which the instance is associated for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which the instance is associated for TDE encryption.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
     * different port than the DB cluster port.
     * </p>
     * 
     * @return Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can
     *         be a different port than the DB cluster port.
     */
    public final Integer dbInstancePort() {
        return dbInstancePort;
    }

    /**
     * <p>
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
     * member of.
     * </p>
     * 
     * @return If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance
     *         is a member of.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Not supported: The encryption for DB instances is managed by the DB cluster.
     * </p>
     * 
     * @return Not supported: The encryption for DB instances is managed by the DB cluster.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * Not supported: The encryption for DB instances is managed by the DB cluster.
     * </p>
     * 
     * @return Not supported: The encryption for DB instances is managed by the DB cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log
     * entries whenever the AWS KMS key for the DB instance is accessed.
     * </p>
     * 
     * @return The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS
     *         CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The identifier of the CA certificate for this DB instance.
     * </p>
     * 
     * @return The identifier of the CA certificate for this DB instance.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * Returns true if the DomainMemberships property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDomainMemberships() {
        return domainMemberships != null && !(domainMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Not supported
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainMemberships()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Not supported
     */
    public final List<DomainMembership> domainMemberships() {
        return domainMemberships;
    }

    /**
     * <p>
     * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
     * </p>
     * 
     * @return Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         instance.
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring
     * metrics data for the DB instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced
     *         Monitoring metrics data for the DB instance.
     */
    public final String enhancedMonitoringResourceArn() {
        return enhancedMonitoringResourceArn;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch
     *         Logs.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of
     * the existing primary instance.
     * </p>
     * 
     * @return A value that specifies the order in which a Read Replica is promoted to the primary instance after a
     *         failure of the existing primary instance.
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the DB instance.
     */
    public final String dbInstanceArn() {
        return dbInstanceArn;
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * 
     * @return Not supported.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * True if AWS Identity and Access Management (IAM) authentication is enabled, and otherwise false.
     * </p>
     * 
     * @return True if AWS Identity and Access Management (IAM) authentication is enabled, and otherwise false.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final Boolean performanceInsightsEnabled() {
        return performanceInsightsEnabled;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * Returns true if the EnabledCloudwatchLogsExports property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasEnabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports != null && !(enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that this DB instance is configured to export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnabledCloudwatchLogsExports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of log types that this DB instance is configured to export to CloudWatch Logs.
     */
    public final List<String> enabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports;
    }

    /**
     * <p>
     * Indicates whether or not the DB instance has deletion protection enabled. The instance can't be deleted when
     * deletion protection is enabled. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB
     * Instance</a>.
     * </p>
     * 
     * @return Indicates whether or not the DB instance has deletion protection enabled. The instance can't be deleted
     *         when deletion protection is enabled. See <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
     *         a DB Instance</a>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDbParameterGroups() ? dbParameterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(readReplicaSourceDBInstanceIdentifier());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReadReplicaDBInstanceIdentifiers() ? readReplicaDBInstanceIdentifiers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReadReplicaDBClusterIdentifiers() ? readReplicaDBClusterIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionGroupMemberships() ? optionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusInfos() ? statusInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstancePort());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainMemberships() ? domainMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(engine(), other.engine())
                && Objects.equals(dbInstanceStatus(), other.dbInstanceStatus())
                && Objects.equals(masterUsername(), other.masterUsername()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && hasDbParameterGroups() == other.hasDbParameterGroups()
                && Objects.equals(dbParameterGroups(), other.dbParameterGroups())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dbSubnetGroup(), other.dbSubnetGroup())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(latestRestorableTime(), other.latestRestorableTime())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(readReplicaSourceDBInstanceIdentifier(), other.readReplicaSourceDBInstanceIdentifier())
                && hasReadReplicaDBInstanceIdentifiers() == other.hasReadReplicaDBInstanceIdentifiers()
                && Objects.equals(readReplicaDBInstanceIdentifiers(), other.readReplicaDBInstanceIdentifiers())
                && hasReadReplicaDBClusterIdentifiers() == other.hasReadReplicaDBClusterIdentifiers()
                && Objects.equals(readReplicaDBClusterIdentifiers(), other.readReplicaDBClusterIdentifiers())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && hasOptionGroupMemberships() == other.hasOptionGroupMemberships()
                && Objects.equals(optionGroupMemberships(), other.optionGroupMemberships())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(secondaryAvailabilityZone(), other.secondaryAvailabilityZone())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasStatusInfos() == other.hasStatusInfos()
                && Objects.equals(statusInfos(), other.statusInfos()) && Objects.equals(storageType(), other.storageType())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && Objects.equals(dbInstancePort(), other.dbInstancePort())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dbiResourceId(), other.dbiResourceId())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && hasDomainMemberships() == other.hasDomainMemberships()
                && Objects.equals(domainMemberships(), other.domainMemberships())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(enhancedMonitoringResourceArn(), other.enhancedMonitoringResourceArn())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(promotionTier(), other.promotionTier())
                && Objects.equals(dbInstanceArn(), other.dbInstanceArn()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(performanceInsightsEnabled(), other.performanceInsightsEnabled())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports()
                && Objects.equals(enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DBInstance")
                .add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("DBInstanceClass", dbInstanceClass())
                .add("Engine", engine())
                .add("DBInstanceStatus", dbInstanceStatus())
                .add("MasterUsername", masterUsername())
                .add("DBName", dbName())
                .add("Endpoint", endpoint())
                .add("AllocatedStorage", allocatedStorage())
                .add("InstanceCreateTime", instanceCreateTime())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("DBParameterGroups", hasDbParameterGroups() ? dbParameterGroups() : null)
                .add("AvailabilityZone", availabilityZone())
                .add("DBSubnetGroup", dbSubnetGroup())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PendingModifiedValues", pendingModifiedValues())
                .add("LatestRestorableTime", latestRestorableTime())
                .add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("ReadReplicaSourceDBInstanceIdentifier", readReplicaSourceDBInstanceIdentifier())
                .add("ReadReplicaDBInstanceIdentifiers",
                        hasReadReplicaDBInstanceIdentifiers() ? readReplicaDBInstanceIdentifiers() : null)
                .add("ReadReplicaDBClusterIdentifiers",
                        hasReadReplicaDBClusterIdentifiers() ? readReplicaDBClusterIdentifiers() : null)
                .add("LicenseModel", licenseModel()).add("Iops", iops())
                .add("OptionGroupMemberships", hasOptionGroupMemberships() ? optionGroupMemberships() : null)
                .add("CharacterSetName", characterSetName()).add("SecondaryAvailabilityZone", secondaryAvailabilityZone())
                .add("PubliclyAccessible", publiclyAccessible()).add("StatusInfos", hasStatusInfos() ? statusInfos() : null)
                .add("StorageType", storageType()).add("TdeCredentialArn", tdeCredentialArn())
                .add("DbInstancePort", dbInstancePort()).add("DBClusterIdentifier", dbClusterIdentifier())
                .add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId()).add("DbiResourceId", dbiResourceId())
                .add("CACertificateIdentifier", caCertificateIdentifier())
                .add("DomainMemberships", hasDomainMemberships() ? domainMemberships() : null)
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).add("MonitoringInterval", monitoringInterval())
                .add("EnhancedMonitoringResourceArn", enhancedMonitoringResourceArn())
                .add("MonitoringRoleArn", monitoringRoleArn()).add("PromotionTier", promotionTier())
                .add("DBInstanceArn", dbInstanceArn()).add("Timezone", timezone())
                .add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("PerformanceInsightsEnabled", performanceInsightsEnabled())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("EnabledCloudwatchLogsExports", hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null)
                .add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "DBInstanceStatus":
            return Optional.ofNullable(clazz.cast(dbInstanceStatus()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "DBParameterGroups":
            return Optional.ofNullable(clazz.cast(dbParameterGroups()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DBSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "LatestRestorableTime":
            return Optional.ofNullable(clazz.cast(latestRestorableTime()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "ReadReplicaSourceDBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(readReplicaSourceDBInstanceIdentifier()));
        case "ReadReplicaDBInstanceIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaDBInstanceIdentifiers()));
        case "ReadReplicaDBClusterIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaDBClusterIdentifiers()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupMemberships":
            return Optional.ofNullable(clazz.cast(optionGroupMemberships()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "SecondaryAvailabilityZone":
            return Optional.ofNullable(clazz.cast(secondaryAvailabilityZone()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "StatusInfos":
            return Optional.ofNullable(clazz.cast(statusInfos()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "DbInstancePort":
            return Optional.ofNullable(clazz.cast(dbInstancePort()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "DomainMemberships":
            return Optional.ofNullable(clazz.cast(domainMemberships()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "EnhancedMonitoringResourceArn":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringResourceArn()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "DBInstanceArn":
            return Optional.ofNullable(clazz.cast(dbInstanceArn()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "PerformanceInsightsEnabled":
            return Optional.ofNullable(clazz.cast(performanceInsightsEnabled()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "EnabledCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enabledCloudwatchLogsExports()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstance, T> g) {
        return obj -> g.apply((DBInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBInstance> {
        /**
         * <p>
         * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
         * instance.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Contains the name of the compute and memory capacity class of the DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        Contains the name of the compute and memory capacity class of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Provides the name of the database engine to be used for this DB instance.
         * </p>
         * 
         * @param engine
         *        Provides the name of the database engine to be used for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Specifies the current state of this database.
         * </p>
         * 
         * @param dbInstanceStatus
         *        Specifies the current state of this database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceStatus(String dbInstanceStatus);

        /**
         * <p>
         * Contains the master username for the DB instance.
         * </p>
         * 
         * @param masterUsername
         *        Contains the master username for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The database name.
         * </p>
         * 
         * @param dbName
         *        The database name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * 
         * @param endpoint
         *        Specifies the connection endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * Specifies the allocated storage size specified in gibibytes.
         * </p>
         * 
         * @param allocatedStorage
         *        Specifies the allocated storage size specified in gibibytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Provides the date and time the DB instance was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        Provides the date and time the DB instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(Instant instanceCreateTime);

        /**
         * <p>
         * Specifies the daily time range during which automated backups are created if automated backups are enabled,
         * as determined by the <code>BackupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        Specifies the daily time range during which automated backups are created if automated backups are
         *        enabled, as determined by the <code>BackupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * Specifies the number of days for which automatic DB snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        Specifies the number of days for which automatic DB snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
         * <code>DBSecurityGroup.Status</code> subelements.
         * </p>
         * 
         * @param dbSecurityGroups
         *        Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
         *        <code>DBSecurityGroup.Status</code> subelements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<DBSecurityGroupMembership> dbSecurityGroups);

        /**
         * <p>
         * Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
         * <code>DBSecurityGroup.Status</code> subelements.
         * </p>
         * 
         * @param dbSecurityGroups
         *        Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
         *        <code>DBSecurityGroup.Status</code> subelements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(DBSecurityGroupMembership... dbSecurityGroups);

        /**
         * <p>
         * Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
         * <code>DBSecurityGroup.Status</code> subelements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<DBSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #dbSecurityGroups(List<DBSecurityGroupMembership>)}.
         * 
         * @param dbSecurityGroups
         *        a consumer that will call methods on {@link List<DBSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSecurityGroups(List<DBSecurityGroupMembership>)
         */
        Builder dbSecurityGroups(Consumer<DBSecurityGroupMembership.Builder>... dbSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security group elements that the DB instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of VPC security group elements that the DB instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security group elements that the DB instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of VPC security group elements that the DB instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security group elements that the DB instance belongs to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<VpcSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcSecurityGroups(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on {@link List<VpcSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(List<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Provides the list of DB parameter groups applied to this DB instance.
         * </p>
         * 
         * @param dbParameterGroups
         *        Provides the list of DB parameter groups applied to this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroups(Collection<DBParameterGroupStatus> dbParameterGroups);

        /**
         * <p>
         * Provides the list of DB parameter groups applied to this DB instance.
         * </p>
         * 
         * @param dbParameterGroups
         *        Provides the list of DB parameter groups applied to this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroups(DBParameterGroupStatus... dbParameterGroups);

        /**
         * <p>
         * Provides the list of DB parameter groups applied to this DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBParameterGroupStatus>.Builder} avoiding
         * the need to create one manually via {@link List<DBParameterGroupStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBParameterGroupStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #dbParameterGroups(List<DBParameterGroupStatus>)}.
         * 
         * @param dbParameterGroups
         *        a consumer that will call methods on {@link List<DBParameterGroupStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbParameterGroups(List<DBParameterGroupStatus>)
         */
        Builder dbParameterGroups(Consumer<DBParameterGroupStatus.Builder>... dbParameterGroups);

        /**
         * <p>
         * Specifies the name of the Availability Zone the DB instance is located in.
         * </p>
         * 
         * @param availabilityZone
         *        Specifies the name of the Availability Zone the DB instance is located in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Specifies information on the subnet group associated with the DB instance, including the name, description,
         * and subnets in the subnet group.
         * </p>
         * 
         * @param dbSubnetGroup
         *        Specifies information on the subnet group associated with the DB instance, including the name,
         *        description, and subnets in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup);

        /**
         * <p>
         * Specifies information on the subnet group associated with the DB instance, including the name, description,
         * and subnets in the subnet group.
         * </p>
         * This is a convenience that creates an instance of the {@link DBSubnetGroup.Builder} avoiding the need to
         * create one manually via {@link DBSubnetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBSubnetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #dbSubnetGroup(DBSubnetGroup)}.
         * 
         * @param dbSubnetGroup
         *        a consumer that will call methods on {@link DBSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroup(DBSubnetGroup)
         */
        default Builder dbSubnetGroup(Consumer<DBSubnetGroup.Builder> dbSubnetGroup) {
            return dbSubnetGroup(DBSubnetGroup.builder().applyMutation(dbSubnetGroup).build());
        }

        /**
         * <p>
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
         * (UTC).
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies that changes to the DB instance are pending. This element is only included when changes are
         * pending. Specific changes are identified by subelements.
         * </p>
         * 
         * @param pendingModifiedValues
         *        Specifies that changes to the DB instance are pending. This element is only included when changes are
         *        pending. Specific changes are identified by subelements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * Specifies that changes to the DB instance are pending. This element is only included when changes are
         * pending. Specific changes are identified by subelements.
         * </p>
         * This is a convenience that creates an instance of the {@link PendingModifiedValues.Builder} avoiding the need
         * to create one manually via {@link PendingModifiedValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link PendingModifiedValues.Builder#build()} is called immediately and
         * its result is passed to {@link #pendingModifiedValues(PendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link PendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(PendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(PendingModifiedValues.builder().applyMutation(pendingModifiedValues).build());
        }

        /**
         * <p>
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         * </p>
         * 
         * @param latestRestorableTime
         *        Specifies the latest time to which a database can be restored with point-in-time restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableTime(Instant latestRestorableTime);

        /**
         * <p>
         * Specifies if the DB instance is a Multi-AZ deployment.
         * </p>
         * 
         * @param multiAZ
         *        Specifies if the DB instance is a Multi-AZ deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Indicates that minor version patches are applied automatically.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Indicates that minor version patches are applied automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Contains the identifier of the source DB instance if this DB instance is a Read Replica.
         * </p>
         * 
         * @param readReplicaSourceDBInstanceIdentifier
         *        Contains the identifier of the source DB instance if this DB instance is a Read Replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier);

        /**
         * <p>
         * Contains one or more identifiers of the Read Replicas associated with this DB instance.
         * </p>
         * 
         * @param readReplicaDBInstanceIdentifiers
         *        Contains one or more identifiers of the Read Replicas associated with this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers);

        /**
         * <p>
         * Contains one or more identifiers of the Read Replicas associated with this DB instance.
         * </p>
         * 
         * @param readReplicaDBInstanceIdentifiers
         *        Contains one or more identifiers of the Read Replicas associated with this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBInstanceIdentifiers(String... readReplicaDBInstanceIdentifiers);

        /**
         * <p>
         * Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
         * </p>
         * 
         * @param readReplicaDBClusterIdentifiers
         *        Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers);

        /**
         * <p>
         * Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
         * </p>
         * 
         * @param readReplicaDBClusterIdentifiers
         *        Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBClusterIdentifiers(String... readReplicaDBClusterIdentifiers);

        /**
         * <p>
         * License model information for this DB instance.
         * </p>
         * 
         * @param licenseModel
         *        License model information for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * Specifies the Provisioned IOPS (I/O operations per second) value.
         * </p>
         * 
         * @param iops
         *        Specifies the Provisioned IOPS (I/O operations per second) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param optionGroupMemberships
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param optionGroupMemberships
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupMemberships(OptionGroupMembership... optionGroupMemberships);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionGroupMembership>.Builder} avoiding
         * the need to create one manually via {@link List<OptionGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #optionGroupMemberships(List<OptionGroupMembership>)}.
         * 
         * @param optionGroupMemberships
         *        a consumer that will call methods on {@link List<OptionGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroupMemberships(List<OptionGroupMembership>)
         */
        Builder optionGroupMemberships(Consumer<OptionGroupMembership.Builder>... optionGroupMemberships);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param characterSetName
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
         * </p>
         * 
         * @param secondaryAvailabilityZone
         *        If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ
         *        support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAvailabilityZone(String secondaryAvailabilityZone);

        /**
         * <p>
         * This flag should no longer be used.
         * </p>
         * 
         * @param publiclyAccessible
         *        This flag should no longer be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The status of a Read Replica. If the instance is not a Read Replica, this is blank.
         * </p>
         * 
         * @param statusInfos
         *        The status of a Read Replica. If the instance is not a Read Replica, this is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos);

        /**
         * <p>
         * The status of a Read Replica. If the instance is not a Read Replica, this is blank.
         * </p>
         * 
         * @param statusInfos
         *        The status of a Read Replica. If the instance is not a Read Replica, this is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInfos(DBInstanceStatusInfo... statusInfos);

        /**
         * <p>
         * The status of a Read Replica. If the instance is not a Read Replica, this is blank.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBInstanceStatusInfo>.Builder} avoiding the
         * need to create one manually via {@link List<DBInstanceStatusInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBInstanceStatusInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #statusInfos(List<DBInstanceStatusInfo>)}.
         * 
         * @param statusInfos
         *        a consumer that will call methods on {@link List<DBInstanceStatusInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusInfos(List<DBInstanceStatusInfo>)
         */
        Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder>... statusInfos);

        /**
         * <p>
         * Specifies the storage type associated with DB instance.
         * </p>
         * 
         * @param storageType
         *        Specifies the storage type associated with DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The ARN from the key store with which the instance is associated for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which the instance is associated for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
         * different port than the DB cluster port.
         * </p>
         * 
         * @param dbInstancePort
         *        Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this
         *        can be a different port than the DB cluster port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstancePort(Integer dbInstancePort);

        /**
         * <p>
         * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
         * member of.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB
         *        instance is a member of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Not supported: The encryption for DB instances is managed by the DB cluster.
         * </p>
         * 
         * @param storageEncrypted
         *        Not supported: The encryption for DB instances is managed by the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * Not supported: The encryption for DB instances is managed by the DB cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        Not supported: The encryption for DB instances is managed by the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail
         * log entries whenever the AWS KMS key for the DB instance is accessed.
         * </p>
         * 
         * @param dbiResourceId
         *        The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS
         *        CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The identifier of the CA certificate for this DB instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The identifier of the CA certificate for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * Not supported
         * </p>
         * 
         * @param domainMemberships
         *        Not supported
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainMemberships(Collection<DomainMembership> domainMemberships);

        /**
         * <p>
         * Not supported
         * </p>
         * 
         * @param domainMemberships
         *        Not supported
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainMemberships(DomainMembership... domainMemberships);

        /**
         * <p>
         * Not supported
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainMembership>.Builder} avoiding the
         * need to create one manually via {@link List<DomainMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainMembership>.Builder#build()} is called immediately and
         * its result is passed to {@link #domainMemberships(List<DomainMembership>)}.
         * 
         * @param domainMemberships
         *        a consumer that will call methods on {@link List<DomainMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainMemberships(List<DomainMembership>)
         */
        Builder domainMemberships(Consumer<DomainMembership.Builder>... domainMemberships);

        /**
         * <p>
         * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring
         * metrics data for the DB instance.
         * </p>
         * 
         * @param enhancedMonitoringResourceArn
         *        The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced
         *        Monitoring metrics data for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedMonitoringResourceArn(String enhancedMonitoringResourceArn);

        /**
         * <p>
         * The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch
         *        Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure
         * of the existing primary instance.
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which a Read Replica is promoted to the primary instance after a
         *        failure of the existing primary instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the DB instance.
         * </p>
         * 
         * @param dbInstanceArn
         *        The Amazon Resource Name (ARN) for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceArn(String dbInstanceArn);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param timezone
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * True if AWS Identity and Access Management (IAM) authentication is enabled, and otherwise false.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        True if AWS Identity and Access Management (IAM) authentication is enabled, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param performanceInsightsEnabled
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports);

        /**
         * <p>
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports);

        /**
         * <p>
         * Indicates whether or not the DB instance has deletion protection enabled. The instance can't be deleted when
         * deletion protection is enabled. See <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a
         * DB Instance</a>.
         * </p>
         * 
         * @param deletionProtection
         *        Indicates whether or not the DB instance has deletion protection enabled. The instance can't be
         *        deleted when deletion protection is enabled. See <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html"
         *        >Deleting a DB Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String dbInstanceClass;

        private String engine;

        private String dbInstanceStatus;

        private String masterUsername;

        private String dbName;

        private Endpoint endpoint;

        private Integer allocatedStorage;

        private Instant instanceCreateTime;

        private String preferredBackupWindow;

        private Integer backupRetentionPeriod;

        private List<DBSecurityGroupMembership> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<DBParameterGroupStatus> dbParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private DBSubnetGroup dbSubnetGroup;

        private String preferredMaintenanceWindow;

        private PendingModifiedValues pendingModifiedValues;

        private Instant latestRestorableTime;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private String readReplicaSourceDBInstanceIdentifier;

        private List<String> readReplicaDBInstanceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> readReplicaDBClusterIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String licenseModel;

        private Integer iops;

        private List<OptionGroupMembership> optionGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private String characterSetName;

        private String secondaryAvailabilityZone;

        private Boolean publiclyAccessible;

        private List<DBInstanceStatusInfo> statusInfos = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private String tdeCredentialArn;

        private Integer dbInstancePort;

        private String dbClusterIdentifier;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String dbiResourceId;

        private String caCertificateIdentifier;

        private List<DomainMembership> domainMemberships = DefaultSdkAutoConstructList.getInstance();

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private String enhancedMonitoringResourceArn;

        private String monitoringRoleArn;

        private Integer promotionTier;

        private String dbInstanceArn;

        private String timezone;

        private Boolean iamDatabaseAuthenticationEnabled;

        private Boolean performanceInsightsEnabled;

        private String performanceInsightsKMSKeyId;

        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstance model) {
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbInstanceClass(model.dbInstanceClass);
            engine(model.engine);
            dbInstanceStatus(model.dbInstanceStatus);
            masterUsername(model.masterUsername);
            dbName(model.dbName);
            endpoint(model.endpoint);
            allocatedStorage(model.allocatedStorage);
            instanceCreateTime(model.instanceCreateTime);
            preferredBackupWindow(model.preferredBackupWindow);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbSecurityGroups(model.dbSecurityGroups);
            vpcSecurityGroups(model.vpcSecurityGroups);
            dbParameterGroups(model.dbParameterGroups);
            availabilityZone(model.availabilityZone);
            dbSubnetGroup(model.dbSubnetGroup);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            pendingModifiedValues(model.pendingModifiedValues);
            latestRestorableTime(model.latestRestorableTime);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            readReplicaSourceDBInstanceIdentifier(model.readReplicaSourceDBInstanceIdentifier);
            readReplicaDBInstanceIdentifiers(model.readReplicaDBInstanceIdentifiers);
            readReplicaDBClusterIdentifiers(model.readReplicaDBClusterIdentifiers);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupMemberships(model.optionGroupMemberships);
            characterSetName(model.characterSetName);
            secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            publiclyAccessible(model.publiclyAccessible);
            statusInfos(model.statusInfos);
            storageType(model.storageType);
            tdeCredentialArn(model.tdeCredentialArn);
            dbInstancePort(model.dbInstancePort);
            dbClusterIdentifier(model.dbClusterIdentifier);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            dbiResourceId(model.dbiResourceId);
            caCertificateIdentifier(model.caCertificateIdentifier);
            domainMemberships(model.domainMemberships);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            enhancedMonitoringResourceArn(model.enhancedMonitoringResourceArn);
            monitoringRoleArn(model.monitoringRoleArn);
            promotionTier(model.promotionTier);
            dbInstanceArn(model.dbInstanceArn);
            timezone(model.timezone);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            performanceInsightsEnabled(model.performanceInsightsEnabled);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
            deletionProtection(model.deletionProtection);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getDbInstanceStatus() {
            return dbInstanceStatus;
        }

        @Override
        public final Builder dbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
            return this;
        }

        public final void setDbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getDbName() {
            return dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Instant getInstanceCreateTime() {
            return instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final Collection<DBSecurityGroupMembership.Builder> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups != null ? dbSecurityGroups.stream().map(DBSecurityGroupMembership::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroupMembership> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroupMembership... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(Consumer<DBSecurityGroupMembership.Builder>... dbSecurityGroups) {
            dbSecurityGroups(Stream.of(dbSecurityGroups).map(c -> DBSecurityGroupMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbSecurityGroups(Collection<DBSecurityGroupMembership.BuilderImpl> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupMembershipListCopier.copyFromBuilder(dbSecurityGroups);
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            if (vpcSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroups != null ? vpcSecurityGroups.stream().map(VpcSecurityGroupMembership::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final Collection<DBParameterGroupStatus.Builder> getDbParameterGroups() {
            if (dbParameterGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbParameterGroups != null ? dbParameterGroups.stream().map(DBParameterGroupStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroupStatus> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupStatusListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroupStatus... dbParameterGroups) {
            dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<DBParameterGroupStatus.Builder>... dbParameterGroups) {
            dbParameterGroups(Stream.of(dbParameterGroups).map(c -> DBParameterGroupStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbParameterGroups(Collection<DBParameterGroupStatus.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupStatusListCopier.copyFromBuilder(dbParameterGroups);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final DBSubnetGroup.Builder getDbSubnetGroup() {
            return dbSubnetGroup != null ? dbSubnetGroup.toBuilder() : null;
        }

        @Override
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDbSubnetGroup(DBSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final Instant getLatestRestorableTime() {
            return latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getReadReplicaSourceDBInstanceIdentifier() {
            return readReplicaSourceDBInstanceIdentifier;
        }

        @Override
        public final Builder readReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
            return this;
        }

        public final void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
        }

        public final Collection<String> getReadReplicaDBInstanceIdentifiers() {
            if (readReplicaDBInstanceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaDBInstanceIdentifiers;
        }

        @Override
        public final Builder readReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = ReadReplicaDBInstanceIdentifierListCopier
                    .copy(readReplicaDBInstanceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBInstanceIdentifiers(String... readReplicaDBInstanceIdentifiers) {
            readReplicaDBInstanceIdentifiers(Arrays.asList(readReplicaDBInstanceIdentifiers));
            return this;
        }

        public final void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = ReadReplicaDBInstanceIdentifierListCopier
                    .copy(readReplicaDBInstanceIdentifiers);
        }

        public final Collection<String> getReadReplicaDBClusterIdentifiers() {
            if (readReplicaDBClusterIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaDBClusterIdentifiers;
        }

        @Override
        public final Builder readReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = ReadReplicaDBClusterIdentifierListCopier.copy(readReplicaDBClusterIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBClusterIdentifiers(String... readReplicaDBClusterIdentifiers) {
            readReplicaDBClusterIdentifiers(Arrays.asList(readReplicaDBClusterIdentifiers));
            return this;
        }

        public final void setReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = ReadReplicaDBClusterIdentifierListCopier.copy(readReplicaDBClusterIdentifiers);
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Collection<OptionGroupMembership.Builder> getOptionGroupMemberships() {
            if (optionGroupMemberships instanceof SdkAutoConstructList) {
                return null;
            }
            return optionGroupMemberships != null ? optionGroupMemberships.stream().map(OptionGroupMembership::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
            this.optionGroupMemberships = OptionGroupMembershipListCopier.copy(optionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(OptionGroupMembership... optionGroupMemberships) {
            optionGroupMemberships(Arrays.asList(optionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(Consumer<OptionGroupMembership.Builder>... optionGroupMemberships) {
            optionGroupMemberships(Stream.of(optionGroupMemberships)
                    .map(c -> OptionGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionGroupMemberships(Collection<OptionGroupMembership.BuilderImpl> optionGroupMemberships) {
            this.optionGroupMemberships = OptionGroupMembershipListCopier.copyFromBuilder(optionGroupMemberships);
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getSecondaryAvailabilityZone() {
            return secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<DBInstanceStatusInfo.Builder> getStatusInfos() {
            if (statusInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return statusInfos != null ? statusInfos.stream().map(DBInstanceStatusInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copy(statusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(DBInstanceStatusInfo... statusInfos) {
            statusInfos(Arrays.asList(statusInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder>... statusInfos) {
            statusInfos(Stream.of(statusInfos).map(c -> DBInstanceStatusInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatusInfos(Collection<DBInstanceStatusInfo.BuilderImpl> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copyFromBuilder(statusInfos);
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Integer getDbInstancePort() {
            return dbInstancePort;
        }

        @Override
        public final Builder dbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
            return this;
        }

        public final void setDbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final Collection<DomainMembership.Builder> getDomainMemberships() {
            if (domainMemberships instanceof SdkAutoConstructList) {
                return null;
            }
            return domainMemberships != null ? domainMemberships.stream().map(DomainMembership::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainMemberships(Collection<DomainMembership> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(DomainMembership... domainMemberships) {
            domainMemberships(Arrays.asList(domainMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(Consumer<DomainMembership.Builder>... domainMemberships) {
            domainMemberships(Stream.of(domainMemberships).map(c -> DomainMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainMemberships(Collection<DomainMembership.BuilderImpl> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copyFromBuilder(domainMemberships);
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getEnhancedMonitoringResourceArn() {
            return enhancedMonitoringResourceArn;
        }

        @Override
        public final Builder enhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
            return this;
        }

        public final void setEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final String getDbInstanceArn() {
            return dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final Boolean getPerformanceInsightsEnabled() {
            return performanceInsightsEnabled;
        }

        @Override
        public final Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        public final void setPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledCloudwatchLogsExports;
        }

        @Override
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports) {
            enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public DBInstance build() {
            return new DBInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
