/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.model.DBEngineVersion;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;

public class DescribeDBEngineVersionsPublisher
implements SdkPublisher<DescribeDbEngineVersionsResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBEngineVersionsPublisher(NeptuneAsyncClient client, DescribeDbEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBEngineVersionsPublisher(NeptuneAsyncClient client, DescribeDbEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbEngineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBEngineVersion> dbEngineVersions() {
        Function<DescribeDbEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbEngineVersions() != null) {
                return response.dbEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbEngineVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbEngineVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeDbEngineVersionsResponse> {
        private DescribeDbEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbEngineVersionsResponse> nextPage(DescribeDbEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBEngineVersionsPublisher.this.client.describeDBEngineVersions(DescribeDBEngineVersionsPublisher.this.firstRequest);
            }
            return DescribeDBEngineVersionsPublisher.this.client.describeDBEngineVersions((DescribeDbEngineVersionsRequest)((Object)DescribeDBEngineVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

