/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterToPointInTimeRequest extends NeptuneRequest implements
        ToCopyableBuilder<RestoreDbClusterToPointInTimeRequest.Builder, RestoreDbClusterToPointInTimeRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(RestoreDbClusterToPointInTimeRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> RESTORE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreType").getter(getter(RestoreDbClusterToPointInTimeRequest::restoreType))
            .setter(setter(Builder::restoreType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreType").build()).build();

    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBClusterIdentifier")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::sourceDBClusterIdentifier))
            .setter(setter(Builder::sourceDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build())
            .build();

    private static final SdkField<Instant> RESTORE_TO_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RestoreToTime").getter(getter(RestoreDbClusterToPointInTimeRequest::restoreToTime))
            .setter(setter(Builder::restoreToTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreToTime").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLatestRestorableTime").getter(getter(RestoreDbClusterToPointInTimeRequest::useLatestRestorableTime))
            .setter(setter(Builder::useLatestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbClusterToPointInTimeRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(RestoreDbClusterToPointInTimeRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbClusterToPointInTimeRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbClusterToPointInTimeRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            RESTORE_TYPE_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, RESTORE_TO_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD,
            PORT_FIELD, DB_SUBNET_GROUP_NAME_FIELD, OPTION_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD,
            KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DELETION_PROTECTION_FIELD));

    private final String dbClusterIdentifier;

    private final String restoreType;

    private final String sourceDBClusterIdentifier;

    private final Instant restoreToTime;

    private final Boolean useLatestRestorableTime;

    private final Integer port;

    private final String dbSubnetGroupName;

    private final String optionGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final Boolean enableIAMDatabaseAuthentication;

    private final List<String> enableCloudwatchLogsExports;

    private final String dbClusterParameterGroupName;

    private final Boolean deletionProtection;

    private RestoreDbClusterToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreType = builder.restoreType;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.restoreToTime = builder.restoreToTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * The name of the new DB cluster to be created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the new DB cluster to be created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The type of restore to be performed. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the
     * source DB cluster.
     * </p>
     * 
     * @return The type of restore to be performed. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy
     *         of the source DB cluster.
     */
    public final String restoreType() {
        return restoreType;
    }

    /**
     * <p>
     * The identifier of the source DB cluster from which to restore.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBCluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the source DB cluster from which to restore.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBCluster.
     *         </p>
     *         </li>
     */
    public final String sourceDBClusterIdentifier() {
        return sourceDBClusterIdentifier;
    }

    /**
     * <p>
     * The date and time to restore the DB cluster to.
     * </p>
     * <p>
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be before the latest restorable time for the DB instance
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>2015-03-07T23:45:00Z</code>
     * </p>
     * 
     * @return The date and time to restore the DB cluster to.</p>
     *         <p>
     *         Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be before the latest restorable time for the DB instance
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>2015-03-07T23:45:00Z</code>
     */
    public final Instant restoreToTime() {
        return restoreToTime;
    }

    /**
     * <p>
     * A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and
     * <code>false</code> otherwise.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <p>
     * Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.
     * </p>
     * 
     * @return A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time,
     *         and <code>false</code> otherwise.</p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <p>
     *         Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.
     */
    public final Boolean useLatestRestorableTime() {
        return useLatestRestorableTime;
    }

    /**
     * <p>
     * The port number on which the new DB cluster accepts connections.
     * </p>
     * <p>
     * Constraints: Value must be <code>1150-65535</code>
     * </p>
     * <p>
     * Default: The same port as the original DB cluster.
     * </p>
     * 
     * @return The port number on which the new DB cluster accepts connections.</p>
     *         <p>
     *         Constraints: Value must be <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: The same port as the original DB cluster.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The DB subnet group name to use for the new DB cluster.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return The DB subnet group name to use for the new DB cluster.</p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the new DB cluster belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VPC security groups that the new DB cluster belongs to.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be applied to the restored DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be applied to the restored DB cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The AWS KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
     * </p>
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB
     * cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster, then you
     * can use the KMS key alias instead of the ARN for the KMS encryption key.
     * </p>
     * <p>
     * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS
     * key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the
     * <code>KmsKeyId</code> parameter.
     * </p>
     * <p>
     * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
     * encrypt the source DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore request is
     * rejected.
     * </p>
     * 
     * @return The AWS KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB
     *         cluster.</p>
     *         <p>
     *         The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring
     *         a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB
     *         cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *         </p>
     *         <p>
     *         You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than
     *         the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key
     *         identified by the <code>KmsKeyId</code> parameter.
     *         </p>
     *         <p>
     *         If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used
     *         to encrypt the source DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore
     *         request is rejected.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and otherwise
     * false.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
     *         otherwise false.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * Returns true if the EnableCloudwatchLogsExports property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnableCloudwatchLogsExports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of logs that the restored DB cluster is to export to CloudWatch Logs.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with the new DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DBClusterParameterGroup.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB cluster parameter group to associate with the new DB cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DBClusterParameterGroup.
     *         </p>
     *         </li>
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when
     * deletion protection is enabled. By default, deletion protection is disabled.
     * </p>
     * 
     * @return A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreToTime());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDbClusterToPointInTimeRequest other = (RestoreDbClusterToPointInTimeRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(restoreType(), other.restoreType())
                && Objects.equals(sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier())
                && Objects.equals(restoreToTime(), other.restoreToTime())
                && Objects.equals(useLatestRestorableTime(), other.useLatestRestorableTime())
                && Objects.equals(port(), other.port()) && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbClusterToPointInTimeRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("RestoreType", restoreType()).add("SourceDBClusterIdentifier", sourceDBClusterIdentifier())
                .add("RestoreToTime", restoreToTime()).add("UseLatestRestorableTime", useLatestRestorableTime())
                .add("Port", port()).add("DBSubnetGroupName", dbSubnetGroupName()).add("OptionGroupName", optionGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "RestoreType":
            return Optional.ofNullable(clazz.cast(restoreType()));
        case "SourceDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterIdentifier()));
        case "RestoreToTime":
            return Optional.ofNullable(clazz.cast(restoreToTime()));
        case "UseLatestRestorableTime":
            return Optional.ofNullable(clazz.cast(useLatestRestorableTime()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterToPointInTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreDbClusterToPointInTimeRequest> {
        /**
         * <p>
         * The name of the new DB cluster to be created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterIdentifier
         *        The name of the new DB cluster to be created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The type of restore to be performed. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of
         * the source DB cluster.
         * </p>
         * 
         * @param restoreType
         *        The type of restore to be performed. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full
         *        copy of the source DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreType(String restoreType);

        /**
         * <p>
         * The identifier of the source DB cluster from which to restore.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBCluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBClusterIdentifier
         *        The identifier of the source DB cluster from which to restore.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBCluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier);

        /**
         * <p>
         * The date and time to restore the DB cluster to.
         * </p>
         * <p>
         * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be before the latest restorable time for the DB instance
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>2015-03-07T23:45:00Z</code>
         * </p>
         * 
         * @param restoreToTime
         *        The date and time to restore the DB cluster to.</p>
         *        <p>
         *        Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be before the latest restorable time for the DB instance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>2015-03-07T23:45:00Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreToTime(Instant restoreToTime);

        /**
         * <p>
         * A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and
         * <code>false</code> otherwise.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * <p>
         * Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.
         * </p>
         * 
         * @param useLatestRestorableTime
         *        A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup
         *        time, and <code>false</code> otherwise.</p>
         *        <p>
         *        Default: <code>false</code>
         *        </p>
         *        <p>
         *        Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableTime(Boolean useLatestRestorableTime);

        /**
         * <p>
         * The port number on which the new DB cluster accepts connections.
         * </p>
         * <p>
         * Constraints: Value must be <code>1150-65535</code>
         * </p>
         * <p>
         * Default: The same port as the original DB cluster.
         * </p>
         * 
         * @param port
         *        The port number on which the new DB cluster accepts connections.</p>
         *        <p>
         *        Constraints: Value must be <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: The same port as the original DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The DB subnet group name to use for the new DB cluster.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The DB subnet group name to use for the new DB cluster.</p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param optionGroupName
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the new DB cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new DB cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The tags to be applied to the restored DB cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be applied to the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be applied to the restored DB cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be applied to the restored DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be applied to the restored DB cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The AWS KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
         * </p>
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a
         * DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster,
         * then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * </p>
         * <p>
         * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the
         * KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by
         * the <code>KmsKeyId</code> parameter.
         * </p>
         * <p>
         * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to
         * encrypt the source DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore request is
         * rejected.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB
         *        cluster.</p>
         *        <p>
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        restoring a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the
         *        new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *        </p>
         *        <p>
         *        You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different
         *        than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS
         *        key identified by the <code>KmsKeyId</code> parameter.
         *        </p>
         *        <p>
         *        If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was
         *        used to encrypt the source DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore
         *        request is rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
         * otherwise false.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
         *        otherwise false.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of logs that the restored DB cluster is to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with the new DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DBClusterParameterGroup.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with the new DB cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DBClusterParameterGroup.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection is disabled.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String restoreType;

        private String sourceDBClusterIdentifier;

        private Instant restoreToTime;

        private Boolean useLatestRestorableTime;

        private Integer port;

        private String dbSubnetGroupName;

        private String optionGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private Boolean enableIAMDatabaseAuthentication;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterParameterGroupName;

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterToPointInTimeRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            restoreType(model.restoreType);
            sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            restoreToTime(model.restoreToTime);
            useLatestRestorableTime(model.useLatestRestorableTime);
            port(model.port);
            dbSubnetGroupName(model.dbSubnetGroupName);
            optionGroupName(model.optionGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            deletionProtection(model.deletionProtection);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getRestoreType() {
            return restoreType;
        }

        @Override
        public final Builder restoreType(String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        public final void setRestoreType(String restoreType) {
            this.restoreType = restoreType;
        }

        public final String getSourceDBClusterIdentifier() {
            return sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        public final Instant getRestoreToTime() {
            return restoreToTime;
        }

        @Override
        public final Builder restoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        public final void setRestoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
        }

        public final Boolean getUseLatestRestorableTime() {
            return useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterToPointInTimeRequest build() {
            return new RestoreDbClusterToPointInTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
