/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of a successful call to the <a>DescribeDBClusterSnapshotAttributes</a> API action.
 * </p>
 * <p>
 * Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB
 * cluster snapshot. For more information, see the <a>ModifyDBClusterSnapshotAttribute</a> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterSnapshotAttributesResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DBClusterSnapshotAttributesResult.Builder, DBClusterSnapshotAttributesResult> {
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterSnapshotIdentifier")
            .getter(getter(DBClusterSnapshotAttributesResult::dbClusterSnapshotIdentifier))
            .setter(setter(Builder::dbClusterSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotIdentifier")
                    .build()).build();

    private static final SdkField<List<DBClusterSnapshotAttribute>> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD = SdkField
            .<List<DBClusterSnapshotAttribute>> builder(MarshallingType.LIST)
            .memberName("DBClusterSnapshotAttributes")
            .getter(getter(DBClusterSnapshotAttributesResult::dbClusterSnapshotAttributes))
            .setter(setter(Builder::dbClusterSnapshotAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttributes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterSnapshotAttribute")
                            .memberFieldInfo(
                                    SdkField.<DBClusterSnapshotAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterSnapshotAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterSnapshotAttribute").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbClusterSnapshotIdentifier;

    private final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private DBClusterSnapshotAttributesResult(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    /**
     * <p>
     * The identifier of the manual DB cluster snapshot that the attributes apply to.
     * </p>
     * 
     * @return The identifier of the manual DB cluster snapshot that the attributes apply to.
     */
    public final String dbClusterSnapshotIdentifier() {
        return dbClusterSnapshotIdentifier;
    }

    /**
     * Returns true if the DBClusterSnapshotAttributes property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasDbClusterSnapshotAttributes() {
        return dbClusterSnapshotAttributes != null && !(dbClusterSnapshotAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of attributes and values for the manual DB cluster snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbClusterSnapshotAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of attributes and values for the manual DB cluster snapshot.
     */
    public final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return dbClusterSnapshotAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterSnapshotAttributes() ? dbClusterSnapshotAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshotAttributesResult)) {
            return false;
        }
        DBClusterSnapshotAttributesResult other = (DBClusterSnapshotAttributesResult) obj;
        return Objects.equals(dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier())
                && hasDbClusterSnapshotAttributes() == other.hasDbClusterSnapshotAttributes()
                && Objects.equals(dbClusterSnapshotAttributes(), other.dbClusterSnapshotAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBClusterSnapshotAttributesResult")
                .add("DBClusterSnapshotIdentifier", dbClusterSnapshotIdentifier())
                .add("DBClusterSnapshotAttributes", hasDbClusterSnapshotAttributes() ? dbClusterSnapshotAttributes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotIdentifier()));
        case "DBClusterSnapshotAttributes":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterSnapshotAttributesResult, T> g) {
        return obj -> g.apply((DBClusterSnapshotAttributesResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
        /**
         * <p>
         * The identifier of the manual DB cluster snapshot that the attributes apply to.
         * </p>
         * 
         * @param dbClusterSnapshotIdentifier
         *        The identifier of the manual DB cluster snapshot that the attributes apply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier);

        /**
         * <p>
         * The list of attributes and values for the manual DB cluster snapshot.
         * </p>
         * 
         * @param dbClusterSnapshotAttributes
         *        The list of attributes and values for the manual DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes);

        /**
         * <p>
         * The list of attributes and values for the manual DB cluster snapshot.
         * </p>
         * 
         * @param dbClusterSnapshotAttributes
         *        The list of attributes and values for the manual DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute... dbClusterSnapshotAttributes);

        /**
         * <p>
         * The list of attributes and values for the manual DB cluster snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBClusterSnapshotAttribute>.Builder}
         * avoiding the need to create one manually via {@link List<DBClusterSnapshotAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterSnapshotAttribute>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dbClusterSnapshotAttributes(List<DBClusterSnapshotAttribute>)}.
         * 
         * @param dbClusterSnapshotAttributes
         *        a consumer that will call methods on {@link List<DBClusterSnapshotAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterSnapshotAttributes(List<DBClusterSnapshotAttribute>)
         */
        Builder dbClusterSnapshotAttributes(Consumer<DBClusterSnapshotAttribute.Builder>... dbClusterSnapshotAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String dbClusterSnapshotIdentifier;

        private List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshotAttributesResult model) {
            dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            dbClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final String getDbClusterSnapshotIdentifier() {
            return dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final List<DBClusterSnapshotAttribute.Builder> getDbClusterSnapshotAttributes() {
            List<DBClusterSnapshotAttribute.Builder> result = DBClusterSnapshotAttributeListCopier
                    .copyToBuilder(this.dbClusterSnapshotAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute... dbClusterSnapshotAttributes) {
            dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(
                Consumer<DBClusterSnapshotAttribute.Builder>... dbClusterSnapshotAttributes) {
            dbClusterSnapshotAttributes(Stream.of(dbClusterSnapshotAttributes)
                    .map(c -> DBClusterSnapshotAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterSnapshotAttributes(
                Collection<DBClusterSnapshotAttribute.BuilderImpl> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copyFromBuilder(dbClusterSnapshotAttributes);
        }

        @Override
        public DBClusterSnapshotAttributesResult build() {
            return new DBClusterSnapshotAttributesResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
