/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbInstanceRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyDbInstanceRequest.Builder, ModifyDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(ModifyDbInstanceRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(ModifyDbInstanceRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(ModifyDbInstanceRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(ModifyDbInstanceRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(ModifyDbInstanceRequest::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ModifyDbInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyDbInstanceRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(ModifyDbInstanceRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(ModifyDbInstanceRequest::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(ModifyDbInstanceRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(ModifyDbInstanceRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyDbInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ModifyDbInstanceRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyDbInstanceRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade")
            .getter(getter(ModifyDbInstanceRequest::allowMajorVersionUpgrade)).setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyDbInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(ModifyDbInstanceRequest::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(ModifyDbInstanceRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(ModifyDbInstanceRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> NEW_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewDBInstanceIdentifier").getter(getter(ModifyDbInstanceRequest::newDBInstanceIdentifier))
            .setter(setter(Builder::newDBInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(ModifyDbInstanceRequest::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(ModifyDbInstanceRequest::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialPassword").getter(getter(ModifyDbInstanceRequest::tdeCredentialPassword))
            .setter(setter(Builder::tdeCredentialPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialPassword").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(ModifyDbInstanceRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(ModifyDbInstanceRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(ModifyDbInstanceRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(ModifyDbInstanceRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<Integer> DB_PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DBPortNumber").getter(getter(ModifyDbInstanceRequest::dbPortNumber))
            .setter(setter(Builder::dbPortNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBPortNumber").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(ModifyDbInstanceRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(ModifyDbInstanceRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(ModifyDbInstanceRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(ModifyDbInstanceRequest::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(ModifyDbInstanceRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(ModifyDbInstanceRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(ModifyDbInstanceRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<CloudwatchLogsExportConfiguration> CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD = SdkField
            .<CloudwatchLogsExportConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudwatchLogsExportConfiguration")
            .getter(getter(ModifyDbInstanceRequest::cloudwatchLogsExportConfiguration))
            .setter(setter(Builder::cloudwatchLogsExportConfiguration))
            .constructor(CloudwatchLogsExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsExportConfiguration")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(ModifyDbInstanceRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, DB_SECURITY_GROUPS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD, APPLY_IMMEDIATELY_FIELD, MASTER_USER_PASSWORD_FIELD, DB_PARAMETER_GROUP_NAME_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, MULTI_AZ_FIELD,
            ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD,
            IOPS_FIELD, OPTION_GROUP_NAME_FIELD, NEW_DB_INSTANCE_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD,
            TDE_CREDENTIAL_PASSWORD_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, DOMAIN_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD,
            MONITORING_INTERVAL_FIELD, DB_PORT_NUMBER_FIELD, PUBLICLY_ACCESSIBLE_FIELD, MONITORING_ROLE_ARN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, PROMOTION_TIER_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD,
            ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD,
            DELETION_PROTECTION_FIELD));

    private final String dbInstanceIdentifier;

    private final Integer allocatedStorage;

    private final String dbInstanceClass;

    private final String dbSubnetGroupName;

    private final List<String> dbSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final Boolean applyImmediately;

    private final String masterUserPassword;

    private final String dbParameterGroupName;

    private final Integer backupRetentionPeriod;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private final Boolean autoMinorVersionUpgrade;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final String newDBInstanceIdentifier;

    private final String storageType;

    private final String tdeCredentialArn;

    private final String tdeCredentialPassword;

    private final String caCertificateIdentifier;

    private final String domain;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final Integer dbPortNumber;

    private final Boolean publiclyAccessible;

    private final String monitoringRoleArn;

    private final String domainIAMRoleName;

    private final Integer promotionTier;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

    private final Boolean deletionProtection;

    private ModifyDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.applyImmediately = builder.applyImmediately;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.newDBInstanceIdentifier = builder.newDBInstanceIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domain = builder.domain;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.dbPortNumber = builder.dbPortNumber;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.promotionTier = builder.promotionTier;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.cloudwatchLogsExportConfiguration = builder.cloudwatchLogsExportConfiguration;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * The DB instance identifier. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBInstance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB instance identifier. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBInstance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB
     * instance classes are available in all AWS Regions.
     * </p>
     * <p>
     * If you modify the DB instance class, an outage occurs during the change. The change is applied during the next
     * maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * 
     * @return The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB
     *         instance classes are available in all AWS Regions.</p>
     *         <p>
     *         If you modify the DB instance class, an outage occurs during the change. The change is applied during the
     *         next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this
     *         request.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different
     * VPC.
     * </p>
     * <p>
     * Changing the subnet group causes an outage during the change. The change is applied during the next maintenance
     * window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.
     * </p>
     * <p>
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * </p>
     * <p>
     * Example: <code>mySubnetGroup</code>
     * </p>
     * 
     * @return The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a
     *         different VPC.</p>
     *         <p>
     *         Changing the subnet group causes an outage during the change. The change is applied during the next
     *         maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.
     *         </p>
     *         <p>
     *         Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetGroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * Returns true if the DBSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage
     * and the change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match existing DBSecurityGroups.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an
     *         outage and the change is asynchronously applied as soon as possible.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match existing DBSecurityGroups.
     *         </p>
     *         </li>
     */
    public final List<String> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon
     * as possible.
     * </p>
     * <p>
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
     * information, see <a>ModifyDBCluster</a>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match existing VpcSecurityGroupIds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied
     *         as soon as possible.</p>
     *         <p>
     *         Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
     *         information, see <a>ModifyDBCluster</a>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match existing VpcSecurityGroupIds.
     *         </p>
     *         </li>
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as
     * soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance.
     * </p>
     * <p>
     * If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next
     * maintenance window. Some parameter changes can cause an outage and are applied on the next call to
     * <a>RebootDBInstance</a>, or the next failure reboot.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Specifies whether the modifications in this request and any pending modifications are asynchronously
     *         applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB
     *         instance.</p>
     *         <p>
     *         If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next
     *         maintenance window. Some parameter changes can cause an outage and are applied on the next call to
     *         <a>RebootDBInstance</a>, or the next failure reboot.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an
     * outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied
     * until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the
     * parameter changes will NOT be applied during the next maintenance window.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.
     * </p>
     * 
     * @return The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in
     *         an outage. The parameter group name itself is changed immediately, but the actual parameter changes are
     *         not applied until you reboot the instance without failover. The db instance will NOT be rebooted
     *         automatically and the parameter changes will NOT be applied during the next maintenance window.</p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * Not applicable. The retention period for automated backups is managed by the DB cluster. For more information,
     * see <a>ModifyDBCluster</a>.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * 
     * @return Not applicable. The retention period for automated backups is managed by the DB cluster. For more
     *         information, see <a>ModifyDBCluster</a>.</p>
     *         <p>
     *         Default: Uses existing setting
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled.
     * </p>
     * <p>
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more
     * information, see <a>ModifyDBCluster</a>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format hh24:mi-hh24:mi
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Time Coordinated (UTC)
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled.</p>
     *         <p>
     *         Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For
     *         more information, see <a>ModifyDBCluster</a>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format hh24:mi-hh24:mi
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Time Coordinated (UTC)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
     * Changing this parameter doesn't result in an outage, except in the following situation, and the change is
     * asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance
     * window is changed to include the current time, then changing this parameter will cause a reboot of the DB
     * instance. If moving this window to the current time, there must be at least 30 minutes between the current time
     * and end of the window to ensure pending changes are applied.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Must be at least 30 minutes
     * </p>
     * 
     * @return The weekly time range (in UTC) during which system maintenance can occur, which might result in an
     *         outage. Changing this parameter doesn't result in an outage, except in the following situation, and the
     *         change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot,
     *         and the maintenance window is changed to include the current time, then changing this parameter will
     *         cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30
     *         minutes between the current time and end of the window to ensure pending changes are applied.</p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Format: ddd:hh24:mi-ddd:hh24:mi
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Must be at least 30 minutes
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and
     * the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is
     * set to <code>true</code> for this request.
     * </p>
     * 
     * @return Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an
     *         outage and the change is applied during the next maintenance window unless the
     *         <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To
     * upgrade your database engine to the most recent release, use the <a>ApplyPendingMaintenanceAction</a> API.
     * </p>
     * 
     * @return The version number of the database engine to upgrade to. Currently, setting this parameter has no effect.
     *         To upgrade your database engine to the most recent release, use the <a>ApplyPendingMaintenanceAction</a>
     *         API.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the
     * change is asynchronously applied as soon as possible.
     * </p>
     * 
     * @return Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage
     *         and the change is asynchronously applied as soon as possible.
     */
    public final Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window.
     * Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously
     * applied as soon as possible. An outage will result if this parameter is set to <code>true</code> during the
     * maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine
     * version.
     * </p>
     * 
     * @return Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance
     *         window. Changing this parameter doesn't result in an outage except in the following case and the change
     *         is asynchronously applied as soon as possible. An outage will result if this parameter is set to
     *         <code>true</code> during the maintenance window, and a newer minor version is available, and Neptune has
     *         enabled auto patching for that engine version.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The new Provisioned IOPS (I/O operations per second) value for the instance.
     * </p>
     * <p>
     * Changing this setting doesn't result in an outage and the change is applied during the next maintenance window
     * unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * 
     * @return The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
     *         <p>
     *         Changing this setting doesn't result in an outage and the change is applied during the next maintenance
     *         window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.
     *         </p>
     *         <p>
     *         Default: Uses existing setting
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance
     * identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to true, or will
     * occur during the next maintenance window if <code>Apply Immediately</code> to false. This value is stored as a
     * lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * </p>
     * 
     * @return The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB
     *         instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code>
     *         to true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false.
     *         This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbinstance</code>
     */
    public final String newDBInstanceIdentifier() {
        return newDBInstanceIdentifier;
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * 
     * @return Not supported.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which to associate the instance for TDE encryption.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * The password for the given ARN from the key store in order to access the device.
     * </p>
     * 
     * @return The password for the given ARN from the key store in order to access the device.
     */
    public final String tdeCredentialPassword() {
        return tdeCredentialPassword;
    }

    /**
     * <p>
     * Indicates the certificate that needs to be associated with the instance.
     * </p>
     * 
     * @return Indicates the certificate that needs to be associated with the instance.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * 
     * @return Not supported.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is
     * false.
     * </p>
     * 
     * @return True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The
     *         default is false.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To
     * disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value
     * other than 0.
     * </p>
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to
     *         a value other than 0.
     *         </p>
     *         <p>
     *         Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The port number on which the database accepts connections.
     * </p>
     * <p>
     * The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options
     * in the option group for the DB instance.
     * </p>
     * <p>
     * Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the
     * <code>ApplyImmediately</code> parameter.
     * </p>
     * <p>
     * Default: <code>8182</code>
     * </p>
     * 
     * @return The port number on which the database accepts connections.</p>
     *         <p>
     *         The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for
     *         options in the option group for the DB instance.
     *         </p>
     *         <p>
     *         Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of
     *         the <code>ApplyImmediately</code> parameter.
     *         </p>
     *         <p>
     *         Default: <code>8182</code>
     */
    public final Integer dbPortNumber() {
        return dbPortNumber;
    }

    /**
     * <p>
     * This flag should no longer be used.
     * </p>
     * 
     * @return This flag should no longer be used.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, <code>arn:aws:iam:123456789012:role/emaccess</code>.
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * 
     * @return The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch
     *         Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
     *         <code>MonitoringRoleArn</code> value.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * Not supported
     * </p>
     * 
     * @return Not supported
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of
     * the existing primary instance.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Valid Values: 0 - 15
     * </p>
     * 
     * @return A value that specifies the order in which a Read Replica is promoted to the primary instance after a
     *         failure of the existing primary instance.</p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Valid Values: 0 - 15
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and
     * otherwise false.
     * </p>
     * <p>
     * You can enable IAM database authentication for the following database engines
     * </p>
     * <p>
     * Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more
     * information, see <a>ModifyDBCluster</a>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and
     *         otherwise false.</p>
     *         <p>
     *         You can enable IAM database authentication for the following database engines
     *         </p>
     *         <p>
     *         Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more
     *         information, see <a>ModifyDBCluster</a>.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     * instance or DB cluster.
     * </p>
     * 
     * @return The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     *         instance or DB cluster.
     */
    public final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration() {
        return cloudwatchLogsExportConfiguration;
    }

    /**
     * <p>
     * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted
     * when deletion protection is enabled. By default, deletion protection is disabled. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB
     * Instance</a>.
     * </p>
     * 
     * @return A value that indicates whether the DB instance has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting
     *         a DB Instance</a>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(newDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(dbPortNumber());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogsExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbInstanceRequest)) {
            return false;
        }
        ModifyDbInstanceRequest other = (ModifyDbInstanceRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(newDBInstanceIdentifier(), other.newDBInstanceIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && Objects.equals(tdeCredentialPassword(), other.tdeCredentialPassword())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(domain(), other.domain()) && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(dbPortNumber(), other.dbPortNumber())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(promotionTier(), other.promotionTier())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(cloudwatchLogsExportConfiguration(), other.cloudwatchLogsExportConfiguration())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbInstanceRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("AllocatedStorage", allocatedStorage()).add("DBInstanceClass", dbInstanceClass())
                .add("DBSubnetGroupName", dbSubnetGroupName())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("ApplyImmediately", applyImmediately()).add("MasterUserPassword", masterUserPassword())
                .add("DBParameterGroupName", dbParameterGroupName()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("LicenseModel", licenseModel())
                .add("Iops", iops()).add("OptionGroupName", optionGroupName())
                .add("NewDBInstanceIdentifier", newDBInstanceIdentifier()).add("StorageType", storageType())
                .add("TdeCredentialArn", tdeCredentialArn()).add("TdeCredentialPassword", tdeCredentialPassword())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("Domain", domain())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).add("MonitoringInterval", monitoringInterval())
                .add("DBPortNumber", dbPortNumber()).add("PubliclyAccessible", publiclyAccessible())
                .add("MonitoringRoleArn", monitoringRoleArn()).add("DomainIAMRoleName", domainIAMRoleName())
                .add("PromotionTier", promotionTier()).add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("CloudwatchLogsExportConfiguration", cloudwatchLogsExportConfiguration())
                .add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "NewDBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(newDBInstanceIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "TdeCredentialPassword":
            return Optional.ofNullable(clazz.cast(tdeCredentialPassword()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "DBPortNumber":
            return Optional.ofNullable(clazz.cast(dbPortNumber()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "CloudwatchLogsExportConfiguration":
            return Optional.ofNullable(clazz.cast(cloudwatchLogsExportConfiguration()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbInstanceRequest, T> g) {
        return obj -> g.apply((ModifyDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbInstanceRequest> {
        /**
         * <p>
         * The DB instance identifier. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBInstance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBInstance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param allocatedStorage
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB
         * instance classes are available in all AWS Regions.
         * </p>
         * <p>
         * If you modify the DB instance class, an outage occurs during the change. The change is applied during the
         * next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this
         * request.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * 
         * @param dbInstanceClass
         *        The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all
         *        DB instance classes are available in all AWS Regions.</p>
         *        <p>
         *        If you modify the DB instance class, an outage occurs during the change. The change is applied during
         *        the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code>
         *        for this request.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a
         * different VPC.
         * </p>
         * <p>
         * Changing the subnet group causes an outage during the change. The change is applied during the next
         * maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.
         * </p>
         * <p>
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * </p>
         * <p>
         * Example: <code>mySubnetGroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a
         *        different VPC.</p>
         *        <p>
         *        Changing the subnet group causes an outage during the change. The change is applied during the next
         *        maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code>
         *        parameter.
         *        </p>
         *        <p>
         *        Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetGroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an
         * outage and the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing DBSecurityGroups.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in
         *        an outage and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing DBSecurityGroups.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<String> dbSecurityGroups);

        /**
         * <p>
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an
         * outage and the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing DBSecurityGroups.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in
         *        an outage and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing DBSecurityGroups.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(String... dbSecurityGroups);

        /**
         * <p>
         * A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as
         * soon as possible.
         * </p>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         * information, see <a>ModifyDBCluster</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing VpcSecurityGroupIds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously
         *        applied as soon as possible.</p>
         *        <p>
         *        Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         *        information, see <a>ModifyDBCluster</a>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing VpcSecurityGroupIds.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as
         * soon as possible.
         * </p>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         * information, see <a>ModifyDBCluster</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match existing VpcSecurityGroupIds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously
         *        applied as soon as possible.</p>
         *        <p>
         *        Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more
         *        information, see <a>ModifyDBCluster</a>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match existing VpcSecurityGroupIds.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * Specifies whether the modifications in this request and any pending modifications are asynchronously applied
         * as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance.
         * </p>
         * <p>
         * If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next
         * maintenance window. Some parameter changes can cause an outage and are applied on the next call to
         * <a>RebootDBInstance</a>, or the next failure reboot.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        Specifies whether the modifications in this request and any pending modifications are asynchronously
         *        applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the
         *        DB instance.</p>
         *        <p>
         *        If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next
         *        maintenance window. Some parameter changes can cause an outage and are applied on the next call to
         *        <a>RebootDBInstance</a>, or the next failure reboot.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param masterUserPassword
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an
         * outage. The parameter group name itself is changed immediately, but the actual parameter changes are not
         * applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically
         * and the parameter changes will NOT be applied during the next maintenance window.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.
         * </p>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result
         *        in an outage. The parameter group name itself is changed immediately, but the actual parameter changes
         *        are not applied until you reboot the instance without failover. The db instance will NOT be rebooted
         *        automatically and the parameter changes will NOT be applied during the next maintenance window.</p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * Not applicable. The retention period for automated backups is managed by the DB cluster. For more
         * information, see <a>ModifyDBCluster</a>.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * 
         * @param backupRetentionPeriod
         *        Not applicable. The retention period for automated backups is managed by the DB cluster. For more
         *        information, see <a>ModifyDBCluster</a>.</p>
         *        <p>
         *        Default: Uses existing setting
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled.
         * </p>
         * <p>
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more
         * information, see <a>ModifyDBCluster</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format hh24:mi-hh24:mi
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Time Coordinated (UTC)
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled.</p>
         *        <p>
         *        Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For
         *        more information, see <a>ModifyDBCluster</a>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format hh24:mi-hh24:mi
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Time Coordinated (UTC)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
         * Changing this parameter doesn't result in an outage, except in the following situation, and the change is
         * asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the
         * maintenance window is changed to include the current time, then changing this parameter will cause a reboot
         * of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the
         * current time and end of the window to ensure pending changes are applied.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Must be at least 30 minutes
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which system maintenance can occur, which might result in an
         *        outage. Changing this parameter doesn't result in an outage, except in the following situation, and
         *        the change is asynchronously applied as soon as possible. If there are pending actions that cause a
         *        reboot, and the maintenance window is changed to include the current time, then changing this
         *        parameter will cause a reboot of the DB instance. If moving this window to the current time, there
         *        must be at least 30 minutes between the current time and end of the window to ensure pending changes
         *        are applied.</p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Format: ddd:hh24:mi-ddd:hh24:mi
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Must be at least 30 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage
         * and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code>
         * parameter is set to <code>true</code> for this request.
         * </p>
         * 
         * @param multiAZ
         *        Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an
         *        outage and the change is applied during the next maintenance window unless the
         *        <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To
         * upgrade your database engine to the most recent release, use the <a>ApplyPendingMaintenanceAction</a> API.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to upgrade to. Currently, setting this parameter has no
         *        effect. To upgrade your database engine to the most recent release, use the
         *        <a>ApplyPendingMaintenanceAction</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and
         * the change is asynchronously applied as soon as possible.
         * </p>
         * 
         * @param allowMajorVersionUpgrade
         *        Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage
         *        and the change is asynchronously applied as soon as possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        /**
         * <p>
         * Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance
         * window. Changing this parameter doesn't result in an outage except in the following case and the change is
         * asynchronously applied as soon as possible. An outage will result if this parameter is set to
         * <code>true</code> during the maintenance window, and a newer minor version is available, and Neptune has
         * enabled auto patching for that engine version.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Indicates that minor version upgrades are applied automatically to the DB instance during the
         *        maintenance window. Changing this parameter doesn't result in an outage except in the following case
         *        and the change is asynchronously applied as soon as possible. An outage will result if this parameter
         *        is set to <code>true</code> during the maintenance window, and a newer minor version is available, and
         *        Neptune has enabled auto patching for that engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param licenseModel
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The new Provisioned IOPS (I/O operations per second) value for the instance.
         * </p>
         * <p>
         * Changing this setting doesn't result in an outage and the change is applied during the next maintenance
         * window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * 
         * @param iops
         *        The new Provisioned IOPS (I/O operations per second) value for the instance.</p>
         *        <p>
         *        Changing this setting doesn't result in an outage and the change is applied during the next
         *        maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for
         *        this request.
         *        </p>
         *        <p>
         *        Default: Uses existing setting
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param optionGroupName
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB
         * instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to
         * true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false. This value
         * is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbinstance</code>
         * </p>
         * 
         * @param newDBInstanceIdentifier
         *        The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB
         *        instance identifier, an instance reboot will occur immediately if you set
         *        <code>Apply Immediately</code> to true, or will occur during the next maintenance window if
         *        <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBInstanceIdentifier(String newDBInstanceIdentifier);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param storageType
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which to associate the instance for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * The password for the given ARN from the key store in order to access the device.
         * </p>
         * 
         * @param tdeCredentialPassword
         *        The password for the given ARN from the key store in order to access the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialPassword(String tdeCredentialPassword);

        /**
         * <p>
         * Indicates the certificate that needs to be associated with the instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        Indicates the certificate that needs to be associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param domain
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default
         * is false.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The
         *        default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a
         * value other than 0.
         * </p>
         * <p>
         * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code>
         *        to a value other than 0.
         *        </p>
         *        <p>
         *        Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The port number on which the database accepts connections.
         * </p>
         * <p>
         * The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for
         * options in the option group for the DB instance.
         * </p>
         * <p>
         * Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the
         * <code>ApplyImmediately</code> parameter.
         * </p>
         * <p>
         * Default: <code>8182</code>
         * </p>
         * 
         * @param dbPortNumber
         *        The port number on which the database accepts connections.</p>
         *        <p>
         *        The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified
         *        for options in the option group for the DB instance.
         *        </p>
         *        <p>
         *        Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value
         *        of the <code>ApplyImmediately</code> parameter.
         *        </p>
         *        <p>
         *        Default: <code>8182</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPortNumber(Integer dbPortNumber);

        /**
         * <p>
         * This flag should no longer be used.
         * </p>
         * 
         * @param publiclyAccessible
         *        This flag should no longer be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs.
         * For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch
         *        Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a
         *        <code>MonitoringRoleArn</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * Not supported
         * </p>
         * 
         * @param domainIAMRoleName
         *        Not supported
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure
         * of the existing primary instance.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Valid Values: 0 - 15
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which a Read Replica is promoted to the primary instance after a
         *        failure of the existing primary instance.</p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Valid Values: 0 - 15
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and
         * otherwise false.
         * </p>
         * <p>
         * You can enable IAM database authentication for the following database engines
         * </p>
         * <p>
         * Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more
         * information, see <a>ModifyDBCluster</a>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts,
         *        and otherwise false.</p>
         *        <p>
         *        You can enable IAM database authentication for the following database engines
         *        </p>
         *        <p>
         *        Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For
         *        more information, see <a>ModifyDBCluster</a>.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param enablePerformanceInsights
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * instance or DB cluster.
         * </p>
         * 
         * @param cloudwatchLogsExportConfiguration
         *        The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific
         *        DB instance or DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * instance or DB cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchLogsExportConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudwatchLogsExportConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchLogsExportConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)}.
         * 
         * @param cloudwatchLogsExportConfiguration
         *        a consumer that will call methods on {@link CloudwatchLogsExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)
         */
        default Builder cloudwatchLogsExportConfiguration(
                Consumer<CloudwatchLogsExportConfiguration.Builder> cloudwatchLogsExportConfiguration) {
            return cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration.builder()
                    .applyMutation(cloudwatchLogsExportConfiguration).build());
        }

        /**
         * <p>
         * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection is disabled. See <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a
         * DB Instance</a>.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB instance has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html"
         *        >Deleting a DB Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private Integer allocatedStorage;

        private String dbInstanceClass;

        private String dbSubnetGroupName;

        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private String masterUserPassword;

        private String dbParameterGroupName;

        private Integer backupRetentionPeriod;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private Boolean autoMinorVersionUpgrade;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private String newDBInstanceIdentifier;

        private String storageType;

        private String tdeCredentialArn;

        private String tdeCredentialPassword;

        private String caCertificateIdentifier;

        private String domain;

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private Integer dbPortNumber;

        private Boolean publiclyAccessible;

        private String monitoringRoleArn;

        private String domainIAMRoleName;

        private Integer promotionTier;

        private Boolean enableIAMDatabaseAuthentication;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbInstanceRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            allocatedStorage(model.allocatedStorage);
            dbInstanceClass(model.dbInstanceClass);
            dbSubnetGroupName(model.dbSubnetGroupName);
            dbSecurityGroups(model.dbSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            applyImmediately(model.applyImmediately);
            masterUserPassword(model.masterUserPassword);
            dbParameterGroupName(model.dbParameterGroupName);
            backupRetentionPeriod(model.backupRetentionPeriod);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            newDBInstanceIdentifier(model.newDBInstanceIdentifier);
            storageType(model.storageType);
            tdeCredentialArn(model.tdeCredentialArn);
            tdeCredentialPassword(model.tdeCredentialPassword);
            caCertificateIdentifier(model.caCertificateIdentifier);
            domain(model.domain);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            dbPortNumber(model.dbPortNumber);
            publiclyAccessible(model.publiclyAccessible);
            monitoringRoleArn(model.monitoringRoleArn);
            domainIAMRoleName(model.domainIAMRoleName);
            promotionTier(model.promotionTier);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            cloudwatchLogsExportConfiguration(model.cloudwatchLogsExportConfiguration);
            deletionProtection(model.deletionProtection);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getNewDBInstanceIdentifier() {
            return newDBInstanceIdentifier;
        }

        @Override
        public final Builder newDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
            return this;
        }

        public final void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final String getTdeCredentialPassword() {
            return tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final Integer getDbPortNumber() {
            return dbPortNumber;
        }

        @Override
        public final Builder dbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
            return this;
        }

        public final void setDbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        public final CloudwatchLogsExportConfiguration.Builder getCloudwatchLogsExportConfiguration() {
            return cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
            return this;
        }

        public final void setCloudwatchLogsExportConfiguration(
                CloudwatchLogsExportConfiguration.BuilderImpl cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration
                    .build() : null;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbInstanceRequest build() {
            return new ModifyDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
