/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time zone associated with a <a>DBInstance</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Timezone implements SdkPojo, Serializable, ToCopyableBuilder<Timezone.Builder, Timezone> {
    private static final SdkField<String> TIMEZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimezoneName").getter(getter(Timezone::timezoneName)).setter(setter(Builder::timezoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezoneName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEZONE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timezoneName;

    private Timezone(BuilderImpl builder) {
        this.timezoneName = builder.timezoneName;
    }

    /**
     * <p>
     * The name of the time zone.
     * </p>
     * 
     * @return The name of the time zone.
     */
    public final String timezoneName() {
        return timezoneName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timezoneName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timezone)) {
            return false;
        }
        Timezone other = (Timezone) obj;
        return Objects.equals(timezoneName(), other.timezoneName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Timezone").add("TimezoneName", timezoneName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimezoneName":
            return Optional.ofNullable(clazz.cast(timezoneName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Timezone, T> g) {
        return obj -> g.apply((Timezone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Timezone> {
        /**
         * <p>
         * The name of the time zone.
         * </p>
         * 
         * @param timezoneName
         *        The name of the time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezoneName(String timezoneName);
    }

    static final class BuilderImpl implements Builder {
        private String timezoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(Timezone model) {
            timezoneName(model.timezoneName);
        }

        public final String getTimezoneName() {
            return timezoneName;
        }

        public final void setTimezoneName(String timezoneName) {
            this.timezoneName = timezoneName;
        }

        @Override
        @Transient
        public final Builder timezoneName(String timezoneName) {
            this.timezoneName = timezoneName;
            return this;
        }

        @Override
        public Timezone build() {
            return new Timezone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
