/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbClusterEndpointRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyDbClusterEndpointRequest.Builder, ModifyDbClusterEndpointRequest> {
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterEndpointIdentifier")
            .getter(getter(ModifyDbClusterEndpointRequest::dbClusterEndpointIdentifier))
            .setter(setter(Builder::dbClusterEndpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier")
                    .build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(ModifyDbClusterEndpointRequest::endpointType))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StaticMembers")
            .getter(getter(ModifyDbClusterEndpointRequest::staticMembers))
            .setter(setter(Builder::staticMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedMembers")
            .getter(getter(ModifyDbClusterEndpointRequest::excludedMembers))
            .setter(setter(Builder::excludedMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD, EXCLUDED_MEMBERS_FIELD));

    private final String dbClusterEndpointIdentifier;

    private final String endpointType;

    private final List<String> staticMembers;

    private final List<String> excludedMembers;

    private ModifyDbClusterEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.endpointType = builder.endpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
    }

    /**
     * <p>
     * The identifier of the endpoint to modify. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The identifier of the endpoint to modify. This parameter is stored as a lowercase string.
     */
    public final String dbClusterEndpointIdentifier() {
        return dbClusterEndpointIdentifier;
    }

    /**
     * <p>
     * The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
     * </p>
     * 
     * @return The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
     */
    public final String endpointType() {
        return endpointType;
    }

    /**
     * Returns true if the StaticMembers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStaticMembers() {
        return staticMembers != null && !(staticMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of DB instance identifiers that are part of the custom endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStaticMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of DB instance identifiers that are part of the custom endpoint group.
     */
    public final List<String> staticMembers() {
        return staticMembers;
    }

    /**
     * Returns true if the ExcludedMembers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExcludedMembers() {
        return excludedMembers != null && !(excludedMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are
     * reachable through the custom endpoint. Only relevant if the list of static members is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludedMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
     *         instances are reachable through the custom endpoint. Only relevant if the list of static members is
     *         empty.
     */
    public final List<String> excludedMembers() {
        return excludedMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticMembers() ? staticMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedMembers() ? excludedMembers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterEndpointRequest)) {
            return false;
        }
        ModifyDbClusterEndpointRequest other = (ModifyDbClusterEndpointRequest) obj;
        return Objects.equals(dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier())
                && Objects.equals(endpointType(), other.endpointType()) && hasStaticMembers() == other.hasStaticMembers()
                && Objects.equals(staticMembers(), other.staticMembers()) && hasExcludedMembers() == other.hasExcludedMembers()
                && Objects.equals(excludedMembers(), other.excludedMembers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbClusterEndpointRequest")
                .add("DBClusterEndpointIdentifier", dbClusterEndpointIdentifier()).add("EndpointType", endpointType())
                .add("StaticMembers", hasStaticMembers() ? staticMembers() : null)
                .add("ExcludedMembers", hasExcludedMembers() ? excludedMembers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterEndpointIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterEndpointIdentifier()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        case "StaticMembers":
            return Optional.ofNullable(clazz.cast(staticMembers()));
        case "ExcludedMembers":
            return Optional.ofNullable(clazz.cast(excludedMembers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterEndpointRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbClusterEndpointRequest> {
        /**
         * <p>
         * The identifier of the endpoint to modify. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param dbClusterEndpointIdentifier
         *        The identifier of the endpoint to modify. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier);

        /**
         * <p>
         * The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * List of DB instance identifiers that are part of the custom endpoint group.
         * </p>
         * 
         * @param staticMembers
         *        List of DB instance identifiers that are part of the custom endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticMembers(Collection<String> staticMembers);

        /**
         * <p>
         * List of DB instance identifiers that are part of the custom endpoint group.
         * </p>
         * 
         * @param staticMembers
         *        List of DB instance identifiers that are part of the custom endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticMembers(String... staticMembers);

        /**
         * <p>
         * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances
         * are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * </p>
         * 
         * @param excludedMembers
         *        List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
         *        instances are reachable through the custom endpoint. Only relevant if the list of static members is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedMembers(Collection<String> excludedMembers);

        /**
         * <p>
         * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances
         * are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * </p>
         * 
         * @param excludedMembers
         *        List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
         *        instances are reachable through the custom endpoint. Only relevant if the list of static members is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedMembers(String... excludedMembers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterEndpointIdentifier;

        private String endpointType;

        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterEndpointRequest model) {
            super(model);
            dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            endpointType(model.endpointType);
            staticMembers(model.staticMembers);
            excludedMembers(model.excludedMembers);
        }

        public final String getDbClusterEndpointIdentifier() {
            return dbClusterEndpointIdentifier;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        @Override
        @Transient
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        @Transient
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final Collection<String> getStaticMembers() {
            if (staticMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return staticMembers;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        @Override
        @Transient
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder staticMembers(String... staticMembers) {
            staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final Collection<String> getExcludedMembers() {
            if (excludedMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedMembers;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        @Override
        @Transient
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludedMembers(String... excludedMembers) {
            excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterEndpointRequest build() {
            return new ModifyDbClusterEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
