/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon Neptune DB cluster.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>DescribeDBClusters</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBCluster implements SdkPojo, Serializable, ToCopyableBuilder<DBCluster.Builder, DBCluster> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(DBCluster::allocatedStorage)).setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(DBCluster::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(DBCluster::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(DBCluster::characterSetName)).setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DBCluster::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DBCluster::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroup").getter(getter(DBCluster::dbClusterParameterGroup))
            .setter(setter(Builder::dbClusterParameterGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroup").build())
            .build();

    private static final SdkField<String> DB_SUBNET_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroup").getter(getter(DBCluster::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBCluster::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PERCENT_PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PercentProgress").getter(getter(DBCluster::percentProgress)).setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()).build();

    private static final SdkField<Instant> EARLIEST_RESTORABLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EarliestRestorableTime").getter(getter(DBCluster::earliestRestorableTime))
            .setter(setter(Builder::earliestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableTime").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(DBCluster::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReaderEndpoint").getter(getter(DBCluster::readerEndpoint)).setter(setter(Builder::readerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(DBCluster::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DBCluster::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DBCluster::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestRestorableTime").getter(getter(DBCluster::latestRestorableTime))
            .setter(setter(Builder::latestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(DBCluster::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(DBCluster::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<List<DBClusterOptionGroupStatus>> DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<DBClusterOptionGroupStatus>> builder(MarshallingType.LIST)
            .memberName("DBClusterOptionGroupMemberships")
            .getter(getter(DBCluster::dbClusterOptionGroupMemberships))
            .setter(setter(Builder::dbClusterOptionGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterOptionGroupMemberships")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterOptionGroup")
                            .memberFieldInfo(
                                    SdkField.<DBClusterOptionGroupStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterOptionGroupStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterOptionGroup").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(DBCluster::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(DBCluster::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> REPLICATION_SOURCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSourceIdentifier")
            .getter(getter(DBCluster::replicationSourceIdentifier))
            .setter(setter(Builder::replicationSourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSourceIdentifier")
                    .build()).build();

    private static final SdkField<List<String>> READ_REPLICA_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaIdentifiers")
            .getter(getter(DBCluster::readReplicaIdentifiers))
            .setter(setter(Builder::readReplicaIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReadReplicaIdentifier")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReadReplicaIdentifier").build()).build()).build()).build();

    private static final SdkField<List<DBClusterMember>> DB_CLUSTER_MEMBERS_FIELD = SdkField
            .<List<DBClusterMember>> builder(MarshallingType.LIST)
            .memberName("DBClusterMembers")
            .getter(getter(DBCluster::dbClusterMembers))
            .setter(setter(Builder::dbClusterMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterMember")
                            .memberFieldInfo(
                                    SdkField.<DBClusterMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterMember").build()).build()).build()).build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(DBCluster::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupMembership")
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupMembership").build()).build()).build())
            .build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId").getter(getter(DBCluster::hostedZoneId)).setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(DBCluster::storageEncrypted)).setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DBCluster::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterResourceId").getter(getter(DBCluster::dbClusterResourceId))
            .setter(setter(Builder::dbClusterResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterArn").getter(getter(DBCluster::dbClusterArn)).setter(setter(Builder::dbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()).build();

    private static final SdkField<List<DBClusterRole>> ASSOCIATED_ROLES_FIELD = SdkField
            .<List<DBClusterRole>> builder(MarshallingType.LIST)
            .memberName("AssociatedRoles")
            .getter(getter(DBCluster::associatedRoles))
            .setter(setter(Builder::associatedRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterRole")
                            .memberFieldInfo(
                                    SdkField.<DBClusterRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterRole").build()).build()).build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IAMDatabaseAuthenticationEnabled")
            .getter(getter(DBCluster::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<String> CLONE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloneGroupId").getter(getter(DBCluster::cloneGroupId)).setter(setter(Builder::cloneGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloneGroupId").build()).build();

    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ClusterCreateTime").getter(getter(DBCluster::clusterCreateTime))
            .setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(DBCluster::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledCloudwatchLogsExports")
            .getter(getter(DBCluster::enabledCloudwatchLogsExports))
            .setter(setter(Builder::enabledCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(DBCluster::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> CROSS_ACCOUNT_CLONE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrossAccountClone").getter(getter(DBCluster::crossAccountClone))
            .setter(setter(Builder::crossAccountClone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountClone").build()).build();

    private static final SdkField<Instant> AUTOMATIC_RESTART_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AutomaticRestartTime").getter(getter(DBCluster::automaticRestartTime))
            .setter(setter(Builder::automaticRestartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticRestartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD,
            AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_FIELD, DB_SUBNET_GROUP_FIELD, STATUS_FIELD,
            PERCENT_PROGRESS_FIELD, EARLIEST_RESTORABLE_TIME_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, MULTI_AZ_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, LATEST_RESTORABLE_TIME_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD,
            DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            REPLICATION_SOURCE_IDENTIFIER_FIELD, READ_REPLICA_IDENTIFIERS_FIELD, DB_CLUSTER_MEMBERS_FIELD,
            VPC_SECURITY_GROUPS_FIELD, HOSTED_ZONE_ID_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD,
            DB_CLUSTER_RESOURCE_ID_FIELD, DB_CLUSTER_ARN_FIELD, ASSOCIATED_ROLES_FIELD,
            IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, CLONE_GROUP_ID_FIELD, CLUSTER_CREATE_TIME_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD,
            CROSS_ACCOUNT_CLONE_FIELD, AUTOMATIC_RESTART_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer allocatedStorage;

    private final List<String> availabilityZones;

    private final Integer backupRetentionPeriod;

    private final String characterSetName;

    private final String databaseName;

    private final String dbClusterIdentifier;

    private final String dbClusterParameterGroup;

    private final String dbSubnetGroup;

    private final String status;

    private final String percentProgress;

    private final Instant earliestRestorableTime;

    private final String endpoint;

    private final String readerEndpoint;

    private final Boolean multiAZ;

    private final String engine;

    private final String engineVersion;

    private final Instant latestRestorableTime;

    private final Integer port;

    private final String masterUsername;

    private final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final String replicationSourceIdentifier;

    private final List<String> readReplicaIdentifiers;

    private final List<DBClusterMember> dbClusterMembers;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;

    private final String hostedZoneId;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String dbClusterResourceId;

    private final String dbClusterArn;

    private final List<DBClusterRole> associatedRoles;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final String cloneGroupId;

    private final Instant clusterCreateTime;

    private final Boolean copyTagsToSnapshot;

    private final List<String> enabledCloudwatchLogsExports;

    private final Boolean deletionProtection;

    private final Boolean crossAccountClone;

    private final Instant automaticRestartTime;

    private DBCluster(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.earliestRestorableTime = builder.earliestRestorableTime;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.multiAZ = builder.multiAZ;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterArn = builder.dbClusterArn;
        this.associatedRoles = builder.associatedRoles;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.cloneGroupId = builder.cloneGroupId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
        this.crossAccountClone = builder.crossAccountClone;
        this.automaticRestartTime = builder.automaticRestartTime;
    }

    /**
     * <p>
     * <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is not fixed, but instead
     * automatically adjusts as needed.
     * </p>
     * 
     * @return <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is not fixed, but
     *         instead automatically adjusts as needed.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * Specifies the number of days for which automatic DB snapshots are retained.
     * </p>
     * 
     * @return Specifies the number of days for which automatic DB snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * Contains the name of the initial database of this DB cluster that was provided at create time, if one was
     * specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
     * </p>
     * 
     * @return Contains the name of the initial database of this DB cluster that was provided at create time, if one was
     *         specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     * </p>
     * 
     * @return Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB
     *         cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the DB cluster parameter group for the DB cluster.
     * </p>
     * 
     * @return Specifies the name of the DB cluster parameter group for the DB cluster.
     */
    public final String dbClusterParameterGroup() {
        return dbClusterParameterGroup;
    }

    /**
     * <p>
     * Specifies information on the subnet group associated with the DB cluster, including the name, description, and
     * subnets in the subnet group.
     * </p>
     * 
     * @return Specifies information on the subnet group associated with the DB cluster, including the name,
     *         description, and subnets in the subnet group.
     */
    public final String dbSubnetGroup() {
        return dbSubnetGroup;
    }

    /**
     * <p>
     * Specifies the current state of this DB cluster.
     * </p>
     * 
     * @return Specifies the current state of this DB cluster.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Specifies the progress of the operation as a percentage.
     * </p>
     * 
     * @return Specifies the progress of the operation as a percentage.
     */
    public final String percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * Specifies the earliest time to which a database can be restored with point-in-time restore.
     * </p>
     * 
     * @return Specifies the earliest time to which a database can be restored with point-in-time restore.
     */
    public final Instant earliestRestorableTime() {
        return earliestRestorableTime;
    }

    /**
     * <p>
     * Specifies the connection endpoint for the primary instance of the DB cluster.
     * </p>
     * 
     * @return Specifies the connection endpoint for the primary instance of the DB cluster.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the
     * Read Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint,
     * Neptune distributes the connection requests among the Read Replicas in the DB cluster. This functionality can
     * help balance your read workload across multiple Read Replicas in your DB cluster.
     * </p>
     * <p>
     * If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary instance, your
     * connection is dropped. To continue sending your read workload to other Read Replicas in the cluster, you can then
     * reconnect to the reader endpoint.
     * </p>
     * 
     * @return The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections
     *         across the Read Replicas that are available in a DB cluster. As clients request new connections to the
     *         reader endpoint, Neptune distributes the connection requests among the Read Replicas in the DB cluster.
     *         This functionality can help balance your read workload across multiple Read Replicas in your DB
     *         cluster.</p>
     *         <p>
     *         If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary
     *         instance, your connection is dropped. To continue sending your read workload to other Read Replicas in
     *         the cluster, you can then reconnect to the reader endpoint.
     */
    public final String readerEndpoint() {
        return readerEndpoint;
    }

    /**
     * <p>
     * Specifies whether the DB cluster has instances in multiple Availability Zones.
     * </p>
     * 
     * @return Specifies whether the DB cluster has instances in multiple Availability Zones.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * Provides the name of the database engine to be used for this DB cluster.
     * </p>
     * 
     * @return Provides the name of the database engine to be used for this DB cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     * </p>
     * 
     * @return Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public final Instant latestRestorableTime() {
        return latestRestorableTime;
    }

    /**
     * <p>
     * Specifies the port that the database engine is listening on.
     * </p>
     * 
     * @return Specifies the port that the database engine is listening on.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBClusterOptionGroupMemberships
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDbClusterOptionGroupMemberships() {
        return dbClusterOptionGroupMemberships != null && !(dbClusterOptionGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterOptionGroupMemberships}
     * method.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships() {
        return dbClusterOptionGroupMemberships;
    }

    /**
     * <p>
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as
     * determined by the <code>BackupRetentionPeriod</code>.
     * </p>
     * 
     * @return Specifies the daily time range during which automated backups are created if automated backups are
     *         enabled, as determined by the <code>BackupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
     *         (UTC).
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Not supported by Neptune.
     * </p>
     * 
     * @return Not supported by Neptune.
     */
    public final String replicationSourceIdentifier() {
        return replicationSourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadReplicaIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReadReplicaIdentifiers() {
        return readReplicaIdentifiers != null && !(readReplicaIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains one or more identifiers of the Read Replicas associated with this DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadReplicaIdentifiers} method.
     * </p>
     * 
     * @return Contains one or more identifiers of the Read Replicas associated with this DB cluster.
     */
    public final List<String> readReplicaIdentifiers() {
        return readReplicaIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBClusterMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbClusterMembers() {
        return dbClusterMembers != null && !(dbClusterMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of instances that make up the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterMembers} method.
     * </p>
     * 
     * @return Provides the list of instances that make up the DB cluster.
     */
    public final List<DBClusterMember> dbClusterMembers() {
        return dbClusterMembers;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of VPC security groups that the DB cluster belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return Provides a list of VPC security groups that the DB cluster belongs to.
     */
    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     * </p>
     * 
     * @return Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * Specifies whether the DB cluster is encrypted.
     * </p>
     * 
     * @return Specifies whether the DB cluster is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB cluster.
     * </p>
     * 
     * @return If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon CloudTrail
     * log entries whenever the Amazon KMS key for the DB cluster is accessed.
     * </p>
     * 
     * @return The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon
     *         CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.
     */
    public final String dbClusterResourceId() {
        return dbClusterResourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the DB cluster.
     */
    public final String dbClusterArn() {
        return dbClusterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedRoles() {
        return associatedRoles != null && !(associatedRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon
     * services on your behalf.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedRoles} method.
     * </p>
     * 
     * @return Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB
     *         cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access
     *         other Amazon services on your behalf.
     */
    public final List<DBClusterRole> associatedRoles() {
        return associatedRoles;
    }

    /**
     * <p>
     * True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and
     * otherwise false.
     * </p>
     * 
     * @return True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled,
     *         and otherwise false.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * Identifies the clone group to which the DB cluster is associated.
     * </p>
     * 
     * @return Identifies the clone group to which the DB cluster is associated.
     */
    public final String cloneGroupId() {
        return cloneGroupId;
    }

    /**
     * <p>
     * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
     */
    public final Instant clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * <p>
     * <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i>
     * </p>
     * 
     * @return <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i>
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports != null && !(enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledCloudwatchLogsExports} method.
     * </p>
     * 
     * @return A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     */
    public final List<String> enabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports;
    }

    /**
     * <p>
     * Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when
     * deletion protection is enabled.
     * </p>
     * 
     * @return Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted
     *         when deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * If set to <code>true</code>, the DB cluster can be cloned across accounts.
     * </p>
     * 
     * @return If set to <code>true</code>, the DB cluster can be cloned across accounts.
     */
    public final Boolean crossAccountClone() {
        return crossAccountClone;
    }

    /**
     * <p>
     * Time at which the DB cluster will be automatically restarted.
     * </p>
     * 
     * @return Time at which the DB cluster will be automatically restarted.
     */
    public final Instant automaticRestartTime() {
        return automaticRestartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(earliestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDbClusterOptionGroupMemberships() ? dbClusterOptionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadReplicaIdentifiers() ? readReplicaIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterMembers() ? dbClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedRoles() ? associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloneGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountClone());
        hashCode = 31 * hashCode + Objects.hashCode(automaticRestartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster) obj;
        return Objects.equals(allocatedStorage(), other.allocatedStorage())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterParameterGroup(), other.dbClusterParameterGroup())
                && Objects.equals(dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(status(), other.status())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(earliestRestorableTime(), other.earliestRestorableTime())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(readerEndpoint(), other.readerEndpoint())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUsername(), other.masterUsername())
                && hasDbClusterOptionGroupMemberships() == other.hasDbClusterOptionGroupMemberships()
                && Objects.equals(dbClusterOptionGroupMemberships(), other.dbClusterOptionGroupMemberships())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(replicationSourceIdentifier(), other.replicationSourceIdentifier())
                && hasReadReplicaIdentifiers() == other.hasReadReplicaIdentifiers()
                && Objects.equals(readReplicaIdentifiers(), other.readReplicaIdentifiers())
                && hasDbClusterMembers() == other.hasDbClusterMembers()
                && Objects.equals(dbClusterMembers(), other.dbClusterMembers())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dbClusterResourceId(), other.dbClusterResourceId())
                && Objects.equals(dbClusterArn(), other.dbClusterArn()) && hasAssociatedRoles() == other.hasAssociatedRoles()
                && Objects.equals(associatedRoles(), other.associatedRoles())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(cloneGroupId(), other.cloneGroupId())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports()
                && Objects.equals(enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(crossAccountClone(), other.crossAccountClone())
                && Objects.equals(automaticRestartTime(), other.automaticRestartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DBCluster")
                .add("AllocatedStorage", allocatedStorage())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("CharacterSetName", characterSetName())
                .add("DatabaseName", databaseName())
                .add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBClusterParameterGroup", dbClusterParameterGroup())
                .add("DBSubnetGroup", dbSubnetGroup())
                .add("Status", status())
                .add("PercentProgress", percentProgress())
                .add("EarliestRestorableTime", earliestRestorableTime())
                .add("Endpoint", endpoint())
                .add("ReaderEndpoint", readerEndpoint())
                .add("MultiAZ", multiAZ())
                .add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("LatestRestorableTime", latestRestorableTime())
                .add("Port", port())
                .add("MasterUsername", masterUsername())
                .add("DBClusterOptionGroupMemberships",
                        hasDbClusterOptionGroupMemberships() ? dbClusterOptionGroupMemberships() : null)
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("ReplicationSourceIdentifier", replicationSourceIdentifier())
                .add("ReadReplicaIdentifiers", hasReadReplicaIdentifiers() ? readReplicaIdentifiers() : null)
                .add("DBClusterMembers", hasDbClusterMembers() ? dbClusterMembers() : null)
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("HostedZoneId", hostedZoneId()).add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId())
                .add("DbClusterResourceId", dbClusterResourceId()).add("DBClusterArn", dbClusterArn())
                .add("AssociatedRoles", hasAssociatedRoles() ? associatedRoles() : null)
                .add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled()).add("CloneGroupId", cloneGroupId())
                .add("ClusterCreateTime", clusterCreateTime()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("EnabledCloudwatchLogsExports", hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null)
                .add("DeletionProtection", deletionProtection()).add("CrossAccountClone", crossAccountClone())
                .add("AutomaticRestartTime", automaticRestartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBClusterParameterGroup":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroup()));
        case "DBSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PercentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "EarliestRestorableTime":
            return Optional.ofNullable(clazz.cast(earliestRestorableTime()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "ReaderEndpoint":
            return Optional.ofNullable(clazz.cast(readerEndpoint()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LatestRestorableTime":
            return Optional.ofNullable(clazz.cast(latestRestorableTime()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "DBClusterOptionGroupMemberships":
            return Optional.ofNullable(clazz.cast(dbClusterOptionGroupMemberships()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "ReplicationSourceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSourceIdentifier()));
        case "ReadReplicaIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaIdentifiers()));
        case "DBClusterMembers":
            return Optional.ofNullable(clazz.cast(dbClusterMembers()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DbClusterResourceId":
            return Optional.ofNullable(clazz.cast(dbClusterResourceId()));
        case "DBClusterArn":
            return Optional.ofNullable(clazz.cast(dbClusterArn()));
        case "AssociatedRoles":
            return Optional.ofNullable(clazz.cast(associatedRoles()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "CloneGroupId":
            return Optional.ofNullable(clazz.cast(cloneGroupId()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "EnabledCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enabledCloudwatchLogsExports()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "CrossAccountClone":
            return Optional.ofNullable(clazz.cast(crossAccountClone()));
        case "AutomaticRestartTime":
            return Optional.ofNullable(clazz.cast(automaticRestartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBCluster, T> g) {
        return obj -> g.apply((DBCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBCluster> {
        /**
         * <p>
         * <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is not fixed, but
         * instead automatically adjusts as needed.
         * </p>
         * 
         * @param allocatedStorage
         *        <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is not fixed,
         *        but instead automatically adjusts as needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * Specifies the number of days for which automatic DB snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        Specifies the number of days for which automatic DB snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param characterSetName
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * Contains the name of the initial database of this DB cluster that was provided at create time, if one was
         * specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
         * </p>
         * 
         * @param databaseName
         *        Contains the name of the initial database of this DB cluster that was provided at create time, if one
         *        was specified when the DB cluster was created. This same name is returned for the life of the DB
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB
         * cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Specifies the name of the DB cluster parameter group for the DB cluster.
         * </p>
         * 
         * @param dbClusterParameterGroup
         *        Specifies the name of the DB cluster parameter group for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroup(String dbClusterParameterGroup);

        /**
         * <p>
         * Specifies information on the subnet group associated with the DB cluster, including the name, description,
         * and subnets in the subnet group.
         * </p>
         * 
         * @param dbSubnetGroup
         *        Specifies information on the subnet group associated with the DB cluster, including the name,
         *        description, and subnets in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(String dbSubnetGroup);

        /**
         * <p>
         * Specifies the current state of this DB cluster.
         * </p>
         * 
         * @param status
         *        Specifies the current state of this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the progress of the operation as a percentage.
         * </p>
         * 
         * @param percentProgress
         *        Specifies the progress of the operation as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(String percentProgress);

        /**
         * <p>
         * Specifies the earliest time to which a database can be restored with point-in-time restore.
         * </p>
         * 
         * @param earliestRestorableTime
         *        Specifies the earliest time to which a database can be restored with point-in-time restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestRestorableTime(Instant earliestRestorableTime);

        /**
         * <p>
         * Specifies the connection endpoint for the primary instance of the DB cluster.
         * </p>
         * 
         * @param endpoint
         *        Specifies the connection endpoint for the primary instance of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across
         * the Read Replicas that are available in a DB cluster. As clients request new connections to the reader
         * endpoint, Neptune distributes the connection requests among the Read Replicas in the DB cluster. This
         * functionality can help balance your read workload across multiple Read Replicas in your DB cluster.
         * </p>
         * <p>
         * If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary instance,
         * your connection is dropped. To continue sending your read workload to other Read Replicas in the cluster, you
         * can then reconnect to the reader endpoint.
         * </p>
         * 
         * @param readerEndpoint
         *        The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections
         *        across the Read Replicas that are available in a DB cluster. As clients request new connections to the
         *        reader endpoint, Neptune distributes the connection requests among the Read Replicas in the DB
         *        cluster. This functionality can help balance your read workload across multiple Read Replicas in your
         *        DB cluster.</p>
         *        <p>
         *        If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary
         *        instance, your connection is dropped. To continue sending your read workload to other Read Replicas in
         *        the cluster, you can then reconnect to the reader endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerEndpoint(String readerEndpoint);

        /**
         * <p>
         * Specifies whether the DB cluster has instances in multiple Availability Zones.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the DB cluster has instances in multiple Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * Provides the name of the database engine to be used for this DB cluster.
         * </p>
         * 
         * @param engine
         *        Provides the name of the database engine to be used for this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         * </p>
         * 
         * @param latestRestorableTime
         *        Specifies the latest time to which a database can be restored with point-in-time restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableTime(Instant latestRestorableTime);

        /**
         * <p>
         * Specifies the port that the database engine is listening on.
         * </p>
         * 
         * @param port
         *        Specifies the port that the database engine is listening on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param masterUsername
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param dbClusterOptionGroupMemberships
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param dbClusterOptionGroupMemberships
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus... dbClusterOptionGroupMemberships);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DBClusterOptionGroupStatus>.Builder}
         * avoiding the need to create one manually via {@link List<DBClusterOptionGroupStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterOptionGroupStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dbClusterOptionGroupMemberships(List<DBClusterOptionGroupStatus>)}.
         * 
         * @param dbClusterOptionGroupMemberships
         *        a consumer that will call methods on {@link List<DBClusterOptionGroupStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterOptionGroupMemberships(List<DBClusterOptionGroupStatus>)
         */
        Builder dbClusterOptionGroupMemberships(Consumer<DBClusterOptionGroupStatus.Builder>... dbClusterOptionGroupMemberships);

        /**
         * <p>
         * Specifies the daily time range during which automated backups are created if automated backups are enabled,
         * as determined by the <code>BackupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        Specifies the daily time range during which automated backups are created if automated backups are
         *        enabled, as determined by the <code>BackupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
         * (UTC).
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Not supported by Neptune.
         * </p>
         * 
         * @param replicationSourceIdentifier
         *        Not supported by Neptune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSourceIdentifier(String replicationSourceIdentifier);

        /**
         * <p>
         * Contains one or more identifiers of the Read Replicas associated with this DB cluster.
         * </p>
         * 
         * @param readReplicaIdentifiers
         *        Contains one or more identifiers of the Read Replicas associated with this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers);

        /**
         * <p>
         * Contains one or more identifiers of the Read Replicas associated with this DB cluster.
         * </p>
         * 
         * @param readReplicaIdentifiers
         *        Contains one or more identifiers of the Read Replicas associated with this DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaIdentifiers(String... readReplicaIdentifiers);

        /**
         * <p>
         * Provides the list of instances that make up the DB cluster.
         * </p>
         * 
         * @param dbClusterMembers
         *        Provides the list of instances that make up the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers);

        /**
         * <p>
         * Provides the list of instances that make up the DB cluster.
         * </p>
         * 
         * @param dbClusterMembers
         *        Provides the list of instances that make up the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterMembers(DBClusterMember... dbClusterMembers);

        /**
         * <p>
         * Provides the list of instances that make up the DB cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DBClusterMember>.Builder} avoiding
         * the need to create one manually via {@link List<DBClusterMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterMember>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbClusterMembers(List<DBClusterMember>)}.
         * 
         * @param dbClusterMembers
         *        a consumer that will call methods on {@link List<DBClusterMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterMembers(List<DBClusterMember>)
         */
        Builder dbClusterMembers(Consumer<DBClusterMember.Builder>... dbClusterMembers);

        /**
         * <p>
         * Provides a list of VPC security groups that the DB cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of VPC security groups that the DB cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security groups that the DB cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of VPC security groups that the DB cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security groups that the DB cluster belongs to.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VpcSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<VpcSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcSecurityGroups(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on {@link List<VpcSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(List<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * Specifies whether the DB cluster is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether the DB cluster is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon
         * CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.
         * </p>
         * 
         * @param dbClusterResourceId
         *        The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon
         *        CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterResourceId(String dbClusterResourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the DB cluster.
         * </p>
         * 
         * @param dbClusterArn
         *        The Amazon Resource Name (ARN) for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterArn(String dbClusterArn);

        /**
         * <p>
         * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB
         * cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other
         * Amazon services on your behalf.
         * </p>
         * 
         * @param associatedRoles
         *        Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the
         *        DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to
         *        access other Amazon services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(Collection<DBClusterRole> associatedRoles);

        /**
         * <p>
         * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB
         * cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other
         * Amazon services on your behalf.
         * </p>
         * 
         * @param associatedRoles
         *        Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the
         *        DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to
         *        access other Amazon services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(DBClusterRole... associatedRoles);

        /**
         * <p>
         * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB
         * cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other
         * Amazon services on your behalf.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DBClusterRole>.Builder} avoiding the
         * need to create one manually via {@link List<DBClusterRole>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterRole>.Builder#build()} is called immediately and
         * its result is passed to {@link #associatedRoles(List<DBClusterRole>)}.
         * 
         * @param associatedRoles
         *        a consumer that will call methods on {@link List<DBClusterRole>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedRoles(List<DBClusterRole>)
         */
        Builder associatedRoles(Consumer<DBClusterRole.Builder>... associatedRoles);

        /**
         * <p>
         * True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and
         * otherwise false.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is
         *        enabled, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * Identifies the clone group to which the DB cluster is associated.
         * </p>
         * 
         * @param cloneGroupId
         *        Identifies the clone group to which the DB cluster is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloneGroupId(String cloneGroupId);

        /**
         * <p>
         * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param clusterCreateTime
         *        Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(Instant clusterCreateTime);

        /**
         * <p>
         * <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i>
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports);

        /**
         * <p>
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports);

        /**
         * <p>
         * Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when
         * deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted
         *        when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * If set to <code>true</code>, the DB cluster can be cloned across accounts.
         * </p>
         * 
         * @param crossAccountClone
         *        If set to <code>true</code>, the DB cluster can be cloned across accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountClone(Boolean crossAccountClone);

        /**
         * <p>
         * Time at which the DB cluster will be automatically restarted.
         * </p>
         * 
         * @param automaticRestartTime
         *        Time at which the DB cluster will be automatically restarted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticRestartTime(Instant automaticRestartTime);
    }

    static final class BuilderImpl implements Builder {
        private Integer allocatedStorage;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer backupRetentionPeriod;

        private String characterSetName;

        private String databaseName;

        private String dbClusterIdentifier;

        private String dbClusterParameterGroup;

        private String dbSubnetGroup;

        private String status;

        private String percentProgress;

        private Instant earliestRestorableTime;

        private String endpoint;

        private String readerEndpoint;

        private Boolean multiAZ;

        private String engine;

        private String engineVersion;

        private Instant latestRestorableTime;

        private Integer port;

        private String masterUsername;

        private List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private String replicationSourceIdentifier;

        private List<String> readReplicaIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<DBClusterMember> dbClusterMembers = DefaultSdkAutoConstructList.getInstance();

        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String hostedZoneId;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String dbClusterResourceId;

        private String dbClusterArn;

        private List<DBClusterRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private Boolean iamDatabaseAuthenticationEnabled;

        private String cloneGroupId;

        private Instant clusterCreateTime;

        private Boolean copyTagsToSnapshot;

        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private Boolean crossAccountClone;

        private Instant automaticRestartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DBCluster model) {
            allocatedStorage(model.allocatedStorage);
            availabilityZones(model.availabilityZones);
            backupRetentionPeriod(model.backupRetentionPeriod);
            characterSetName(model.characterSetName);
            databaseName(model.databaseName);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterParameterGroup(model.dbClusterParameterGroup);
            dbSubnetGroup(model.dbSubnetGroup);
            status(model.status);
            percentProgress(model.percentProgress);
            earliestRestorableTime(model.earliestRestorableTime);
            endpoint(model.endpoint);
            readerEndpoint(model.readerEndpoint);
            multiAZ(model.multiAZ);
            engine(model.engine);
            engineVersion(model.engineVersion);
            latestRestorableTime(model.latestRestorableTime);
            port(model.port);
            masterUsername(model.masterUsername);
            dbClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            replicationSourceIdentifier(model.replicationSourceIdentifier);
            readReplicaIdentifiers(model.readReplicaIdentifiers);
            dbClusterMembers(model.dbClusterMembers);
            vpcSecurityGroups(model.vpcSecurityGroups);
            hostedZoneId(model.hostedZoneId);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            dbClusterResourceId(model.dbClusterResourceId);
            dbClusterArn(model.dbClusterArn);
            associatedRoles(model.associatedRoles);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            cloneGroupId(model.cloneGroupId);
            clusterCreateTime(model.clusterCreateTime);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
            deletionProtection(model.deletionProtection);
            crossAccountClone(model.crossAccountClone);
            automaticRestartTime(model.automaticRestartTime);
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        @Transient
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        @Transient
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroup() {
            return dbClusterParameterGroup;
        }

        public final void setDbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        @Override
        @Transient
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final String getDbSubnetGroup() {
            return dbSubnetGroup;
        }

        public final void setDbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        @Override
        @Transient
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        @Transient
        public final Builder percentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final Instant getEarliestRestorableTime() {
            return earliestRestorableTime;
        }

        public final void setEarliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
        }

        @Override
        @Transient
        public final Builder earliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        @Transient
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        @Transient
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Instant getLatestRestorableTime() {
            return latestRestorableTime;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        @Override
        @Transient
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        @Transient
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final List<DBClusterOptionGroupStatus.Builder> getDbClusterOptionGroupMemberships() {
            List<DBClusterOptionGroupStatus.Builder> result = DBClusterOptionGroupMembershipsCopier
                    .copyToBuilder(this.dbClusterOptionGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterOptionGroupMemberships(
                Collection<DBClusterOptionGroupStatus.BuilderImpl> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier
                    .copyFromBuilder(dbClusterOptionGroupMemberships);
        }

        @Override
        @Transient
        public final Builder dbClusterOptionGroupMemberships(
                Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus... dbClusterOptionGroupMemberships) {
            dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(
                Consumer<DBClusterOptionGroupStatus.Builder>... dbClusterOptionGroupMemberships) {
            dbClusterOptionGroupMemberships(Stream.of(dbClusterOptionGroupMemberships)
                    .map(c -> DBClusterOptionGroupStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        @Transient
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        @Transient
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSourceIdentifier() {
            return replicationSourceIdentifier;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        @Override
        @Transient
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            if (readReplicaIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaIdentifiers;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
        }

        @Override
        @Transient
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String... readReplicaIdentifiers) {
            readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final List<DBClusterMember.Builder> getDbClusterMembers() {
            List<DBClusterMember.Builder> result = DBClusterMemberListCopier.copyToBuilder(this.dbClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterMembers(Collection<DBClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copyFromBuilder(dbClusterMembers);
        }

        @Override
        @Transient
        public final Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbClusterMembers(DBClusterMember... dbClusterMembers) {
            dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbClusterMembers(Consumer<DBClusterMember.Builder>... dbClusterMembers) {
            dbClusterMembers(Stream.of(dbClusterMembers).map(c -> DBClusterMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        @Transient
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        @Transient
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        @Transient
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterResourceId() {
            return dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        @Transient
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final String getDbClusterArn() {
            return dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        @Transient
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final List<DBClusterRole.Builder> getAssociatedRoles() {
            List<DBClusterRole.Builder> result = DBClusterRolesCopier.copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<DBClusterRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        @Transient
        public final Builder associatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associatedRoles(DBClusterRole... associatedRoles) {
            associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associatedRoles(Consumer<DBClusterRole.Builder>... associatedRoles) {
            associatedRoles(Stream.of(associatedRoles).map(c -> DBClusterRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        @Transient
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final String getCloneGroupId() {
            return cloneGroupId;
        }

        public final void setCloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
        }

        @Override
        @Transient
        public final Builder cloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
            return this;
        }

        public final Instant getClusterCreateTime() {
            return clusterCreateTime;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        @Transient
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        @Transient
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledCloudwatchLogsExports;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        @Override
        @Transient
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports) {
            enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        @Transient
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getCrossAccountClone() {
            return crossAccountClone;
        }

        public final void setCrossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
        }

        @Override
        @Transient
        public final Builder crossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
            return this;
        }

        public final Instant getAutomaticRestartTime() {
            return automaticRestartTime;
        }

        public final void setAutomaticRestartTime(Instant automaticRestartTime) {
            this.automaticRestartTime = automaticRestartTime;
        }

        @Override
        @Transient
        public final Builder automaticRestartTime(Instant automaticRestartTime) {
            this.automaticRestartTime = automaticRestartTime;
            return this;
        }

        @Override
        public DBCluster build() {
            return new DBCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
