/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbClusterEndpointRequest extends NeptuneRequest implements
        ToCopyableBuilder<CreateDbClusterEndpointRequest.Builder, CreateDbClusterEndpointRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(CreateDbClusterEndpointRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterEndpointIdentifier")
            .getter(getter(CreateDbClusterEndpointRequest::dbClusterEndpointIdentifier))
            .setter(setter(Builder::dbClusterEndpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier")
                    .build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(CreateDbClusterEndpointRequest::endpointType))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StaticMembers")
            .getter(getter(CreateDbClusterEndpointRequest::staticMembers))
            .setter(setter(Builder::staticMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedMembers")
            .getter(getter(CreateDbClusterEndpointRequest::excludedMembers))
            .setter(setter(Builder::excludedMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbClusterEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD, EXCLUDED_MEMBERS_FIELD, TAGS_FIELD));

    private final String dbClusterIdentifier;

    private final String dbClusterEndpointIdentifier;

    private final String endpointType;

    private final List<String> staticMembers;

    private final List<String> excludedMembers;

    private final List<Tag> tags;

    private CreateDbClusterEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.endpointType = builder.endpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase
     * string.
     * </p>
     * 
     * @return The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a
     *         lowercase string.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
     */
    public final String dbClusterEndpointIdentifier() {
        return dbClusterEndpointIdentifier;
    }

    /**
     * <p>
     * The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
     * </p>
     * 
     * @return The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
     */
    public final String endpointType() {
        return endpointType;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaticMembers() {
        return staticMembers != null && !(staticMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of DB instance identifiers that are part of the custom endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticMembers} method.
     * </p>
     * 
     * @return List of DB instance identifiers that are part of the custom endpoint group.
     */
    public final List<String> staticMembers() {
        return staticMembers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedMembers() {
        return excludedMembers != null && !(excludedMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are
     * reachable through the custom endpoint. Only relevant if the list of static members is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedMembers} method.
     * </p>
     * 
     * @return List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
     *         instances are reachable through the custom endpoint. Only relevant if the list of static members is
     *         empty.
     */
    public final List<String> excludedMembers() {
        return excludedMembers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the Amazon Neptune resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the Amazon Neptune resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticMembers() ? staticMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedMembers() ? excludedMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbClusterEndpointRequest)) {
            return false;
        }
        CreateDbClusterEndpointRequest other = (CreateDbClusterEndpointRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier())
                && Objects.equals(endpointType(), other.endpointType()) && hasStaticMembers() == other.hasStaticMembers()
                && Objects.equals(staticMembers(), other.staticMembers()) && hasExcludedMembers() == other.hasExcludedMembers()
                && Objects.equals(excludedMembers(), other.excludedMembers()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbClusterEndpointRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBClusterEndpointIdentifier", dbClusterEndpointIdentifier()).add("EndpointType", endpointType())
                .add("StaticMembers", hasStaticMembers() ? staticMembers() : null)
                .add("ExcludedMembers", hasExcludedMembers() ? excludedMembers() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBClusterEndpointIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterEndpointIdentifier()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        case "StaticMembers":
            return Optional.ofNullable(clazz.cast(staticMembers()));
        case "ExcludedMembers":
            return Optional.ofNullable(clazz.cast(excludedMembers()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbClusterEndpointRequest, T> g) {
        return obj -> g.apply((CreateDbClusterEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbClusterEndpointRequest> {
        /**
         * <p>
         * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a
         * lowercase string.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as
         *        a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param dbClusterEndpointIdentifier
         *        The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier);

        /**
         * <p>
         * The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * List of DB instance identifiers that are part of the custom endpoint group.
         * </p>
         * 
         * @param staticMembers
         *        List of DB instance identifiers that are part of the custom endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticMembers(Collection<String> staticMembers);

        /**
         * <p>
         * List of DB instance identifiers that are part of the custom endpoint group.
         * </p>
         * 
         * @param staticMembers
         *        List of DB instance identifiers that are part of the custom endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticMembers(String... staticMembers);

        /**
         * <p>
         * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances
         * are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * </p>
         * 
         * @param excludedMembers
         *        List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
         *        instances are reachable through the custom endpoint. Only relevant if the list of static members is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedMembers(Collection<String> excludedMembers);

        /**
         * <p>
         * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances
         * are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * </p>
         * 
         * @param excludedMembers
         *        List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
         *        instances are reachable through the custom endpoint. Only relevant if the list of static members is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedMembers(String... excludedMembers);

        /**
         * <p>
         * The tags to be assigned to the Amazon Neptune resource.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the Amazon Neptune resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the Amazon Neptune resource.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the Amazon Neptune resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the Amazon Neptune resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String dbClusterEndpointIdentifier;

        private String endpointType;

        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbClusterEndpointRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            endpointType(model.endpointType);
            staticMembers(model.staticMembers);
            excludedMembers(model.excludedMembers);
            tags(model.tags);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterEndpointIdentifier() {
            return dbClusterEndpointIdentifier;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final Collection<String> getStaticMembers() {
            if (staticMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return staticMembers;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        @Override
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticMembers(String... staticMembers) {
            staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final Collection<String> getExcludedMembers() {
            if (excludedMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedMembers;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        @Override
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedMembers(String... excludedMembers) {
            excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbClusterEndpointRequest build() {
            return new CreateDbClusterEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
