/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a list of available options for a DB instance.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>DescribeOrderableDBInstanceOptions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrderableDBInstanceOption implements SdkPojo, Serializable,
        ToCopyableBuilder<OrderableDBInstanceOption.Builder, OrderableDBInstanceOption> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(OrderableDBInstanceOption::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(OrderableDBInstanceOption::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(OrderableDBInstanceOption::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(OrderableDBInstanceOption::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(OrderableDBInstanceOption::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Boolean> MULTI_AZ_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZCapable").getter(getter(OrderableDBInstanceOption::multiAZCapable))
            .setter(setter(Builder::multiAZCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZCapable").build()).build();

    private static final SdkField<Boolean> READ_REPLICA_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadReplicaCapable").getter(getter(OrderableDBInstanceOption::readReplicaCapable))
            .setter(setter(Builder::readReplicaCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaCapable").build())
            .build();

    private static final SdkField<Boolean> VPC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Vpc")
            .getter(getter(OrderableDBInstanceOption::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final SdkField<Boolean> SUPPORTS_STORAGE_ENCRYPTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SupportsStorageEncryption")
            .getter(getter(OrderableDBInstanceOption::supportsStorageEncryption))
            .setter(setter(Builder::supportsStorageEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageEncryption").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(OrderableDBInstanceOption::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Boolean> SUPPORTS_IOPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsIops").getter(getter(OrderableDBInstanceOption::supportsIops))
            .setter(setter(Builder::supportsIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIops").build()).build();

    private static final SdkField<Boolean> SUPPORTS_ENHANCED_MONITORING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsEnhancedMonitoring")
            .getter(getter(OrderableDBInstanceOption::supportsEnhancedMonitoring))
            .setter(setter(Builder::supportsEnhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsEnhancedMonitoring").build())
            .build();

    private static final SdkField<Boolean> SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsIAMDatabaseAuthentication")
            .getter(getter(OrderableDBInstanceOption::supportsIAMDatabaseAuthentication))
            .setter(setter(Builder::supportsIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Boolean> SUPPORTS_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsPerformanceInsights")
            .getter(getter(OrderableDBInstanceOption::supportsPerformanceInsights))
            .setter(setter(Builder::supportsPerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsPerformanceInsights")
                    .build()).build();

    private static final SdkField<Integer> MIN_STORAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinStorageSize").getter(getter(OrderableDBInstanceOption::minStorageSize))
            .setter(setter(Builder::minStorageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageSize").build()).build();

    private static final SdkField<Integer> MAX_STORAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxStorageSize").getter(getter(OrderableDBInstanceOption::maxStorageSize))
            .setter(setter(Builder::maxStorageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageSize").build()).build();

    private static final SdkField<Integer> MIN_IOPS_PER_DB_INSTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinIopsPerDbInstance").getter(getter(OrderableDBInstanceOption::minIopsPerDbInstance))
            .setter(setter(Builder::minIopsPerDbInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIopsPerDbInstance").build())
            .build();

    private static final SdkField<Integer> MAX_IOPS_PER_DB_INSTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxIopsPerDbInstance").getter(getter(OrderableDBInstanceOption::maxIopsPerDbInstance))
            .setter(setter(Builder::maxIopsPerDbInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIopsPerDbInstance").build())
            .build();

    private static final SdkField<Double> MIN_IOPS_PER_GIB_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinIopsPerGib").getter(getter(OrderableDBInstanceOption::minIopsPerGib))
            .setter(setter(Builder::minIopsPerGib))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIopsPerGib").build()).build();

    private static final SdkField<Double> MAX_IOPS_PER_GIB_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxIopsPerGib").getter(getter(OrderableDBInstanceOption::maxIopsPerGib))
            .setter(setter(Builder::maxIopsPerGib))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIopsPerGib").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DB_INSTANCE_CLASS_FIELD, LICENSE_MODEL_FIELD, AVAILABILITY_ZONES_FIELD, MULTI_AZ_CAPABLE_FIELD,
            READ_REPLICA_CAPABLE_FIELD, VPC_FIELD, SUPPORTS_STORAGE_ENCRYPTION_FIELD, STORAGE_TYPE_FIELD, SUPPORTS_IOPS_FIELD,
            SUPPORTS_ENHANCED_MONITORING_FIELD, SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD, SUPPORTS_PERFORMANCE_INSIGHTS_FIELD,
            MIN_STORAGE_SIZE_FIELD, MAX_STORAGE_SIZE_FIELD, MIN_IOPS_PER_DB_INSTANCE_FIELD, MAX_IOPS_PER_DB_INSTANCE_FIELD,
            MIN_IOPS_PER_GIB_FIELD, MAX_IOPS_PER_GIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engine;

    private final String engineVersion;

    private final String dbInstanceClass;

    private final String licenseModel;

    private final List<AvailabilityZone> availabilityZones;

    private final Boolean multiAZCapable;

    private final Boolean readReplicaCapable;

    private final Boolean vpc;

    private final Boolean supportsStorageEncryption;

    private final String storageType;

    private final Boolean supportsIops;

    private final Boolean supportsEnhancedMonitoring;

    private final Boolean supportsIAMDatabaseAuthentication;

    private final Boolean supportsPerformanceInsights;

    private final Integer minStorageSize;

    private final Integer maxStorageSize;

    private final Integer minIopsPerDbInstance;

    private final Integer maxIopsPerDbInstance;

    private final Double minIopsPerGib;

    private final Double maxIopsPerGib;

    private OrderableDBInstanceOption(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.licenseModel = builder.licenseModel;
        this.availabilityZones = builder.availabilityZones;
        this.multiAZCapable = builder.multiAZCapable;
        this.readReplicaCapable = builder.readReplicaCapable;
        this.vpc = builder.vpc;
        this.supportsStorageEncryption = builder.supportsStorageEncryption;
        this.storageType = builder.storageType;
        this.supportsIops = builder.supportsIops;
        this.supportsEnhancedMonitoring = builder.supportsEnhancedMonitoring;
        this.supportsIAMDatabaseAuthentication = builder.supportsIAMDatabaseAuthentication;
        this.supportsPerformanceInsights = builder.supportsPerformanceInsights;
        this.minStorageSize = builder.minStorageSize;
        this.maxStorageSize = builder.maxStorageSize;
        this.minIopsPerDbInstance = builder.minIopsPerDbInstance;
        this.maxIopsPerDbInstance = builder.maxIopsPerDbInstance;
        this.minIopsPerGib = builder.minIopsPerGib;
        this.maxIopsPerGib = builder.maxIopsPerGib;
    }

    /**
     * <p>
     * The engine type of a DB instance.
     * </p>
     * 
     * @return The engine type of a DB instance.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine version of a DB instance.
     * </p>
     * 
     * @return The engine version of a DB instance.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The DB instance class for a DB instance.
     * </p>
     * 
     * @return The DB instance class for a DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The license model for a DB instance.
     * </p>
     * 
     * @return The license model for a DB instance.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones for a DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Availability Zones for a DB instance.
     */
    public final List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * Indicates whether a DB instance is Multi-AZ capable.
     * </p>
     * 
     * @return Indicates whether a DB instance is Multi-AZ capable.
     */
    public final Boolean multiAZCapable() {
        return multiAZCapable;
    }

    /**
     * <p>
     * Indicates whether a DB instance can have a Read Replica.
     * </p>
     * 
     * @return Indicates whether a DB instance can have a Read Replica.
     */
    public final Boolean readReplicaCapable() {
        return readReplicaCapable;
    }

    /**
     * <p>
     * Indicates whether a DB instance is in a VPC.
     * </p>
     * 
     * @return Indicates whether a DB instance is in a VPC.
     */
    public final Boolean vpc() {
        return vpc;
    }

    /**
     * <p>
     * Indicates whether a DB instance supports encrypted storage.
     * </p>
     * 
     * @return Indicates whether a DB instance supports encrypted storage.
     */
    public final Boolean supportsStorageEncryption() {
        return supportsStorageEncryption;
    }

    /**
     * <p>
     * Indicates the storage type for a DB instance.
     * </p>
     * 
     * @return Indicates the storage type for a DB instance.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * Indicates whether a DB instance supports provisioned IOPS.
     * </p>
     * 
     * @return Indicates whether a DB instance supports provisioned IOPS.
     */
    public final Boolean supportsIops() {
        return supportsIops;
    }

    /**
     * <p>
     * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     * </p>
     * 
     * @return Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     */
    public final Boolean supportsEnhancedMonitoring() {
        return supportsEnhancedMonitoring;
    }

    /**
     * <p>
     * Indicates whether a DB instance supports IAM database authentication.
     * </p>
     * 
     * @return Indicates whether a DB instance supports IAM database authentication.
     */
    public final Boolean supportsIAMDatabaseAuthentication() {
        return supportsIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * <i>(Not supported by Neptune)</i>
     * </p>
     * 
     * @return <i>(Not supported by Neptune)</i>
     */
    public final Boolean supportsPerformanceInsights() {
        return supportsPerformanceInsights;
    }

    /**
     * <p>
     * Minimum storage size for a DB instance.
     * </p>
     * 
     * @return Minimum storage size for a DB instance.
     */
    public final Integer minStorageSize() {
        return minStorageSize;
    }

    /**
     * <p>
     * Maximum storage size for a DB instance.
     * </p>
     * 
     * @return Maximum storage size for a DB instance.
     */
    public final Integer maxStorageSize() {
        return maxStorageSize;
    }

    /**
     * <p>
     * Minimum total provisioned IOPS for a DB instance.
     * </p>
     * 
     * @return Minimum total provisioned IOPS for a DB instance.
     */
    public final Integer minIopsPerDbInstance() {
        return minIopsPerDbInstance;
    }

    /**
     * <p>
     * Maximum total provisioned IOPS for a DB instance.
     * </p>
     * 
     * @return Maximum total provisioned IOPS for a DB instance.
     */
    public final Integer maxIopsPerDbInstance() {
        return maxIopsPerDbInstance;
    }

    /**
     * <p>
     * Minimum provisioned IOPS per GiB for a DB instance.
     * </p>
     * 
     * @return Minimum provisioned IOPS per GiB for a DB instance.
     */
    public final Double minIopsPerGib() {
        return minIopsPerGib;
    }

    /**
     * <p>
     * Maximum provisioned IOPS per GiB for a DB instance.
     * </p>
     * 
     * @return Maximum provisioned IOPS per GiB for a DB instance.
     */
    public final Double maxIopsPerGib() {
        return maxIopsPerGib;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiAZCapable());
        hashCode = 31 * hashCode + Objects.hashCode(readReplicaCapable());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(supportsStorageEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(supportsIops());
        hashCode = 31 * hashCode + Objects.hashCode(supportsEnhancedMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(supportsIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(supportsPerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(minStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(minIopsPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(maxIopsPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(minIopsPerGib());
        hashCode = 31 * hashCode + Objects.hashCode(maxIopsPerGib());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(licenseModel(), other.licenseModel()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(multiAZCapable(), other.multiAZCapable())
                && Objects.equals(readReplicaCapable(), other.readReplicaCapable()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(supportsStorageEncryption(), other.supportsStorageEncryption())
                && Objects.equals(storageType(), other.storageType()) && Objects.equals(supportsIops(), other.supportsIops())
                && Objects.equals(supportsEnhancedMonitoring(), other.supportsEnhancedMonitoring())
                && Objects.equals(supportsIAMDatabaseAuthentication(), other.supportsIAMDatabaseAuthentication())
                && Objects.equals(supportsPerformanceInsights(), other.supportsPerformanceInsights())
                && Objects.equals(minStorageSize(), other.minStorageSize())
                && Objects.equals(maxStorageSize(), other.maxStorageSize())
                && Objects.equals(minIopsPerDbInstance(), other.minIopsPerDbInstance())
                && Objects.equals(maxIopsPerDbInstance(), other.maxIopsPerDbInstance())
                && Objects.equals(minIopsPerGib(), other.minIopsPerGib())
                && Objects.equals(maxIopsPerGib(), other.maxIopsPerGib());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrderableDBInstanceOption").add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("DBInstanceClass", dbInstanceClass()).add("LicenseModel", licenseModel())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("MultiAZCapable", multiAZCapable()).add("ReadReplicaCapable", readReplicaCapable()).add("Vpc", vpc())
                .add("SupportsStorageEncryption", supportsStorageEncryption()).add("StorageType", storageType())
                .add("SupportsIops", supportsIops()).add("SupportsEnhancedMonitoring", supportsEnhancedMonitoring())
                .add("SupportsIAMDatabaseAuthentication", supportsIAMDatabaseAuthentication())
                .add("SupportsPerformanceInsights", supportsPerformanceInsights()).add("MinStorageSize", minStorageSize())
                .add("MaxStorageSize", maxStorageSize()).add("MinIopsPerDbInstance", minIopsPerDbInstance())
                .add("MaxIopsPerDbInstance", maxIopsPerDbInstance()).add("MinIopsPerGib", minIopsPerGib())
                .add("MaxIopsPerGib", maxIopsPerGib()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "MultiAZCapable":
            return Optional.ofNullable(clazz.cast(multiAZCapable()));
        case "ReadReplicaCapable":
            return Optional.ofNullable(clazz.cast(readReplicaCapable()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "SupportsStorageEncryption":
            return Optional.ofNullable(clazz.cast(supportsStorageEncryption()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "SupportsIops":
            return Optional.ofNullable(clazz.cast(supportsIops()));
        case "SupportsEnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(supportsEnhancedMonitoring()));
        case "SupportsIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(supportsIAMDatabaseAuthentication()));
        case "SupportsPerformanceInsights":
            return Optional.ofNullable(clazz.cast(supportsPerformanceInsights()));
        case "MinStorageSize":
            return Optional.ofNullable(clazz.cast(minStorageSize()));
        case "MaxStorageSize":
            return Optional.ofNullable(clazz.cast(maxStorageSize()));
        case "MinIopsPerDbInstance":
            return Optional.ofNullable(clazz.cast(minIopsPerDbInstance()));
        case "MaxIopsPerDbInstance":
            return Optional.ofNullable(clazz.cast(maxIopsPerDbInstance()));
        case "MinIopsPerGib":
            return Optional.ofNullable(clazz.cast(minIopsPerGib()));
        case "MaxIopsPerGib":
            return Optional.ofNullable(clazz.cast(maxIopsPerGib()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrderableDBInstanceOption, T> g) {
        return obj -> g.apply((OrderableDBInstanceOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrderableDBInstanceOption> {
        /**
         * <p>
         * The engine type of a DB instance.
         * </p>
         * 
         * @param engine
         *        The engine type of a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine version of a DB instance.
         * </p>
         * 
         * @param engineVersion
         *        The engine version of a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The DB instance class for a DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        The DB instance class for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The license model for a DB instance.
         * </p>
         * 
         * @param licenseModel
         *        The license model for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * A list of Availability Zones for a DB instance.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones for a DB instance.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * A list of Availability Zones for a DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AvailabilityZone>.Builder} avoiding the
         * need to create one manually via {@link List<AvailabilityZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailabilityZone>.Builder#build()} is called immediately and
         * its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on {@link List<AvailabilityZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(List<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * Indicates whether a DB instance is Multi-AZ capable.
         * </p>
         * 
         * @param multiAZCapable
         *        Indicates whether a DB instance is Multi-AZ capable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZCapable(Boolean multiAZCapable);

        /**
         * <p>
         * Indicates whether a DB instance can have a Read Replica.
         * </p>
         * 
         * @param readReplicaCapable
         *        Indicates whether a DB instance can have a Read Replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaCapable(Boolean readReplicaCapable);

        /**
         * <p>
         * Indicates whether a DB instance is in a VPC.
         * </p>
         * 
         * @param vpc
         *        Indicates whether a DB instance is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(Boolean vpc);

        /**
         * <p>
         * Indicates whether a DB instance supports encrypted storage.
         * </p>
         * 
         * @param supportsStorageEncryption
         *        Indicates whether a DB instance supports encrypted storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsStorageEncryption(Boolean supportsStorageEncryption);

        /**
         * <p>
         * Indicates the storage type for a DB instance.
         * </p>
         * 
         * @param storageType
         *        Indicates the storage type for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * Indicates whether a DB instance supports provisioned IOPS.
         * </p>
         * 
         * @param supportsIops
         *        Indicates whether a DB instance supports provisioned IOPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsIops(Boolean supportsIops);

        /**
         * <p>
         * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
         * </p>
         * 
         * @param supportsEnhancedMonitoring
         *        Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring);

        /**
         * <p>
         * Indicates whether a DB instance supports IAM database authentication.
         * </p>
         * 
         * @param supportsIAMDatabaseAuthentication
         *        Indicates whether a DB instance supports IAM database authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication);

        /**
         * <p>
         * <i>(Not supported by Neptune)</i>
         * </p>
         * 
         * @param supportsPerformanceInsights
         *        <i>(Not supported by Neptune)</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsPerformanceInsights(Boolean supportsPerformanceInsights);

        /**
         * <p>
         * Minimum storage size for a DB instance.
         * </p>
         * 
         * @param minStorageSize
         *        Minimum storage size for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minStorageSize(Integer minStorageSize);

        /**
         * <p>
         * Maximum storage size for a DB instance.
         * </p>
         * 
         * @param maxStorageSize
         *        Maximum storage size for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxStorageSize(Integer maxStorageSize);

        /**
         * <p>
         * Minimum total provisioned IOPS for a DB instance.
         * </p>
         * 
         * @param minIopsPerDbInstance
         *        Minimum total provisioned IOPS for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIopsPerDbInstance(Integer minIopsPerDbInstance);

        /**
         * <p>
         * Maximum total provisioned IOPS for a DB instance.
         * </p>
         * 
         * @param maxIopsPerDbInstance
         *        Maximum total provisioned IOPS for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxIopsPerDbInstance(Integer maxIopsPerDbInstance);

        /**
         * <p>
         * Minimum provisioned IOPS per GiB for a DB instance.
         * </p>
         * 
         * @param minIopsPerGib
         *        Minimum provisioned IOPS per GiB for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIopsPerGib(Double minIopsPerGib);

        /**
         * <p>
         * Maximum provisioned IOPS per GiB for a DB instance.
         * </p>
         * 
         * @param maxIopsPerGib
         *        Maximum provisioned IOPS per GiB for a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxIopsPerGib(Double maxIopsPerGib);
    }

    static final class BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String dbInstanceClass;

        private String licenseModel;

        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiAZCapable;

        private Boolean readReplicaCapable;

        private Boolean vpc;

        private Boolean supportsStorageEncryption;

        private String storageType;

        private Boolean supportsIops;

        private Boolean supportsEnhancedMonitoring;

        private Boolean supportsIAMDatabaseAuthentication;

        private Boolean supportsPerformanceInsights;

        private Integer minStorageSize;

        private Integer maxStorageSize;

        private Integer minIopsPerDbInstance;

        private Integer maxIopsPerDbInstance;

        private Double minIopsPerGib;

        private Double maxIopsPerGib;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableDBInstanceOption model) {
            engine(model.engine);
            engineVersion(model.engineVersion);
            dbInstanceClass(model.dbInstanceClass);
            licenseModel(model.licenseModel);
            availabilityZones(model.availabilityZones);
            multiAZCapable(model.multiAZCapable);
            readReplicaCapable(model.readReplicaCapable);
            vpc(model.vpc);
            supportsStorageEncryption(model.supportsStorageEncryption);
            storageType(model.storageType);
            supportsIops(model.supportsIops);
            supportsEnhancedMonitoring(model.supportsEnhancedMonitoring);
            supportsIAMDatabaseAuthentication(model.supportsIAMDatabaseAuthentication);
            supportsPerformanceInsights(model.supportsPerformanceInsights);
            minStorageSize(model.minStorageSize);
            maxStorageSize(model.maxStorageSize);
            minIopsPerDbInstance(model.minIopsPerDbInstance);
            maxIopsPerDbInstance(model.maxIopsPerDbInstance);
            minIopsPerGib(model.minIopsPerGib);
            maxIopsPerGib(model.maxIopsPerGib);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        @Transient
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        @Transient
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZoneListCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiAZCapable() {
            return multiAZCapable;
        }

        public final void setMultiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
        }

        @Override
        @Transient
        public final Builder multiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
            return this;
        }

        public final Boolean getReadReplicaCapable() {
            return readReplicaCapable;
        }

        public final void setReadReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
        }

        @Override
        @Transient
        public final Builder readReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
            return this;
        }

        public final Boolean getVpc() {
            return vpc;
        }

        public final void setVpc(Boolean vpc) {
            this.vpc = vpc;
        }

        @Override
        @Transient
        public final Builder vpc(Boolean vpc) {
            this.vpc = vpc;
            return this;
        }

        public final Boolean getSupportsStorageEncryption() {
            return supportsStorageEncryption;
        }

        public final void setSupportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
        }

        @Override
        @Transient
        public final Builder supportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getSupportsIops() {
            return supportsIops;
        }

        public final void setSupportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
        }

        @Override
        @Transient
        public final Builder supportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
            return this;
        }

        public final Boolean getSupportsEnhancedMonitoring() {
            return supportsEnhancedMonitoring;
        }

        public final void setSupportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
        }

        @Override
        @Transient
        public final Builder supportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
            return this;
        }

        public final Boolean getSupportsIAMDatabaseAuthentication() {
            return supportsIAMDatabaseAuthentication;
        }

        public final void setSupportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
        }

        @Override
        @Transient
        public final Builder supportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
            return this;
        }

        public final Boolean getSupportsPerformanceInsights() {
            return supportsPerformanceInsights;
        }

        public final void setSupportsPerformanceInsights(Boolean supportsPerformanceInsights) {
            this.supportsPerformanceInsights = supportsPerformanceInsights;
        }

        @Override
        @Transient
        public final Builder supportsPerformanceInsights(Boolean supportsPerformanceInsights) {
            this.supportsPerformanceInsights = supportsPerformanceInsights;
            return this;
        }

        public final Integer getMinStorageSize() {
            return minStorageSize;
        }

        public final void setMinStorageSize(Integer minStorageSize) {
            this.minStorageSize = minStorageSize;
        }

        @Override
        @Transient
        public final Builder minStorageSize(Integer minStorageSize) {
            this.minStorageSize = minStorageSize;
            return this;
        }

        public final Integer getMaxStorageSize() {
            return maxStorageSize;
        }

        public final void setMaxStorageSize(Integer maxStorageSize) {
            this.maxStorageSize = maxStorageSize;
        }

        @Override
        @Transient
        public final Builder maxStorageSize(Integer maxStorageSize) {
            this.maxStorageSize = maxStorageSize;
            return this;
        }

        public final Integer getMinIopsPerDbInstance() {
            return minIopsPerDbInstance;
        }

        public final void setMinIopsPerDbInstance(Integer minIopsPerDbInstance) {
            this.minIopsPerDbInstance = minIopsPerDbInstance;
        }

        @Override
        @Transient
        public final Builder minIopsPerDbInstance(Integer minIopsPerDbInstance) {
            this.minIopsPerDbInstance = minIopsPerDbInstance;
            return this;
        }

        public final Integer getMaxIopsPerDbInstance() {
            return maxIopsPerDbInstance;
        }

        public final void setMaxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
            this.maxIopsPerDbInstance = maxIopsPerDbInstance;
        }

        @Override
        @Transient
        public final Builder maxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
            this.maxIopsPerDbInstance = maxIopsPerDbInstance;
            return this;
        }

        public final Double getMinIopsPerGib() {
            return minIopsPerGib;
        }

        public final void setMinIopsPerGib(Double minIopsPerGib) {
            this.minIopsPerGib = minIopsPerGib;
        }

        @Override
        @Transient
        public final Builder minIopsPerGib(Double minIopsPerGib) {
            this.minIopsPerGib = minIopsPerGib;
            return this;
        }

        public final Double getMaxIopsPerGib() {
            return maxIopsPerGib;
        }

        public final void setMaxIopsPerGib(Double maxIopsPerGib) {
            this.maxIopsPerGib = maxIopsPerGib;
        }

        @Override
        @Transient
        public final Builder maxIopsPerGib(Double maxIopsPerGib) {
            this.maxIopsPerGib = maxIopsPerGib;
            return this;
        }

        @Override
        public OrderableDBInstanceOption build() {
            return new OrderableDBInstanceOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
