/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyPendingMaintenanceActionResponse extends NeptuneResponse implements
        ToCopyableBuilder<ApplyPendingMaintenanceActionResponse.Builder, ApplyPendingMaintenanceActionResponse> {
    private static final SdkField<ResourcePendingMaintenanceActions> RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField
            .<ResourcePendingMaintenanceActions> builder(MarshallingType.SDK_POJO)
            .memberName("ResourcePendingMaintenanceActions")
            .getter(getter(ApplyPendingMaintenanceActionResponse::resourcePendingMaintenanceActions))
            .setter(setter(Builder::resourcePendingMaintenanceActions))
            .constructor(ResourcePendingMaintenanceActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePendingMaintenanceActions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD));

    private final ResourcePendingMaintenanceActions resourcePendingMaintenanceActions;

    private ApplyPendingMaintenanceActionResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePendingMaintenanceActions = builder.resourcePendingMaintenanceActions;
    }

    /**
     * Returns the value of the ResourcePendingMaintenanceActions property for this object.
     * 
     * @return The value of the ResourcePendingMaintenanceActions property for this object.
     */
    public final ResourcePendingMaintenanceActions resourcePendingMaintenanceActions() {
        return resourcePendingMaintenanceActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourcePendingMaintenanceActions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyPendingMaintenanceActionResponse)) {
            return false;
        }
        ApplyPendingMaintenanceActionResponse other = (ApplyPendingMaintenanceActionResponse) obj;
        return Objects.equals(resourcePendingMaintenanceActions(), other.resourcePendingMaintenanceActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplyPendingMaintenanceActionResponse")
                .add("ResourcePendingMaintenanceActions", resourcePendingMaintenanceActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourcePendingMaintenanceActions":
            return Optional.ofNullable(clazz.cast(resourcePendingMaintenanceActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyPendingMaintenanceActionResponse, T> g) {
        return obj -> g.apply((ApplyPendingMaintenanceActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ApplyPendingMaintenanceActionResponse> {
        /**
         * Sets the value of the ResourcePendingMaintenanceActions property for this object.
         *
         * @param resourcePendingMaintenanceActions
         *        The new value for the ResourcePendingMaintenanceActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePendingMaintenanceActions(ResourcePendingMaintenanceActions resourcePendingMaintenanceActions);

        /**
         * Sets the value of the ResourcePendingMaintenanceActions property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourcePendingMaintenanceActions.Builder}
         * avoiding the need to create one manually via {@link ResourcePendingMaintenanceActions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourcePendingMaintenanceActions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #resourcePendingMaintenanceActions(ResourcePendingMaintenanceActions)}.
         * 
         * @param resourcePendingMaintenanceActions
         *        a consumer that will call methods on {@link ResourcePendingMaintenanceActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePendingMaintenanceActions(ResourcePendingMaintenanceActions)
         */
        default Builder resourcePendingMaintenanceActions(
                Consumer<ResourcePendingMaintenanceActions.Builder> resourcePendingMaintenanceActions) {
            return resourcePendingMaintenanceActions(ResourcePendingMaintenanceActions.builder()
                    .applyMutation(resourcePendingMaintenanceActions).build());
        }
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private ResourcePendingMaintenanceActions resourcePendingMaintenanceActions;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyPendingMaintenanceActionResponse model) {
            super(model);
            resourcePendingMaintenanceActions(model.resourcePendingMaintenanceActions);
        }

        public final ResourcePendingMaintenanceActions.Builder getResourcePendingMaintenanceActions() {
            return resourcePendingMaintenanceActions != null ? resourcePendingMaintenanceActions.toBuilder() : null;
        }

        public final void setResourcePendingMaintenanceActions(
                ResourcePendingMaintenanceActions.BuilderImpl resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions = resourcePendingMaintenanceActions != null ? resourcePendingMaintenanceActions
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder resourcePendingMaintenanceActions(ResourcePendingMaintenanceActions resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions = resourcePendingMaintenanceActions;
            return this;
        }

        @Override
        public ApplyPendingMaintenanceActionResponse build() {
            return new ApplyPendingMaintenanceActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
