/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDbClusterParameterGroupResponse extends NeptuneResponse implements
        ToCopyableBuilder<CopyDbClusterParameterGroupResponse.Builder, CopyDbClusterParameterGroupResponse> {
    private static final SdkField<DBClusterParameterGroup> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField
            .<DBClusterParameterGroup> builder(MarshallingType.SDK_POJO).memberName("DBClusterParameterGroup")
            .getter(getter(CopyDbClusterParameterGroupResponse::dbClusterParameterGroup))
            .setter(setter(Builder::dbClusterParameterGroup)).constructor(DBClusterParameterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_CLUSTER_PARAMETER_GROUP_FIELD));

    private final DBClusterParameterGroup dbClusterParameterGroup;

    private CopyDbClusterParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
    }

    /**
     * Returns the value of the DBClusterParameterGroup property for this object.
     * 
     * @return The value of the DBClusterParameterGroup property for this object.
     */
    public final DBClusterParameterGroup dbClusterParameterGroup() {
        return dbClusterParameterGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbClusterParameterGroupResponse)) {
            return false;
        }
        CopyDbClusterParameterGroupResponse other = (CopyDbClusterParameterGroupResponse) obj;
        return Objects.equals(dbClusterParameterGroup(), other.dbClusterParameterGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyDbClusterParameterGroupResponse").add("DBClusterParameterGroup", dbClusterParameterGroup())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterParameterGroup":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbClusterParameterGroupResponse, T> g) {
        return obj -> g.apply((CopyDbClusterParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CopyDbClusterParameterGroupResponse> {
        /**
         * Sets the value of the DBClusterParameterGroup property for this object.
         *
         * @param dbClusterParameterGroup
         *        The new value for the DBClusterParameterGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroup(DBClusterParameterGroup dbClusterParameterGroup);

        /**
         * Sets the value of the DBClusterParameterGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBClusterParameterGroup.Builder} avoiding the
         * need to create one manually via {@link DBClusterParameterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBClusterParameterGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #dbClusterParameterGroup(DBClusterParameterGroup)}.
         * 
         * @param dbClusterParameterGroup
         *        a consumer that will call methods on {@link DBClusterParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterParameterGroup(DBClusterParameterGroup)
         */
        default Builder dbClusterParameterGroup(Consumer<DBClusterParameterGroup.Builder> dbClusterParameterGroup) {
            return dbClusterParameterGroup(DBClusterParameterGroup.builder().applyMutation(dbClusterParameterGroup).build());
        }
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private DBClusterParameterGroup dbClusterParameterGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbClusterParameterGroupResponse model) {
            super(model);
            dbClusterParameterGroup(model.dbClusterParameterGroup);
        }

        public final DBClusterParameterGroup.Builder getDbClusterParameterGroup() {
            return dbClusterParameterGroup != null ? dbClusterParameterGroup.toBuilder() : null;
        }

        public final void setDbClusterParameterGroup(DBClusterParameterGroup.BuilderImpl dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup != null ? dbClusterParameterGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder dbClusterParameterGroup(DBClusterParameterGroup dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        @Override
        public CopyDbClusterParameterGroupResponse build() {
            return new CopyDbClusterParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
