/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbParameterGroupRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyDbParameterGroupRequest.Builder, ModifyDbParameterGroupRequest> {
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(ModifyDbParameterGroupRequest::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ModifyDbParameterGroupRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Parameter")
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Parameter").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PARAMETER_GROUP_NAME_FIELD,
            PARAMETERS_FIELD));

    private final String dbParameterGroupName;

    private final List<Parameter> parameters;

    private ModifyDbParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The name of the DB parameter group.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the name of an existing DBParameterGroup.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB parameter group.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the name of an existing DBParameterGroup.
     *         </p>
     *         </li>
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameter names, values, and the apply method for the parameter update. At least one parameter name,
     * value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be
     * modified in a single request.
     * </p>
     * <p>
     * Valid Values (for the application method): <code>immediate | pending-reboot</code>
     * </p>
     * <note>
     * <p>
     * You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both
     * dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return An array of parameter names, values, and the apply method for the parameter update. At least one
     *         parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of
     *         20 parameters can be modified in a single request.</p>
     *         <p>
     *         Valid Values (for the application method): <code>immediate | pending-reboot</code>
     *         </p>
     *         <note>
     *         <p>
     *         You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for
     *         both dynamic and static parameters, and changes are applied when you reboot the DB instance without
     *         failover.
     *         </p>
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbParameterGroupRequest)) {
            return false;
        }
        ModifyDbParameterGroupRequest other = (ModifyDbParameterGroupRequest) obj;
        return Objects.equals(dbParameterGroupName(), other.dbParameterGroupName()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbParameterGroupRequest").add("DBParameterGroupName", dbParameterGroupName())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbParameterGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbParameterGroupRequest> {
        /**
         * <p>
         * The name of the DB parameter group.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the name of an existing DBParameterGroup.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the name of an existing DBParameterGroup.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * An array of parameter names, values, and the apply method for the parameter update. At least one parameter
         * name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters
         * can be modified in a single request.
         * </p>
         * <p>
         * Valid Values (for the application method): <code>immediate | pending-reboot</code>
         * </p>
         * <note>
         * <p>
         * You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both
         * dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.
         * </p>
         * </note>
         * 
         * @param parameters
         *        An array of parameter names, values, and the apply method for the parameter update. At least one
         *        parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum
         *        of 20 parameters can be modified in a single request.</p>
         *        <p>
         *        Valid Values (for the application method): <code>immediate | pending-reboot</code>
         *        </p>
         *        <note>
         *        <p>
         *        You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for
         *        both dynamic and static parameters, and changes are applied when you reboot the DB instance without
         *        failover.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * An array of parameter names, values, and the apply method for the parameter update. At least one parameter
         * name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters
         * can be modified in a single request.
         * </p>
         * <p>
         * Valid Values (for the application method): <code>immediate | pending-reboot</code>
         * </p>
         * <note>
         * <p>
         * You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both
         * dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.
         * </p>
         * </note>
         * 
         * @param parameters
         *        An array of parameter names, values, and the apply method for the parameter update. At least one
         *        parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum
         *        of 20 parameters can be modified in a single request.</p>
         *        <p>
         *        Valid Values (for the application method): <code>immediate | pending-reboot</code>
         *        </p>
         *        <note>
         *        <p>
         *        You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for
         *        both dynamic and static parameters, and changes are applied when you reboot the DB instance without
         *        failover.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * An array of parameter names, values, and the apply method for the parameter update. At least one parameter
         * name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters
         * can be modified in a single request.
         * </p>
         * <p>
         * Valid Values (for the application method): <code>immediate | pending-reboot</code>
         * </p>
         * <note>
         * <p>
         * You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both
         * dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the
         * need to create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbParameterGroupName;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbParameterGroupRequest model) {
            super(model);
            dbParameterGroupName(model.dbParameterGroupName);
            parameters(model.parameters);
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        @Transient
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbParameterGroupRequest build() {
            return new ModifyDbParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
