/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <code>ModifyDBCluster</code> operation and contains changes that
 * will be applied during the next maintenance window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterPendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterPendingModifiedValues.Builder, ClusterPendingModifiedValues> {
    private static final SdkField<PendingCloudwatchLogsExports> PENDING_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<PendingCloudwatchLogsExports> builder(MarshallingType.SDK_POJO)
            .memberName("PendingCloudwatchLogsExports")
            .getter(getter(ClusterPendingModifiedValues::pendingCloudwatchLogsExports))
            .setter(setter(Builder::pendingCloudwatchLogsExports))
            .constructor(PendingCloudwatchLogsExports::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingCloudwatchLogsExports")
                    .build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(ClusterPendingModifiedValues::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IAMDatabaseAuthenticationEnabled")
            .getter(getter(ClusterPendingModifiedValues::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ClusterPendingModifiedValues::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(ClusterPendingModifiedValues::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(ClusterPendingModifiedValues::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(ClusterPendingModifiedValues::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(ClusterPendingModifiedValues::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PENDING_CLOUDWATCH_LOGS_EXPORTS_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD,
            ENGINE_VERSION_FIELD, BACKUP_RETENTION_PERIOD_FIELD, STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, IOPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PendingCloudwatchLogsExports pendingCloudwatchLogsExports;

    private final String dbClusterIdentifier;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final String engineVersion;

    private final Integer backupRetentionPeriod;

    private final String storageType;

    private final Integer allocatedStorage;

    private final Integer iops;

    private ClusterPendingModifiedValues(BuilderImpl builder) {
        this.pendingCloudwatchLogsExports = builder.pendingCloudwatchLogsExports;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.engineVersion = builder.engineVersion;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.storageType = builder.storageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.iops = builder.iops;
    }

    /**
     * <p>
     * This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs are
     * enabled and which are disabled.
     * </p>
     * 
     * @return This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch
     *         logs are enabled and which are disabled.
     */
    public final PendingCloudwatchLogsExports pendingCloudwatchLogsExports() {
        return pendingCloudwatchLogsExports;
    }

    /**
     * <p>
     * The DBClusterIdentifier value for the DB cluster.
     * </p>
     * 
     * @return The DBClusterIdentifier value for the DB cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts is enabled.
     * </p>
     * 
     * @return A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM)
     *         accounts to database accounts is enabled.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * The database engine version.
     * </p>
     * 
     * @return The database engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The number of days for which automatic DB snapshots are retained.
     * </p>
     * 
     * @return The number of days for which automatic DB snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The storage type for the DB cluster.
     * </p>
     * 
     * @return The storage type for the DB cluster.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The allocated storage size in gibibytes (GiB) for database engines. For Neptune, <code>AllocatedStorage</code>
     * always returns 1, because Neptune DB cluster storage size isn't fixed, but instead automatically adjusts as
     * needed.
     * </p>
     * 
     * @return The allocated storage size in gibibytes (GiB) for database engines. For Neptune,
     *         <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size isn't fixed, but
     *         instead automatically adjusts as needed.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.
     * </p>
     * 
     * @return The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB
     *         clusters.
     */
    public final Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pendingCloudwatchLogsExports());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterPendingModifiedValues)) {
            return false;
        }
        ClusterPendingModifiedValues other = (ClusterPendingModifiedValues) obj;
        return Objects.equals(pendingCloudwatchLogsExports(), other.pendingCloudwatchLogsExports())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(allocatedStorage(), other.allocatedStorage()) && Objects.equals(iops(), other.iops());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterPendingModifiedValues")
                .add("PendingCloudwatchLogsExports", pendingCloudwatchLogsExports())
                .add("DBClusterIdentifier", dbClusterIdentifier())
                .add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("EngineVersion", engineVersion()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("StorageType", storageType()).add("AllocatedStorage", allocatedStorage()).add("Iops", iops()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PendingCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(pendingCloudwatchLogsExports()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterPendingModifiedValues, T> g) {
        return obj -> g.apply((ClusterPendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterPendingModifiedValues> {
        /**
         * <p>
         * This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs
         * are enabled and which are disabled.
         * </p>
         * 
         * @param pendingCloudwatchLogsExports
         *        This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch
         *        logs are enabled and which are disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingCloudwatchLogsExports(PendingCloudwatchLogsExports pendingCloudwatchLogsExports);

        /**
         * <p>
         * This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs
         * are enabled and which are disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link PendingCloudwatchLogsExports.Builder}
         * avoiding the need to create one manually via {@link PendingCloudwatchLogsExports#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PendingCloudwatchLogsExports.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingCloudwatchLogsExports(PendingCloudwatchLogsExports)}.
         * 
         * @param pendingCloudwatchLogsExports
         *        a consumer that will call methods on {@link PendingCloudwatchLogsExports.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingCloudwatchLogsExports(PendingCloudwatchLogsExports)
         */
        default Builder pendingCloudwatchLogsExports(Consumer<PendingCloudwatchLogsExports.Builder> pendingCloudwatchLogsExports) {
            return pendingCloudwatchLogsExports(PendingCloudwatchLogsExports.builder()
                    .applyMutation(pendingCloudwatchLogsExports).build());
        }

        /**
         * <p>
         * The DBClusterIdentifier value for the DB cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DBClusterIdentifier value for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts
         * to database accounts is enabled.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * The database engine version.
         * </p>
         * 
         * @param engineVersion
         *        The database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The number of days for which automatic DB snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automatic DB snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The storage type for the DB cluster.
         * </p>
         * 
         * @param storageType
         *        The storage type for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The allocated storage size in gibibytes (GiB) for database engines. For Neptune,
         * <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size isn't fixed, but
         * instead automatically adjusts as needed.
         * </p>
         * 
         * @param allocatedStorage
         *        The allocated storage size in gibibytes (GiB) for database engines. For Neptune,
         *        <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size isn't fixed,
         *        but instead automatically adjusts as needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB
         * clusters.
         * </p>
         * 
         * @param iops
         *        The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ
         *        DB clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);
    }

    static final class BuilderImpl implements Builder {
        private PendingCloudwatchLogsExports pendingCloudwatchLogsExports;

        private String dbClusterIdentifier;

        private Boolean iamDatabaseAuthenticationEnabled;

        private String engineVersion;

        private Integer backupRetentionPeriod;

        private String storageType;

        private Integer allocatedStorage;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterPendingModifiedValues model) {
            pendingCloudwatchLogsExports(model.pendingCloudwatchLogsExports);
            dbClusterIdentifier(model.dbClusterIdentifier);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            engineVersion(model.engineVersion);
            backupRetentionPeriod(model.backupRetentionPeriod);
            storageType(model.storageType);
            allocatedStorage(model.allocatedStorage);
            iops(model.iops);
        }

        public final PendingCloudwatchLogsExports.Builder getPendingCloudwatchLogsExports() {
            return pendingCloudwatchLogsExports != null ? pendingCloudwatchLogsExports.toBuilder() : null;
        }

        public final void setPendingCloudwatchLogsExports(PendingCloudwatchLogsExports.BuilderImpl pendingCloudwatchLogsExports) {
            this.pendingCloudwatchLogsExports = pendingCloudwatchLogsExports != null ? pendingCloudwatchLogsExports.build()
                    : null;
        }

        @Override
        public final Builder pendingCloudwatchLogsExports(PendingCloudwatchLogsExports pendingCloudwatchLogsExports) {
            this.pendingCloudwatchLogsExports = pendingCloudwatchLogsExports;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        @Override
        public ClusterPendingModifiedValues build() {
            return new ClusterPendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
