/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDbClusterParameterGroupRequest extends NeptuneRequest implements
        ToCopyableBuilder<CopyDbClusterParameterGroupRequest.Builder, CopyDbClusterParameterGroupRequest> {
    private static final SdkField<String> SOURCE_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterParameterGroupRequest::sourceDBClusterParameterGroupIdentifier))
            .setter(setter(Builder::sourceDBClusterParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SourceDBClusterParameterGroupIdentifier").build()).build();

    private static final SdkField<String> TARGET_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterParameterGroupRequest::targetDBClusterParameterGroupIdentifier))
            .setter(setter(Builder::targetDBClusterParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TargetDBClusterParameterGroupIdentifier").build()).build();

    private static final SdkField<String> TARGET_DB_CLUSTER_PARAMETER_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterParameterGroupRequest::targetDBClusterParameterGroupDescription))
            .setter(setter(Builder::targetDBClusterParameterGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TargetDBClusterParameterGroupDescription").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CopyDbClusterParameterGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD,
            TARGET_DB_CLUSTER_PARAMETER_GROUP_DESCRIPTION_FIELD, TAGS_FIELD));

    private final String sourceDBClusterParameterGroupIdentifier;

    private final String targetDBClusterParameterGroupIdentifier;

    private final String targetDBClusterParameterGroupDescription;

    private final List<Tag> tags;

    private CopyDbClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterParameterGroupIdentifier = builder.sourceDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupIdentifier = builder.targetDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupDescription = builder.targetDBClusterParameterGroupDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about
     * creating an ARN, see <a
     * href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
     * Constructing an Amazon Resource Name (ARN)</a>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must specify a valid DB cluster parameter group.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source DB cluster parameter group is in the same AWS Region as the copy, specify a valid DB parameter
     * group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source DB parameter group is in a different AWS Region than the copy, specify a valid DB cluster parameter
     * group ARN, for example <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information
     *         about creating an ARN, see <a
     *         href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
     *         Constructing an Amazon Resource Name (ARN)</a>. </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must specify a valid DB cluster parameter group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source DB cluster parameter group is in the same AWS Region as the copy, specify a valid DB
     *         parameter group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source DB parameter group is in a different AWS Region than the copy, specify a valid DB cluster
     *         parameter group ARN, for example
     *         <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.
     *         </p>
     *         </li>
     */
    public String sourceDBClusterParameterGroupIdentifier() {
        return sourceDBClusterParameterGroupIdentifier;
    }

    /**
     * <p>
     * The identifier for the copied DB cluster parameter group.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cannot be null, empty, or blank
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 255 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster-param-group1</code>
     * </p>
     * 
     * @return The identifier for the copied DB cluster parameter group.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot be null, empty, or blank
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster-param-group1</code>
     */
    public String targetDBClusterParameterGroupIdentifier() {
        return targetDBClusterParameterGroupIdentifier;
    }

    /**
     * <p>
     * A description for the copied DB cluster parameter group.
     * </p>
     * 
     * @return A description for the copied DB cluster parameter group.
     */
    public String targetDBClusterParameterGroupDescription() {
        return targetDBClusterParameterGroupDescription;
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBClusterParameterGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbClusterParameterGroupRequest)) {
            return false;
        }
        CopyDbClusterParameterGroupRequest other = (CopyDbClusterParameterGroupRequest) obj;
        return Objects.equals(sourceDBClusterParameterGroupIdentifier(), other.sourceDBClusterParameterGroupIdentifier())
                && Objects.equals(targetDBClusterParameterGroupIdentifier(), other.targetDBClusterParameterGroupIdentifier())
                && Objects.equals(targetDBClusterParameterGroupDescription(), other.targetDBClusterParameterGroupDescription())
                && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("CopyDbClusterParameterGroupRequest")
                .add("SourceDBClusterParameterGroupIdentifier", sourceDBClusterParameterGroupIdentifier())
                .add("TargetDBClusterParameterGroupIdentifier", targetDBClusterParameterGroupIdentifier())
                .add("TargetDBClusterParameterGroupDescription", targetDBClusterParameterGroupDescription()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDBClusterParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterParameterGroupIdentifier()));
        case "TargetDBClusterParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(targetDBClusterParameterGroupIdentifier()));
        case "TargetDBClusterParameterGroupDescription":
            return Optional.ofNullable(clazz.cast(targetDBClusterParameterGroupDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbClusterParameterGroupRequest, T> g) {
        return obj -> g.apply((CopyDbClusterParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CopyDbClusterParameterGroupRequest> {
        /**
         * <p>
         * The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about
         * creating an ARN, see <a
         * href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
         * Constructing an Amazon Resource Name (ARN)</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must specify a valid DB cluster parameter group.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the source DB cluster parameter group is in the same AWS Region as the copy, specify a valid DB parameter
         * group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the source DB parameter group is in a different AWS Region than the copy, specify a valid DB cluster
         * parameter group ARN, for example
         * <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBClusterParameterGroupIdentifier
         *        The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For
         *        information about creating an ARN, see <a
         *        href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
         *        Constructing an Amazon Resource Name (ARN)</a>. </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must specify a valid DB cluster parameter group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the source DB cluster parameter group is in the same AWS Region as the copy, specify a valid DB
         *        parameter group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the source DB parameter group is in a different AWS Region than the copy, specify a valid DB
         *        cluster parameter group ARN, for example
         *        <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier);

        /**
         * <p>
         * The identifier for the copied DB cluster parameter group.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cannot be null, empty, or blank
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 255 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster-param-group1</code>
         * </p>
         * 
         * @param targetDBClusterParameterGroupIdentifier
         *        The identifier for the copied DB cluster parameter group.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cannot be null, empty, or blank
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster-param-group1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier);

        /**
         * <p>
         * A description for the copied DB cluster parameter group.
         * </p>
         * 
         * @param targetDBClusterParameterGroupDescription
         *        A description for the copied DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String sourceDBClusterParameterGroupIdentifier;

        private String targetDBClusterParameterGroupIdentifier;

        private String targetDBClusterParameterGroupDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbClusterParameterGroupRequest model) {
            super(model);
            sourceDBClusterParameterGroupIdentifier(model.sourceDBClusterParameterGroupIdentifier);
            targetDBClusterParameterGroupIdentifier(model.targetDBClusterParameterGroupIdentifier);
            targetDBClusterParameterGroupDescription(model.targetDBClusterParameterGroupDescription);
            tags(model.tags);
        }

        public final String getSourceDBClusterParameterGroupIdentifier() {
            return sourceDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setSourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupIdentifier() {
            return targetDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setTargetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupDescription() {
            return targetDBClusterParameterGroupDescription;
        }

        @Override
        public final Builder targetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
            return this;
        }

        public final void setTargetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbClusterParameterGroupRequest build() {
            return new CopyDbClusterParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
