/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbClusterRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyDbClusterRequest.Builder, ModifyDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::dbClusterIdentifier)).setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> NEW_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::newDBClusterIdentifier)).setter(setter(Builder::newDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyDbClusterRequest::backupRetentionPeriod)).setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyDbClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyDbClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::masterUserPassword)).setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::optionGroupName)).setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::preferredBackupWindow)).setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            NEW_DB_CLUSTER_IDENTIFIER_FIELD, APPLY_IMMEDIATELY_FIELD, BACKUP_RETENTION_PERIOD_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PORT_FIELD, MASTER_USER_PASSWORD_FIELD,
            OPTION_GROUP_NAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, ENGINE_VERSION_FIELD));

    private final String dbClusterIdentifier;

    private final String newDBClusterIdentifier;

    private final Boolean applyImmediately;

    private final Integer backupRetentionPeriod;

    private final String dbClusterParameterGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final Integer port;

    private final String masterUserPassword;

    private final String optionGroupName;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean enableIAMDatabaseAuthentication;

    private final String engineVersion;

    private ModifyDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.newDBClusterIdentifier = builder.newDBClusterIdentifier;
        this.applyImmediately = builder.applyImmediately;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.port = builder.port;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.engineVersion = builder.engineVersion;
    }

    /**
     * <p>
     * The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBCluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBCluster.
     *         </p>
     *         </li>
     */
    public String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase
     * string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster2</code>
     * </p>
     * 
     * @return The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
     *         lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster2</code>
     */
    public String newDBClusterIdentifier() {
        return newDBClusterIdentifier;
    }

    /**
     * <p>
     * A value that specifies whether the modifications in this request and any pending modifications are asynchronously
     * applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB
     * cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are applied during the next
     * maintenance window.
     * </p>
     * <p>
     * The <code>ApplyImmediately</code> parameter only affects the <code>NewDBClusterIdentifier</code> and
     * <code>MasterUserPassword</code> values. If you set the <code>ApplyImmediately</code> parameter value to false,
     * then changes to the <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are applied
     * during the next maintenance window. All other changes are applied immediately, regardless of the value of the
     * <code>ApplyImmediately</code> parameter.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A value that specifies whether the modifications in this request and any pending modifications are
     *         asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
     *         setting for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are
     *         applied during the next maintenance window.</p>
     *         <p>
     *         The <code>ApplyImmediately</code> parameter only affects the <code>NewDBClusterIdentifier</code> and
     *         <code>MasterUserPassword</code> values. If you set the <code>ApplyImmediately</code> parameter value to
     *         false, then changes to the <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values
     *         are applied during the next maintenance window. All other changes are applied immediately, regardless of
     *         the value of the <code>ApplyImmediately</code> parameter.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained. You must specify a minimum value of 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 1 to 35
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 1 to 35
     *         </p>
     *         </li>
     */
    public Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to use for the DB cluster.
     * </p>
     * 
     * @return The name of the DB cluster parameter group to use for the DB cluster.
     */
    public String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * A list of VPC security groups that the DB cluster will belong to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of VPC security groups that the DB cluster will belong to.
     */
    public List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The port number on which the DB cluster accepts connections.
     * </p>
     * <p>
     * Constraints: Value must be <code>1150-65535</code>
     * </p>
     * <p>
     * Default: The same port as the original DB cluster.
     * </p>
     * 
     * @return The port number on which the DB cluster accepts connections.</p>
     *         <p>
     *         Constraints: Value must be <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: The same port as the original DB cluster.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The new password for the master database user. This password can contain any printable ASCII character except
     * "/", """, or "@".
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * 
     * @return The new password for the master database user. This password can contain any printable ASCII character
     *         except "/", """, or "@".</p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     */
    public String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * A value that indicates that the DB cluster should be associated with the specified option group. Changing this
     * parameter doesn't result in an outage except in the following case, and the change is applied during the next
     * maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this
     * request. If the parameter change results in an option group that enables OEM, this change can cause a brief
     * (sub-second) period during which new connections are rejected but existing connections are not interrupted.
     * </p>
     * <p>
     * Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once
     * it is associated with a DB cluster.
     * </p>
     * 
     * @return A value that indicates that the DB cluster should be associated with the specified option group. Changing
     *         this parameter doesn't result in an outage except in the following case, and the change is applied during
     *         the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to
     *         <code>true</code> for this request. If the parameter change results in an option group that enables OEM,
     *         this change can cause a brief (sub-second) period during which new connections are rejected but existing
     *         connections are not interrupted. </p>
     *         <p>
     *         Permanent options can't be removed from an option group. The option group can't be removed from a DB
     *         cluster once it is associated with a DB cluster.
     */
    public String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, using the
     * <code>BackupRetentionPeriod</code> parameter.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, using
     *         the <code>BackupRetentionPeriod</code> parameter. </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * <p>
     * Constraints: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         <p>
     *         Constraints: Minimum 30-minute window.
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and otherwise
     * false.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
     *         otherwise false.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
     * outage. The change is applied during the next maintenance window unless the ApplyImmediately parameter is set to
     * true.
     * </p>
     * <p>
     * For a list of valid engine versions, see <a>CreateDBInstance</a>, or call <a>DescribeDBEngineVersions</a>.
     * </p>
     * 
     * @return The version number of the database engine to which you want to upgrade. Changing this parameter results
     *         in an outage. The change is applied during the next maintenance window unless the ApplyImmediately
     *         parameter is set to true.</p>
     *         <p>
     *         For a list of valid engine versions, see <a>CreateDBInstance</a>, or call
     *         <a>DescribeDBEngineVersions</a>.
     */
    public String engineVersion() {
        return engineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterRequest)) {
            return false;
        }
        ModifyDbClusterRequest other = (ModifyDbClusterRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(newDBClusterIdentifier(), other.newDBClusterIdentifier())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(engineVersion(), other.engineVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyDbClusterRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("NewDBClusterIdentifier", newDBClusterIdentifier()).add("ApplyImmediately", applyImmediately())
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("VpcSecurityGroupIds", vpcSecurityGroupIds()).add("Port", port())
                .add("MasterUserPassword", masterUserPassword()).add("OptionGroupName", optionGroupName())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication()).add("EngineVersion", engineVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "NewDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(newDBClusterIdentifier()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbClusterRequest> {
        /**
         * <p>
         * The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBCluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBCluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
         * lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster2</code>
         * </p>
         * 
         * @param newDBClusterIdentifier
         *        The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
         *        lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBClusterIdentifier(String newDBClusterIdentifier);

        /**
         * <p>
         * A value that specifies whether the modifications in this request and any pending modifications are
         * asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting
         * for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are applied
         * during the next maintenance window.
         * </p>
         * <p>
         * The <code>ApplyImmediately</code> parameter only affects the <code>NewDBClusterIdentifier</code> and
         * <code>MasterUserPassword</code> values. If you set the <code>ApplyImmediately</code> parameter value to
         * false, then changes to the <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
         * applied during the next maintenance window. All other changes are applied immediately, regardless of the
         * value of the <code>ApplyImmediately</code> parameter.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        A value that specifies whether the modifications in this request and any pending modifications are
         *        asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
         *        setting for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster
         *        are applied during the next maintenance window.</p>
         *        <p>
         *        The <code>ApplyImmediately</code> parameter only affects the <code>NewDBClusterIdentifier</code> and
         *        <code>MasterUserPassword</code> values. If you set the <code>ApplyImmediately</code> parameter value
         *        to false, then changes to the <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code>
         *        values are applied during the next maintenance window. All other changes are applied immediately,
         *        regardless of the value of the <code>ApplyImmediately</code> parameter.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The number of days for which automated backups are retained. You must specify a minimum value of 1.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 1 to 35
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained. You must specify a minimum value of
         *        1.</p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 1 to 35
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The name of the DB cluster parameter group to use for the DB cluster.
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to use for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the DB cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the DB cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The port number on which the DB cluster accepts connections.
         * </p>
         * <p>
         * Constraints: Value must be <code>1150-65535</code>
         * </p>
         * <p>
         * Default: The same port as the original DB cluster.
         * </p>
         * 
         * @param port
         *        The port number on which the DB cluster accepts connections.</p>
         *        <p>
         *        Constraints: Value must be <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: The same port as the original DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The new password for the master database user. This password can contain any printable ASCII character except
         * "/", """, or "@".
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The new password for the master database user. This password can contain any printable ASCII character
         *        except "/", """, or "@".</p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * A value that indicates that the DB cluster should be associated with the specified option group. Changing
         * this parameter doesn't result in an outage except in the following case, and the change is applied during the
         * next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for
         * this request. If the parameter change results in an option group that enables OEM, this change can cause a
         * brief (sub-second) period during which new connections are rejected but existing connections are not
         * interrupted.
         * </p>
         * <p>
         * Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster
         * once it is associated with a DB cluster.
         * </p>
         * 
         * @param optionGroupName
         *        A value that indicates that the DB cluster should be associated with the specified option group.
         *        Changing this parameter doesn't result in an outage except in the following case, and the change is
         *        applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set
         *        to <code>true</code> for this request. If the parameter change results in an option group that enables
         *        OEM, this change can cause a brief (sub-second) period during which new connections are rejected but
         *        existing connections are not interrupted. </p>
         *        <p>
         *        Permanent options can't be removed from an option group. The option group can't be removed from a DB
         *        cluster once it is associated with a DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, using the
         * <code>BackupRetentionPeriod</code> parameter.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled,
         *        using the <code>BackupRetentionPeriod</code> parameter. </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         * occurring on a random day of the week.
         * </p>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * <p>
         * Constraints: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         *        occurring on a random day of the week.
         *        </p>
         *        <p>
         *        Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        <p>
         *        Constraints: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
         * otherwise false.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        True to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts, and
         *        otherwise false.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
         * outage. The change is applied during the next maintenance window unless the ApplyImmediately parameter is set
         * to true.
         * </p>
         * <p>
         * For a list of valid engine versions, see <a>CreateDBInstance</a>, or call <a>DescribeDBEngineVersions</a>.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to which you want to upgrade. Changing this parameter
         *        results in an outage. The change is applied during the next maintenance window unless the
         *        ApplyImmediately parameter is set to true.</p>
         *        <p>
         *        For a list of valid engine versions, see <a>CreateDBInstance</a>, or call
         *        <a>DescribeDBEngineVersions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String newDBClusterIdentifier;

        private Boolean applyImmediately;

        private Integer backupRetentionPeriod;

        private String dbClusterParameterGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Integer port;

        private String masterUserPassword;

        private String optionGroupName;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean enableIAMDatabaseAuthentication;

        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            newDBClusterIdentifier(model.newDBClusterIdentifier);
            applyImmediately(model.applyImmediately);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            port(model.port);
            masterUserPassword(model.masterUserPassword);
            optionGroupName(model.optionGroupName);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            engineVersion(model.engineVersion);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getNewDBClusterIdentifier() {
            return newDBClusterIdentifier;
        }

        @Override
        public final Builder newDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
            return this;
        }

        public final void setNewDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterRequest build() {
            return new ModifyDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
