/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbSubnetGroupRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyDbSubnetGroupRequest.Builder, ModifyDbSubnetGroupRequest> {
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbSubnetGroupRequest::dbSubnetGroupName)).setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbSubnetGroupRequest::dbSubnetGroupDescription))
            .setter(setter(Builder::dbSubnetGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupDescription").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyDbSubnetGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SubnetIdentifier")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SubnetIdentifier").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SUBNET_GROUP_NAME_FIELD,
            DB_SUBNET_GROUP_DESCRIPTION_FIELD, SUBNET_IDS_FIELD));

    private final String dbSubnetGroupName;

    private final String dbSubnetGroupDescription;

    private final List<String> subnetIds;

    private ModifyDbSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet
     * group.
     * </p>
     * <p>
     * Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the
     *         default subnet group. </p>
     *         <p>
     *         Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The description for the DB subnet group.
     * </p>
     * 
     * @return The description for the DB subnet group.
     */
    public String dbSubnetGroupDescription() {
        return dbSubnetGroupDescription;
    }

    /**
     * <p>
     * The EC2 subnet IDs for the DB subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The EC2 subnet IDs for the DB subnet group.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSubnetGroupRequest)) {
            return false;
        }
        ModifyDbSubnetGroupRequest other = (ModifyDbSubnetGroupRequest) obj;
        return Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(dbSubnetGroupDescription(), other.dbSubnetGroupDescription())
                && Objects.equals(subnetIds(), other.subnetIds());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyDbSubnetGroupRequest").add("DBSubnetGroupName", dbSubnetGroupName())
                .add("DBSubnetGroupDescription", dbSubnetGroupDescription()).add("SubnetIds", subnetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "DBSubnetGroupDescription":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupDescription()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSubnetGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbSubnetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbSubnetGroupRequest> {
        /**
         * <p>
         * The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default
         * subnet group.
         * </p>
         * <p>
         * Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the
         *        default subnet group. </p>
         *        <p>
         *        Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The description for the DB subnet group.
         * </p>
         * 
         * @param dbSubnetGroupDescription
         *        The description for the DB subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupDescription(String dbSubnetGroupDescription);

        /**
         * <p>
         * The EC2 subnet IDs for the DB subnet group.
         * </p>
         * 
         * @param subnetIds
         *        The EC2 subnet IDs for the DB subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The EC2 subnet IDs for the DB subnet group.
         * </p>
         * 
         * @param subnetIds
         *        The EC2 subnet IDs for the DB subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbSubnetGroupName;

        private String dbSubnetGroupDescription;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSubnetGroupRequest model) {
            super(model);
            dbSubnetGroupName(model.dbSubnetGroupName);
            dbSubnetGroupDescription(model.dbSubnetGroupDescription);
            subnetIds(model.subnetIds);
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDbSubnetGroupDescription() {
            return dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final void setDbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbSubnetGroupRequest build() {
            return new ModifyDbSubnetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
