/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of a successful invocation of the <a>DescribeEventSubscriptions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSubscription.Builder, EventSubscription> {
    private static final SdkField<String> CUSTOMER_AWS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerAwsId").getter(getter(EventSubscription::customerAwsId)).setter(setter(Builder::customerAwsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAwsId").build()).build();

    private static final SdkField<String> CUST_SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustSubscriptionId").getter(getter(EventSubscription::custSubscriptionId))
            .setter(setter(Builder::custSubscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustSubscriptionId").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(EventSubscription::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EventSubscription::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SUBSCRIPTION_CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionCreationTime").getter(getter(EventSubscription::subscriptionCreationTime))
            .setter(setter(Builder::subscriptionCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionCreationTime").build())
            .build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(EventSubscription::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> SOURCE_IDS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceIdsList")
            .getter(getter(EventSubscription::sourceIdsList))
            .setter(setter(Builder::sourceIdsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SourceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SourceId").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventCategoriesList")
            .getter(getter(EventSubscription::eventCategoriesList))
            .setter(setter(Builder::eventCategoriesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(EventSubscription::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> EVENT_SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSubscriptionArn").getter(getter(EventSubscription::eventSubscriptionArn))
            .setter(setter(Builder::eventSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscriptionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_AWS_ID_FIELD,
            CUST_SUBSCRIPTION_ID_FIELD, SNS_TOPIC_ARN_FIELD, STATUS_FIELD, SUBSCRIPTION_CREATION_TIME_FIELD, SOURCE_TYPE_FIELD,
            SOURCE_IDS_LIST_FIELD, EVENT_CATEGORIES_LIST_FIELD, ENABLED_FIELD, EVENT_SUBSCRIPTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customerAwsId;

    private final String custSubscriptionId;

    private final String snsTopicArn;

    private final String status;

    private final String subscriptionCreationTime;

    private final String sourceType;

    private final List<String> sourceIdsList;

    private final List<String> eventCategoriesList;

    private final Boolean enabled;

    private final String eventSubscriptionArn;

    private EventSubscription(BuilderImpl builder) {
        this.customerAwsId = builder.customerAwsId;
        this.custSubscriptionId = builder.custSubscriptionId;
        this.snsTopicArn = builder.snsTopicArn;
        this.status = builder.status;
        this.subscriptionCreationTime = builder.subscriptionCreationTime;
        this.sourceType = builder.sourceType;
        this.sourceIdsList = builder.sourceIdsList;
        this.eventCategoriesList = builder.eventCategoriesList;
        this.enabled = builder.enabled;
        this.eventSubscriptionArn = builder.eventSubscriptionArn;
    }

    /**
     * <p>
     * The Amazon customer account associated with the event notification subscription.
     * </p>
     * 
     * @return The Amazon customer account associated with the event notification subscription.
     */
    public final String customerAwsId() {
        return customerAwsId;
    }

    /**
     * <p>
     * The event notification subscription Id.
     * </p>
     * 
     * @return The event notification subscription Id.
     */
    public final String custSubscriptionId() {
        return custSubscriptionId;
    }

    /**
     * <p>
     * The topic ARN of the event notification subscription.
     * </p>
     * 
     * @return The topic ARN of the event notification subscription.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The status of the event notification subscription.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <p>
     * Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist
     * </p>
     * <p>
     * The status "no-permission" indicates that Neptune no longer has permission to post to the SNS topic. The status
     * "topic-not-exist" indicates that the topic was deleted after the subscription was created.
     * </p>
     * 
     * @return The status of the event notification subscription.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <p>
     *         Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist
     *         </p>
     *         <p>
     *         The status "no-permission" indicates that Neptune no longer has permission to post to the SNS topic. The
     *         status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The time the event notification subscription was created.
     * </p>
     * 
     * @return The time the event notification subscription was created.
     */
    public final String subscriptionCreationTime() {
        return subscriptionCreationTime;
    }

    /**
     * <p>
     * The source type for the event notification subscription.
     * </p>
     * 
     * @return The source type for the event notification subscription.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceIdsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceIdsList() {
        return sourceIdsList != null && !(sourceIdsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of source IDs for the event notification subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceIdsList} method.
     * </p>
     * 
     * @return A list of source IDs for the event notification subscription.
     */
    public final List<String> sourceIdsList() {
        return sourceIdsList;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventCategoriesList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventCategoriesList() {
        return eventCategoriesList != null && !(eventCategoriesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event categories for the event notification subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventCategoriesList} method.
     * </p>
     * 
     * @return A list of event categories for the event notification subscription.
     */
    public final List<String> eventCategoriesList() {
        return eventCategoriesList;
    }

    /**
     * <p>
     * A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.
     * </p>
     * 
     * @return A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the event subscription.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the event subscription.
     */
    public final String eventSubscriptionArn() {
        return eventSubscriptionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerAwsId());
        hashCode = 31 * hashCode + Objects.hashCode(custSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceIdsList() ? sourceIdsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventCategoriesList() ? eventCategoriesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(eventSubscriptionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription) obj;
        return Objects.equals(customerAwsId(), other.customerAwsId())
                && Objects.equals(custSubscriptionId(), other.custSubscriptionId())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(status(), other.status())
                && Objects.equals(subscriptionCreationTime(), other.subscriptionCreationTime())
                && Objects.equals(sourceType(), other.sourceType()) && hasSourceIdsList() == other.hasSourceIdsList()
                && Objects.equals(sourceIdsList(), other.sourceIdsList())
                && hasEventCategoriesList() == other.hasEventCategoriesList()
                && Objects.equals(eventCategoriesList(), other.eventCategoriesList())
                && Objects.equals(enabled(), other.enabled())
                && Objects.equals(eventSubscriptionArn(), other.eventSubscriptionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSubscription").add("CustomerAwsId", customerAwsId())
                .add("CustSubscriptionId", custSubscriptionId()).add("SnsTopicArn", snsTopicArn()).add("Status", status())
                .add("SubscriptionCreationTime", subscriptionCreationTime()).add("SourceType", sourceType())
                .add("SourceIdsList", hasSourceIdsList() ? sourceIdsList() : null)
                .add("EventCategoriesList", hasEventCategoriesList() ? eventCategoriesList() : null).add("Enabled", enabled())
                .add("EventSubscriptionArn", eventSubscriptionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerAwsId":
            return Optional.ofNullable(clazz.cast(customerAwsId()));
        case "CustSubscriptionId":
            return Optional.ofNullable(clazz.cast(custSubscriptionId()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SubscriptionCreationTime":
            return Optional.ofNullable(clazz.cast(subscriptionCreationTime()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "SourceIdsList":
            return Optional.ofNullable(clazz.cast(sourceIdsList()));
        case "EventCategoriesList":
            return Optional.ofNullable(clazz.cast(eventCategoriesList()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "EventSubscriptionArn":
            return Optional.ofNullable(clazz.cast(eventSubscriptionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerAwsId", CUSTOMER_AWS_ID_FIELD);
        map.put("CustSubscriptionId", CUST_SUBSCRIPTION_ID_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SubscriptionCreationTime", SUBSCRIPTION_CREATION_TIME_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("SourceIdsList", SOURCE_IDS_LIST_FIELD);
        map.put("EventCategoriesList", EVENT_CATEGORIES_LIST_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("EventSubscriptionArn", EVENT_SUBSCRIPTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventSubscription, T> g) {
        return obj -> g.apply((EventSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSubscription> {
        /**
         * <p>
         * The Amazon customer account associated with the event notification subscription.
         * </p>
         * 
         * @param customerAwsId
         *        The Amazon customer account associated with the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAwsId(String customerAwsId);

        /**
         * <p>
         * The event notification subscription Id.
         * </p>
         * 
         * @param custSubscriptionId
         *        The event notification subscription Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custSubscriptionId(String custSubscriptionId);

        /**
         * <p>
         * The topic ARN of the event notification subscription.
         * </p>
         * 
         * @param snsTopicArn
         *        The topic ARN of the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The status of the event notification subscription.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <p>
         * Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist
         * </p>
         * <p>
         * The status "no-permission" indicates that Neptune no longer has permission to post to the SNS topic. The
         * status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
         * </p>
         * 
         * @param status
         *        The status of the event notification subscription.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <p>
         *        Can be one of the following: creating | modifying | deleting | active | no-permission |
         *        topic-not-exist
         *        </p>
         *        <p>
         *        The status "no-permission" indicates that Neptune no longer has permission to post to the SNS topic.
         *        The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The time the event notification subscription was created.
         * </p>
         * 
         * @param subscriptionCreationTime
         *        The time the event notification subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionCreationTime(String subscriptionCreationTime);

        /**
         * <p>
         * The source type for the event notification subscription.
         * </p>
         * 
         * @param sourceType
         *        The source type for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * A list of source IDs for the event notification subscription.
         * </p>
         * 
         * @param sourceIdsList
         *        A list of source IDs for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdsList(Collection<String> sourceIdsList);

        /**
         * <p>
         * A list of source IDs for the event notification subscription.
         * </p>
         * 
         * @param sourceIdsList
         *        A list of source IDs for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdsList(String... sourceIdsList);

        /**
         * <p>
         * A list of event categories for the event notification subscription.
         * </p>
         * 
         * @param eventCategoriesList
         *        A list of event categories for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesList(Collection<String> eventCategoriesList);

        /**
         * <p>
         * A list of event categories for the event notification subscription.
         * </p>
         * 
         * @param eventCategoriesList
         *        A list of event categories for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesList(String... eventCategoriesList);

        /**
         * <p>
         * A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.
         * </p>
         * 
         * @param enabled
         *        A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the event subscription.
         * </p>
         * 
         * @param eventSubscriptionArn
         *        The Amazon Resource Name (ARN) for the event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptionArn(String eventSubscriptionArn);
    }

    static final class BuilderImpl implements Builder {
        private String customerAwsId;

        private String custSubscriptionId;

        private String snsTopicArn;

        private String status;

        private String subscriptionCreationTime;

        private String sourceType;

        private List<String> sourceIdsList = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventCategoriesList = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private String eventSubscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            customerAwsId(model.customerAwsId);
            custSubscriptionId(model.custSubscriptionId);
            snsTopicArn(model.snsTopicArn);
            status(model.status);
            subscriptionCreationTime(model.subscriptionCreationTime);
            sourceType(model.sourceType);
            sourceIdsList(model.sourceIdsList);
            eventCategoriesList(model.eventCategoriesList);
            enabled(model.enabled);
            eventSubscriptionArn(model.eventSubscriptionArn);
        }

        public final String getCustomerAwsId() {
            return customerAwsId;
        }

        public final void setCustomerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
        }

        @Override
        public final Builder customerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
            return this;
        }

        public final String getCustSubscriptionId() {
            return custSubscriptionId;
        }

        public final void setCustSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
        }

        @Override
        public final Builder custSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubscriptionCreationTime() {
            return subscriptionCreationTime;
        }

        public final void setSubscriptionCreationTime(String subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
        }

        @Override
        public final Builder subscriptionCreationTime(String subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Collection<String> getSourceIdsList() {
            if (sourceIdsList instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceIdsList;
        }

        public final void setSourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
        }

        @Override
        public final Builder sourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIdsList(String... sourceIdsList) {
            sourceIdsList(Arrays.asList(sourceIdsList));
            return this;
        }

        public final Collection<String> getEventCategoriesList() {
            if (eventCategoriesList instanceof SdkAutoConstructList) {
                return null;
            }
            return eventCategoriesList;
        }

        public final void setEventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
        }

        @Override
        public final Builder eventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesList(String... eventCategoriesList) {
            eventCategoriesList(Arrays.asList(eventCategoriesList));
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEventSubscriptionArn() {
            return eventSubscriptionArn;
        }

        public final void setEventSubscriptionArn(String eventSubscriptionArn) {
            this.eventSubscriptionArn = eventSubscriptionArn;
        }

        @Override
        public final Builder eventSubscriptionArn(String eventSubscriptionArn) {
            this.eventSubscriptionArn = eventSubscriptionArn;
            return this;
        }

        @Override
        public EventSubscription build() {
            return new EventSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
