/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.neptune.auth.scheme.NeptuneAuthSchemeParams;
import software.amazon.awssdk.services.neptune.auth.scheme.internal.DefaultNeptuneAuthSchemeProvider;
import software.amazon.awssdk.services.neptune.auth.scheme.internal.PreferredNeptuneAuthSchemeProvider;

@SdkPublicApi
public interface NeptuneAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(NeptuneAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<NeptuneAuthSchemeParams.Builder> consumer) {
        NeptuneAuthSchemeParams.Builder builder = NeptuneAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static NeptuneAuthSchemeProvider defaultProvider() {
        return DefaultNeptuneAuthSchemeProvider.create();
    }

    public static NeptuneAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredNeptuneAuthSchemeProvider(NeptuneAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

