/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon Neptune DB cluster parameter group.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>DescribeDBClusterParameterGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterParameterGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<DBClusterParameterGroup.Builder, DBClusterParameterGroup> {
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(DBClusterParameterGroup::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupFamily").getter(getter(DBClusterParameterGroup::dbParameterGroupFamily))
            .setter(setter(Builder::dbParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DBClusterParameterGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupArn")
            .getter(getter(DBClusterParameterGroup::dbClusterParameterGroupArn))
            .setter(setter(Builder::dbClusterParameterGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbClusterParameterGroupName;

    private final String dbParameterGroupFamily;

    private final String description;

    private final String dbClusterParameterGroupArn;

    private DBClusterParameterGroup(BuilderImpl builder) {
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.description = builder.description;
        this.dbClusterParameterGroupArn = builder.dbClusterParameterGroupArn;
    }

    /**
     * <p>
     * Provides the name of the DB cluster parameter group.
     * </p>
     * 
     * @return Provides the name of the DB cluster parameter group.
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.
     * </p>
     * 
     * @return Provides the name of the DB parameter group family that this DB cluster parameter group is compatible
     *         with.
     */
    public final String dbParameterGroupFamily() {
        return dbParameterGroupFamily;
    }

    /**
     * <p>
     * Provides the customer-specified description for this DB cluster parameter group.
     * </p>
     * 
     * @return Provides the customer-specified description for this DB cluster parameter group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB cluster parameter group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the DB cluster parameter group.
     */
    public final String dbClusterParameterGroupArn() {
        return dbClusterParameterGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterParameterGroup)) {
            return false;
        }
        DBClusterParameterGroup other = (DBClusterParameterGroup) obj;
        return Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(dbParameterGroupFamily(), other.dbParameterGroupFamily())
                && Objects.equals(description(), other.description())
                && Objects.equals(dbClusterParameterGroupArn(), other.dbClusterParameterGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBClusterParameterGroup").add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("DBParameterGroupFamily", dbParameterGroupFamily()).add("Description", description())
                .add("DBClusterParameterGroupArn", dbClusterParameterGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "DBParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(dbParameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DBClusterParameterGroupArn":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBClusterParameterGroupName", DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD);
        map.put("DBParameterGroupFamily", DB_PARAMETER_GROUP_FAMILY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DBClusterParameterGroupArn", DB_CLUSTER_PARAMETER_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBClusterParameterGroup, T> g) {
        return obj -> g.apply((DBClusterParameterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterParameterGroup> {
        /**
         * <p>
         * Provides the name of the DB cluster parameter group.
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        Provides the name of the DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.
         * </p>
         * 
         * @param dbParameterGroupFamily
         *        Provides the name of the DB parameter group family that this DB cluster parameter group is compatible
         *        with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupFamily(String dbParameterGroupFamily);

        /**
         * <p>
         * Provides the customer-specified description for this DB cluster parameter group.
         * </p>
         * 
         * @param description
         *        Provides the customer-specified description for this DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the DB cluster parameter group.
         * </p>
         * 
         * @param dbClusterParameterGroupArn
         *        The Amazon Resource Name (ARN) for the DB cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupArn(String dbClusterParameterGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String dbClusterParameterGroupName;

        private String dbParameterGroupFamily;

        private String description;

        private String dbClusterParameterGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterParameterGroup model) {
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            dbParameterGroupFamily(model.dbParameterGroupFamily);
            description(model.description);
            dbClusterParameterGroupArn(model.dbClusterParameterGroupArn);
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final String getDbParameterGroupFamily() {
            return dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDbClusterParameterGroupArn() {
            return dbClusterParameterGroupArn;
        }

        public final void setDbClusterParameterGroupArn(String dbClusterParameterGroupArn) {
            this.dbClusterParameterGroupArn = dbClusterParameterGroupArn;
        }

        @Override
        public final Builder dbClusterParameterGroupArn(String dbClusterParameterGroupArn) {
            this.dbClusterParameterGroupArn = dbClusterParameterGroupArn;
            return this;
        }

        @Override
        public DBClusterParameterGroup build() {
            return new DBClusterParameterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
