/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterParameterGroupsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeDbClusterParameterGroupsResponse.Builder, DescribeDbClusterParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbClusterParameterGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBClusterParameterGroup>> DB_CLUSTER_PARAMETER_GROUPS_FIELD = SdkField
            .<List<DBClusterParameterGroup>> builder(MarshallingType.LIST)
            .memberName("DBClusterParameterGroups")
            .getter(getter(DescribeDbClusterParameterGroupsResponse::dbClusterParameterGroups))
            .setter(setter(Builder::dbClusterParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<DBClusterParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterParameterGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_CLUSTER_PARAMETER_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<DBClusterParameterGroup> dbClusterParameterGroups;

    private DescribeDbClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterParameterGroups = builder.dbClusterParameterGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If
     * this parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code>
     *         request. If this parameter is specified, the response includes only records beyond the marker, up to the
     *         value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBClusterParameterGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDbClusterParameterGroups() {
        return dbClusterParameterGroups != null && !(dbClusterParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB cluster parameter groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterParameterGroups} method.
     * </p>
     * 
     * @return A list of DB cluster parameter groups.
     */
    public final List<DBClusterParameterGroup> dbClusterParameterGroups() {
        return dbClusterParameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterParameterGroups() ? dbClusterParameterGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeDbClusterParameterGroupsResponse other = (DescribeDbClusterParameterGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbClusterParameterGroups() == other.hasDbClusterParameterGroups()
                && Objects.equals(dbClusterParameterGroups(), other.dbClusterParameterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbClusterParameterGroupsResponse").add("Marker", marker())
                .add("DBClusterParameterGroups", hasDbClusterParameterGroups() ? dbClusterParameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBClusterParameterGroups":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBClusterParameterGroups", DB_CLUSTER_PARAMETER_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbClusterParameterGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If
         * this parameter is specified, the response includes only records beyond the marker, up to the value specified
         * by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code>
         *        request. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of DB cluster parameter groups.
         * </p>
         * 
         * @param dbClusterParameterGroups
         *        A list of DB cluster parameter groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups);

        /**
         * <p>
         * A list of DB cluster parameter groups.
         * </p>
         * 
         * @param dbClusterParameterGroups
         *        A list of DB cluster parameter groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroups(DBClusterParameterGroup... dbClusterParameterGroups);

        /**
         * <p>
         * A list of DB cluster parameter groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #dbClusterParameterGroups(List<DBClusterParameterGroup>)}.
         * 
         * @param dbClusterParameterGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterParameterGroups(java.util.Collection<DBClusterParameterGroup>)
         */
        Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder>... dbClusterParameterGroups);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBClusterParameterGroup> dbClusterParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterParameterGroupsResponse model) {
            super(model);
            marker(model.marker);
            dbClusterParameterGroups(model.dbClusterParameterGroups);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBClusterParameterGroup.Builder> getDbClusterParameterGroups() {
            List<DBClusterParameterGroup.Builder> result = DBClusterParameterGroupListCopier
                    .copyToBuilder(this.dbClusterParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterParameterGroups(Collection<DBClusterParameterGroup.BuilderImpl> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copyFromBuilder(dbClusterParameterGroups);
        }

        @Override
        public final Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(DBClusterParameterGroup... dbClusterParameterGroups) {
            dbClusterParameterGroups(Arrays.asList(dbClusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder>... dbClusterParameterGroups) {
            dbClusterParameterGroups(Stream.of(dbClusterParameterGroups)
                    .map(c -> DBClusterParameterGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbClusterParameterGroupsResponse build() {
            return new DescribeDbClusterParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
