/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventSubscriptionsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeEventSubscriptionsResponse.Builder, DescribeEventSubscriptionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEventSubscriptionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_LIST_FIELD = SdkField
            .<List<EventSubscription>> builder(MarshallingType.LIST)
            .memberName("EventSubscriptionsList")
            .getter(getter(DescribeEventSubscriptionsResponse::eventSubscriptionsList))
            .setter(setter(Builder::eventSubscriptionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscriptionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventSubscription")
                            .memberFieldInfo(
                                    SdkField.<EventSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventSubscription").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            EVENT_SUBSCRIPTIONS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<EventSubscription> eventSubscriptionsList;

    private DescribeEventSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.eventSubscriptionsList = builder.eventSubscriptionsList;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter
     * is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSubscriptionsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEventSubscriptionsList() {
        return eventSubscriptionsList != null && !(eventSubscriptionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EventSubscriptions data types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSubscriptionsList} method.
     * </p>
     * 
     * @return A list of EventSubscriptions data types.
     */
    public final List<EventSubscription> eventSubscriptionsList() {
        return eventSubscriptionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSubscriptionsList() ? eventSubscriptionsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsResponse)) {
            return false;
        }
        DescribeEventSubscriptionsResponse other = (DescribeEventSubscriptionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasEventSubscriptionsList() == other.hasEventSubscriptionsList()
                && Objects.equals(eventSubscriptionsList(), other.eventSubscriptionsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventSubscriptionsResponse").add("Marker", marker())
                .add("EventSubscriptionsList", hasEventSubscriptionsList() ? eventSubscriptionsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "EventSubscriptionsList":
            return Optional.ofNullable(clazz.cast(eventSubscriptionsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("EventSubscriptionsList", EVENT_SUBSCRIPTIONS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSubscriptionsResponse, T> g) {
        return obj -> g.apply((DescribeEventSubscriptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If
         *        this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of EventSubscriptions data types.
         * </p>
         * 
         * @param eventSubscriptionsList
         *        A list of EventSubscriptions data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList);

        /**
         * <p>
         * A list of EventSubscriptions data types.
         * </p>
         * 
         * @param eventSubscriptionsList
         *        A list of EventSubscriptions data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptionsList(EventSubscription... eventSubscriptionsList);

        /**
         * <p>
         * A list of EventSubscriptions data types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptune.model.EventSubscription.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.neptune.model.EventSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptune.model.EventSubscription.Builder#build()} is called immediately
         * and its result is passed to {@link #eventSubscriptionsList(List<EventSubscription>)}.
         * 
         * @param eventSubscriptionsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptune.model.EventSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscriptionsList(java.util.Collection<EventSubscription>)
         */
        Builder eventSubscriptionsList(Consumer<EventSubscription.Builder>... eventSubscriptionsList);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<EventSubscription> eventSubscriptionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsResponse model) {
            super(model);
            marker(model.marker);
            eventSubscriptionsList(model.eventSubscriptionsList);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptionsList() {
            List<EventSubscription.Builder> result = EventSubscriptionsListCopier.copyToBuilder(this.eventSubscriptionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptionsList(Collection<EventSubscription.BuilderImpl> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copyFromBuilder(eventSubscriptionsList);
        }

        @Override
        public final Builder eventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copy(eventSubscriptionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(EventSubscription... eventSubscriptionsList) {
            eventSubscriptionsList(Arrays.asList(eventSubscriptionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(Consumer<EventSubscription.Builder>... eventSubscriptionsList) {
            eventSubscriptionsList(Stream.of(eventSubscriptionsList)
                    .map(c -> EventSubscription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventSubscriptionsResponse build() {
            return new DescribeEventSubscriptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
