/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGlobalClustersResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeGlobalClustersResponse.Builder, DescribeGlobalClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeGlobalClustersResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<GlobalCluster>> GLOBAL_CLUSTERS_FIELD = SdkField
            .<List<GlobalCluster>> builder(MarshallingType.LIST)
            .memberName("GlobalClusters")
            .getter(getter(DescribeGlobalClustersResponse::globalClusters))
            .setter(setter(Builder::globalClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalClusterMember")
                            .memberFieldInfo(
                                    SdkField.<GlobalCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalClusterMember").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            GLOBAL_CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<GlobalCluster> globalClusters;

    private DescribeGlobalClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.globalClusters = builder.globalClusters;
    }

    /**
     * <p>
     * A pagination token. If this parameter is returned in the response, more records are available, which can be
     * retrieved by one or more additional calls to <code>DescribeGlobalClusters</code>.
     * </p>
     * 
     * @return A pagination token. If this parameter is returned in the response, more records are available, which can
     *         be retrieved by one or more additional calls to <code>DescribeGlobalClusters</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlobalClusters() {
        return globalClusters != null && !(globalClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of global clusters and instances returned by this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalClusters} method.
     * </p>
     * 
     * @return The list of global clusters and instances returned by this request.
     */
    public final List<GlobalCluster> globalClusters() {
        return globalClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalClusters() ? globalClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalClustersResponse)) {
            return false;
        }
        DescribeGlobalClustersResponse other = (DescribeGlobalClustersResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasGlobalClusters() == other.hasGlobalClusters()
                && Objects.equals(globalClusters(), other.globalClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGlobalClustersResponse").add("Marker", marker())
                .add("GlobalClusters", hasGlobalClusters() ? globalClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "GlobalClusters":
            return Optional.ofNullable(clazz.cast(globalClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("GlobalClusters", GLOBAL_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalClustersResponse, T> g) {
        return obj -> g.apply((DescribeGlobalClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGlobalClustersResponse> {
        /**
         * <p>
         * A pagination token. If this parameter is returned in the response, more records are available, which can be
         * retrieved by one or more additional calls to <code>DescribeGlobalClusters</code>.
         * </p>
         * 
         * @param marker
         *        A pagination token. If this parameter is returned in the response, more records are available, which
         *        can be retrieved by one or more additional calls to <code>DescribeGlobalClusters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The list of global clusters and instances returned by this request.
         * </p>
         * 
         * @param globalClusters
         *        The list of global clusters and instances returned by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusters(Collection<GlobalCluster> globalClusters);

        /**
         * <p>
         * The list of global clusters and instances returned by this request.
         * </p>
         * 
         * @param globalClusters
         *        The list of global clusters and instances returned by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusters(GlobalCluster... globalClusters);

        /**
         * <p>
         * The list of global clusters and instances returned by this request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptune.model.GlobalCluster.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.neptune.model.GlobalCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptune.model.GlobalCluster.Builder#build()} is called immediately and
         * its result is passed to {@link #globalClusters(List<GlobalCluster>)}.
         * 
         * @param globalClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptune.model.GlobalCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalClusters(java.util.Collection<GlobalCluster>)
         */
        Builder globalClusters(Consumer<GlobalCluster.Builder>... globalClusters);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<GlobalCluster> globalClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalClustersResponse model) {
            super(model);
            marker(model.marker);
            globalClusters(model.globalClusters);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<GlobalCluster.Builder> getGlobalClusters() {
            List<GlobalCluster.Builder> result = GlobalClusterListCopier.copyToBuilder(this.globalClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalClusters(Collection<GlobalCluster.BuilderImpl> globalClusters) {
            this.globalClusters = GlobalClusterListCopier.copyFromBuilder(globalClusters);
        }

        @Override
        public final Builder globalClusters(Collection<GlobalCluster> globalClusters) {
            this.globalClusters = GlobalClusterListCopier.copy(globalClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusters(GlobalCluster... globalClusters) {
            globalClusters(Arrays.asList(globalClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusters(Consumer<GlobalCluster.Builder>... globalClusters) {
            globalClusters(Stream.of(globalClusters).map(c -> GlobalCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeGlobalClustersResponse build() {
            return new DescribeGlobalClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
