/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverGlobalClusterRequest extends NeptuneRequest implements
        ToCopyableBuilder<FailoverGlobalClusterRequest.Builder, FailoverGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(FailoverGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> TARGET_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDbClusterIdentifier").getter(getter(FailoverGlobalClusterRequest::targetDbClusterIdentifier))
            .setter(setter(Builder::targetDbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDbClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> ALLOW_DATA_LOSS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowDataLoss").getter(getter(FailoverGlobalClusterRequest::allowDataLoss))
            .setter(setter(Builder::allowDataLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowDataLoss").build()).build();

    private static final SdkField<Boolean> SWITCHOVER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Switchover").getter(getter(FailoverGlobalClusterRequest::switchover))
            .setter(setter(Builder::switchover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Switchover").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_IDENTIFIER_FIELD, ALLOW_DATA_LOSS_FIELD, SWITCHOVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalClusterIdentifier;

    private final String targetDbClusterIdentifier;

    private final Boolean allowDataLoss;

    private final Boolean switchover;

    private FailoverGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.targetDbClusterIdentifier = builder.targetDbClusterIdentifier;
        this.allowDataLoss = builder.allowDataLoss;
        this.switchover = builder.switchover;
    }

    /**
     * <p>
     * Identifier of the Neptune global database that should be failed over. The identifier is the unique key assigned
     * by the user when the Neptune global database was created. In other words, it's the name of the global database
     * that you want to fail over.
     * </p>
     * <p>
     * Constraints: Must match the identifier of an existing Neptune global database.
     * </p>
     * 
     * @return Identifier of the Neptune global database that should be failed over. The identifier is the unique key
     *         assigned by the user when the Neptune global database was created. In other words, it's the name of the
     *         global database that you want to fail over.</p>
     *         <p>
     *         Constraints: Must match the identifier of an existing Neptune global database.
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary for the
     * global database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary
     *         for the global database.
     */
    public final String targetDbClusterIdentifier() {
        return targetDbClusterIdentifier;
    }

    /**
     * <p>
     * Specifies whether to allow data loss for this global database cluster operation. Allowing data loss triggers a
     * global failover operation.
     * </p>
     * <p>
     * If you don't specify <code>AllowDataLoss</code>, the global database cluster operation defaults to a switchover.
     * </p>
     * <p>
     * Constraints:Can't be specified together with the <code>Switchover</code> parameter.
     * </p>
     * 
     * @return Specifies whether to allow data loss for this global database cluster operation. Allowing data loss
     *         triggers a global failover operation.</p>
     *         <p>
     *         If you don't specify <code>AllowDataLoss</code>, the global database cluster operation defaults to a
     *         switchover.
     *         </p>
     *         <p>
     *         Constraints:Can't be specified together with the <code>Switchover</code> parameter.
     */
    public final Boolean allowDataLoss() {
        return allowDataLoss;
    }

    /**
     * <p>
     * Specifies whether to switch over this global database cluster.
     * </p>
     * <p>
     * Constraints:Can't be specified together with the <code>AllowDataLoss</code> parameter.
     * </p>
     * 
     * @return Specifies whether to switch over this global database cluster.</p>
     *         <p>
     *         Constraints:Can't be specified together with the <code>AllowDataLoss</code> parameter.
     */
    public final Boolean switchover() {
        return switchover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(allowDataLoss());
        hashCode = 31 * hashCode + Objects.hashCode(switchover());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverGlobalClusterRequest)) {
            return false;
        }
        FailoverGlobalClusterRequest other = (FailoverGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(targetDbClusterIdentifier(), other.targetDbClusterIdentifier())
                && Objects.equals(allowDataLoss(), other.allowDataLoss()) && Objects.equals(switchover(), other.switchover());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("TargetDbClusterIdentifier", targetDbClusterIdentifier()).add("AllowDataLoss", allowDataLoss())
                .add("Switchover", switchover()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "TargetDbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(targetDbClusterIdentifier()));
        case "AllowDataLoss":
            return Optional.ofNullable(clazz.cast(allowDataLoss()));
        case "Switchover":
            return Optional.ofNullable(clazz.cast(switchover()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("TargetDbClusterIdentifier", TARGET_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("AllowDataLoss", ALLOW_DATA_LOSS_FIELD);
        map.put("Switchover", SWITCHOVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverGlobalClusterRequest, T> g) {
        return obj -> g.apply((FailoverGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, FailoverGlobalClusterRequest> {
        /**
         * <p>
         * Identifier of the Neptune global database that should be failed over. The identifier is the unique key
         * assigned by the user when the Neptune global database was created. In other words, it's the name of the
         * global database that you want to fail over.
         * </p>
         * <p>
         * Constraints: Must match the identifier of an existing Neptune global database.
         * </p>
         * 
         * @param globalClusterIdentifier
         *        Identifier of the Neptune global database that should be failed over. The identifier is the unique key
         *        assigned by the user when the Neptune global database was created. In other words, it's the name of
         *        the global database that you want to fail over.</p>
         *        <p>
         *        Constraints: Must match the identifier of an existing Neptune global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary for
         * the global database.
         * </p>
         * 
         * @param targetDbClusterIdentifier
         *        The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary
         *        for the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDbClusterIdentifier(String targetDbClusterIdentifier);

        /**
         * <p>
         * Specifies whether to allow data loss for this global database cluster operation. Allowing data loss triggers
         * a global failover operation.
         * </p>
         * <p>
         * If you don't specify <code>AllowDataLoss</code>, the global database cluster operation defaults to a
         * switchover.
         * </p>
         * <p>
         * Constraints:Can't be specified together with the <code>Switchover</code> parameter.
         * </p>
         * 
         * @param allowDataLoss
         *        Specifies whether to allow data loss for this global database cluster operation. Allowing data loss
         *        triggers a global failover operation.</p>
         *        <p>
         *        If you don't specify <code>AllowDataLoss</code>, the global database cluster operation defaults to a
         *        switchover.
         *        </p>
         *        <p>
         *        Constraints:Can't be specified together with the <code>Switchover</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDataLoss(Boolean allowDataLoss);

        /**
         * <p>
         * Specifies whether to switch over this global database cluster.
         * </p>
         * <p>
         * Constraints:Can't be specified together with the <code>AllowDataLoss</code> parameter.
         * </p>
         * 
         * @param switchover
         *        Specifies whether to switch over this global database cluster.</p>
         *        <p>
         *        Constraints:Can't be specified together with the <code>AllowDataLoss</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder switchover(Boolean switchover);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String targetDbClusterIdentifier;

        private Boolean allowDataLoss;

        private Boolean switchover;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            targetDbClusterIdentifier(model.targetDbClusterIdentifier);
            allowDataLoss(model.allowDataLoss);
            switchover(model.switchover);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getTargetDbClusterIdentifier() {
            return targetDbClusterIdentifier;
        }

        public final void setTargetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
        }

        @Override
        public final Builder targetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
            return this;
        }

        public final Boolean getAllowDataLoss() {
            return allowDataLoss;
        }

        public final void setAllowDataLoss(Boolean allowDataLoss) {
            this.allowDataLoss = allowDataLoss;
        }

        @Override
        public final Builder allowDataLoss(Boolean allowDataLoss) {
            this.allowDataLoss = allowDataLoss;
            return this;
        }

        public final Boolean getSwitchover() {
            return switchover;
        }

        public final void setSwitchover(Boolean switchover) {
            this.switchover = switchover;
        }

        @Override
        public final Builder switchover(Boolean switchover) {
            this.switchover = switchover;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FailoverGlobalClusterRequest build() {
            return new FailoverGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
