/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon Neptune global database.
 * </p>
 * <p>
 * This data type is used as a response element for the <a>CreateGlobalCluster</a>, <a>DescribeGlobalClusters</a>,
 * <a>ModifyGlobalCluster</a>, <a>DeleteGlobalCluster</a>, <a>FailoverGlobalCluster</a>, and
 * <a>RemoveFromGlobalCluster</a> actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalCluster implements SdkPojo, Serializable, ToCopyableBuilder<GlobalCluster.Builder, GlobalCluster> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(GlobalCluster::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> GLOBAL_CLUSTER_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterResourceId").getter(getter(GlobalCluster::globalClusterResourceId))
            .setter(setter(Builder::globalClusterResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterResourceId").build())
            .build();

    private static final SdkField<String> GLOBAL_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterArn").getter(getter(GlobalCluster::globalClusterArn))
            .setter(setter(Builder::globalClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GlobalCluster::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(GlobalCluster::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(GlobalCluster::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(GlobalCluster::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(GlobalCluster::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<List<GlobalClusterMember>> GLOBAL_CLUSTER_MEMBERS_FIELD = SdkField
            .<List<GlobalClusterMember>> builder(MarshallingType.LIST)
            .memberName("GlobalClusterMembers")
            .getter(getter(GlobalCluster::globalClusterMembers))
            .setter(setter(Builder::globalClusterMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalClusterMember")
                            .memberFieldInfo(
                                    SdkField.<GlobalClusterMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalClusterMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalClusterMember").build()).build()).build()).build();

    private static final SdkField<FailoverState> FAILOVER_STATE_FIELD = SdkField
            .<FailoverState> builder(MarshallingType.SDK_POJO).memberName("FailoverState")
            .getter(getter(GlobalCluster::failoverState)).setter(setter(Builder::failoverState))
            .constructor(FailoverState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, GLOBAL_CLUSTER_RESOURCE_ID_FIELD, GLOBAL_CLUSTER_ARN_FIELD, STATUS_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, STORAGE_ENCRYPTED_FIELD, DELETION_PROTECTION_FIELD, GLOBAL_CLUSTER_MEMBERS_FIELD,
            FAILOVER_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String globalClusterIdentifier;

    private final String globalClusterResourceId;

    private final String globalClusterArn;

    private final String status;

    private final String engine;

    private final String engineVersion;

    private final Boolean storageEncrypted;

    private final Boolean deletionProtection;

    private final List<GlobalClusterMember> globalClusterMembers;

    private final FailoverState failoverState;

    private GlobalCluster(BuilderImpl builder) {
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.globalClusterResourceId = builder.globalClusterResourceId;
        this.globalClusterArn = builder.globalClusterArn;
        this.status = builder.status;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.storageEncrypted = builder.storageEncrypted;
        this.deletionProtection = builder.deletionProtection;
        this.globalClusterMembers = builder.globalClusterMembers;
        this.failoverState = builder.failoverState;
    }

    /**
     * <p>
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a
     * global database.
     * </p>
     * 
     * @return Contains a user-supplied global database cluster identifier. This identifier is the unique key that
     *         identifies a global database.
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * An immutable identifier for the global database that is unique within in all regions. This identifier is found in
     * CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     * </p>
     * 
     * @return An immutable identifier for the global database that is unique within in all regions. This identifier is
     *         found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */
    public final String globalClusterResourceId() {
        return globalClusterResourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the global database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the global database.
     */
    public final String globalClusterArn() {
        return globalClusterArn;
    }

    /**
     * <p>
     * Specifies the current state of this global database.
     * </p>
     * 
     * @return Specifies the current state of this global database.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The Neptune database engine used by the global database (<code>"neptune"</code>).
     * </p>
     * 
     * @return The Neptune database engine used by the global database (<code>"neptune"</code>).
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The Neptune engine version used by the global database.
     * </p>
     * 
     * @return The Neptune engine version used by the global database.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The storage encryption setting for the global database.
     * </p>
     * 
     * @return The storage encryption setting for the global database.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The deletion protection setting for the global database.
     * </p>
     * 
     * @return The deletion protection setting for the global database.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalClusterMembers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlobalClusterMembers() {
        return globalClusterMembers != null && !(globalClusterMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalClusterMembers} method.
     * </p>
     * 
     * @return A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     */
    public final List<GlobalClusterMember> globalClusterMembers() {
        return globalClusterMembers;
    }

    /**
     * <p>
     * A data object containing all properties for the current state of an in-process or pending switchover or failover
     * process for this global cluster (Neptune global database). This object is empty unless the
     * <code>SwitchoverGlobalCluster</code> or <code>FailoverGlobalCluster</code> operation was called on this global
     * cluster.
     * </p>
     * 
     * @return A data object containing all properties for the current state of an in-process or pending switchover or
     *         failover process for this global cluster (Neptune global database). This object is empty unless the
     *         <code>SwitchoverGlobalCluster</code> or <code>FailoverGlobalCluster</code> operation was called on this
     *         global cluster.
     */
    public final FailoverState failoverState() {
        return failoverState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalClusterMembers() ? globalClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failoverState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalCluster)) {
            return false;
        }
        GlobalCluster other = (GlobalCluster) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(globalClusterResourceId(), other.globalClusterResourceId())
                && Objects.equals(globalClusterArn(), other.globalClusterArn()) && Objects.equals(status(), other.status())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(storageEncrypted(), other.storageEncrypted())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && hasGlobalClusterMembers() == other.hasGlobalClusterMembers()
                && Objects.equals(globalClusterMembers(), other.globalClusterMembers())
                && Objects.equals(failoverState(), other.failoverState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalCluster").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("GlobalClusterResourceId", globalClusterResourceId()).add("GlobalClusterArn", globalClusterArn())
                .add("Status", status()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("StorageEncrypted", storageEncrypted()).add("DeletionProtection", deletionProtection())
                .add("GlobalClusterMembers", hasGlobalClusterMembers() ? globalClusterMembers() : null)
                .add("FailoverState", failoverState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "GlobalClusterResourceId":
            return Optional.ofNullable(clazz.cast(globalClusterResourceId()));
        case "GlobalClusterArn":
            return Optional.ofNullable(clazz.cast(globalClusterArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "GlobalClusterMembers":
            return Optional.ofNullable(clazz.cast(globalClusterMembers()));
        case "FailoverState":
            return Optional.ofNullable(clazz.cast(failoverState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("GlobalClusterResourceId", GLOBAL_CLUSTER_RESOURCE_ID_FIELD);
        map.put("GlobalClusterArn", GLOBAL_CLUSTER_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("GlobalClusterMembers", GLOBAL_CLUSTER_MEMBERS_FIELD);
        map.put("FailoverState", FAILOVER_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalCluster, T> g) {
        return obj -> g.apply((GlobalCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalCluster> {
        /**
         * <p>
         * Contains a user-supplied global database cluster identifier. This identifier is the unique key that
         * identifies a global database.
         * </p>
         * 
         * @param globalClusterIdentifier
         *        Contains a user-supplied global database cluster identifier. This identifier is the unique key that
         *        identifies a global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * An immutable identifier for the global database that is unique within in all regions. This identifier is
         * found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
         * </p>
         * 
         * @param globalClusterResourceId
         *        An immutable identifier for the global database that is unique within in all regions. This identifier
         *        is found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterResourceId(String globalClusterResourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the global database.
         * </p>
         * 
         * @param globalClusterArn
         *        The Amazon Resource Name (ARN) for the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterArn(String globalClusterArn);

        /**
         * <p>
         * Specifies the current state of this global database.
         * </p>
         * 
         * @param status
         *        Specifies the current state of this global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Neptune database engine used by the global database (<code>"neptune"</code>).
         * </p>
         * 
         * @param engine
         *        The Neptune database engine used by the global database (<code>"neptune"</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The Neptune engine version used by the global database.
         * </p>
         * 
         * @param engineVersion
         *        The Neptune engine version used by the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The storage encryption setting for the global database.
         * </p>
         * 
         * @param storageEncrypted
         *        The storage encryption setting for the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The deletion protection setting for the global database.
         * </p>
         * 
         * @param deletionProtection
         *        The deletion protection setting for the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
         * </p>
         * 
         * @param globalClusterMembers
         *        A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterMembers(Collection<GlobalClusterMember> globalClusterMembers);

        /**
         * <p>
         * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
         * </p>
         * 
         * @param globalClusterMembers
         *        A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterMembers(GlobalClusterMember... globalClusterMembers);

        /**
         * <p>
         * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptune.model.GlobalClusterMember.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.neptune.model.GlobalClusterMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptune.model.GlobalClusterMember.Builder#build()} is called
         * immediately and its result is passed to {@link #globalClusterMembers(List<GlobalClusterMember>)}.
         * 
         * @param globalClusterMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptune.model.GlobalClusterMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalClusterMembers(java.util.Collection<GlobalClusterMember>)
         */
        Builder globalClusterMembers(Consumer<GlobalClusterMember.Builder>... globalClusterMembers);

        /**
         * <p>
         * A data object containing all properties for the current state of an in-process or pending switchover or
         * failover process for this global cluster (Neptune global database). This object is empty unless the
         * <code>SwitchoverGlobalCluster</code> or <code>FailoverGlobalCluster</code> operation was called on this
         * global cluster.
         * </p>
         * 
         * @param failoverState
         *        A data object containing all properties for the current state of an in-process or pending switchover
         *        or failover process for this global cluster (Neptune global database). This object is empty unless the
         *        <code>SwitchoverGlobalCluster</code> or <code>FailoverGlobalCluster</code> operation was called on
         *        this global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failoverState(FailoverState failoverState);

        /**
         * <p>
         * A data object containing all properties for the current state of an in-process or pending switchover or
         * failover process for this global cluster (Neptune global database). This object is empty unless the
         * <code>SwitchoverGlobalCluster</code> or <code>FailoverGlobalCluster</code> operation was called on this
         * global cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailoverState.Builder} avoiding the need
         * to create one manually via {@link FailoverState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverState.Builder#build()} is called immediately and its
         * result is passed to {@link #failoverState(FailoverState)}.
         * 
         * @param failoverState
         *        a consumer that will call methods on {@link FailoverState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failoverState(FailoverState)
         */
        default Builder failoverState(Consumer<FailoverState.Builder> failoverState) {
            return failoverState(FailoverState.builder().applyMutation(failoverState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String globalClusterResourceId;

        private String globalClusterArn;

        private String status;

        private String engine;

        private String engineVersion;

        private Boolean storageEncrypted;

        private Boolean deletionProtection;

        private List<GlobalClusterMember> globalClusterMembers = DefaultSdkAutoConstructList.getInstance();

        private FailoverState failoverState;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalCluster model) {
            globalClusterIdentifier(model.globalClusterIdentifier);
            globalClusterResourceId(model.globalClusterResourceId);
            globalClusterArn(model.globalClusterArn);
            status(model.status);
            engine(model.engine);
            engineVersion(model.engineVersion);
            storageEncrypted(model.storageEncrypted);
            deletionProtection(model.deletionProtection);
            globalClusterMembers(model.globalClusterMembers);
            failoverState(model.failoverState);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getGlobalClusterResourceId() {
            return globalClusterResourceId;
        }

        public final void setGlobalClusterResourceId(String globalClusterResourceId) {
            this.globalClusterResourceId = globalClusterResourceId;
        }

        @Override
        public final Builder globalClusterResourceId(String globalClusterResourceId) {
            this.globalClusterResourceId = globalClusterResourceId;
            return this;
        }

        public final String getGlobalClusterArn() {
            return globalClusterArn;
        }

        public final void setGlobalClusterArn(String globalClusterArn) {
            this.globalClusterArn = globalClusterArn;
        }

        @Override
        public final Builder globalClusterArn(String globalClusterArn) {
            this.globalClusterArn = globalClusterArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final List<GlobalClusterMember.Builder> getGlobalClusterMembers() {
            List<GlobalClusterMember.Builder> result = GlobalClusterMemberListCopier.copyToBuilder(this.globalClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalClusterMembers(Collection<GlobalClusterMember.BuilderImpl> globalClusterMembers) {
            this.globalClusterMembers = GlobalClusterMemberListCopier.copyFromBuilder(globalClusterMembers);
        }

        @Override
        public final Builder globalClusterMembers(Collection<GlobalClusterMember> globalClusterMembers) {
            this.globalClusterMembers = GlobalClusterMemberListCopier.copy(globalClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusterMembers(GlobalClusterMember... globalClusterMembers) {
            globalClusterMembers(Arrays.asList(globalClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusterMembers(Consumer<GlobalClusterMember.Builder>... globalClusterMembers) {
            globalClusterMembers(Stream.of(globalClusterMembers).map(c -> GlobalClusterMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FailoverState.Builder getFailoverState() {
            return failoverState != null ? failoverState.toBuilder() : null;
        }

        public final void setFailoverState(FailoverState.BuilderImpl failoverState) {
            this.failoverState = failoverState != null ? failoverState.build() : null;
        }

        @Override
        public final Builder failoverState(FailoverState failoverState) {
            this.failoverState = failoverState;
            return this;
        }

        @Override
        public GlobalCluster build() {
            return new GlobalCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
