/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the scaling configuration of a Neptune Serverless DB cluster.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune
 * Serverless</a> in the <i>Amazon Neptune User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessV2ScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessV2ScalingConfiguration.Builder, ServerlessV2ScalingConfiguration> {
    private static final SdkField<Double> MIN_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinCapacity").getter(getter(ServerlessV2ScalingConfiguration::minCapacity))
            .setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(ServerlessV2ScalingConfiguration::maxCapacity))
            .setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double minCapacity;

    private final Double maxCapacity;

    private ServerlessV2ScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
    }

    /**
     * <p>
     * The minimum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You can
     * specify NCU values in half-step increments, such as 8, 8.5, 9, and so on.
     * </p>
     * 
     * @return The minimum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster.
     *         You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on.
     */
    public final Double minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You can
     * specify NCU values in half-step increments, such as 40, 40.5, 41, and so on.
     * </p>
     * 
     * @return The maximum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster.
     *         You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessV2ScalingConfiguration)) {
            return false;
        }
        ServerlessV2ScalingConfiguration other = (ServerlessV2ScalingConfiguration) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessV2ScalingConfiguration").add("MinCapacity", minCapacity())
                .add("MaxCapacity", maxCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessV2ScalingConfiguration, T> g) {
        return obj -> g.apply((ServerlessV2ScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessV2ScalingConfiguration> {
        /**
         * <p>
         * The minimum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You
         * can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on.
         * </p>
         * 
         * @param minCapacity
         *        The minimum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster.
         *        You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Double minCapacity);

        /**
         * <p>
         * The maximum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You
         * can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster.
         *        You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Double minCapacity;

        private Double maxCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessV2ScalingConfiguration model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
        }

        public final Double getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        @Override
        public ServerlessV2ScalingConfiguration build() {
            return new ServerlessV2ScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
