/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <a>DescribeDBClusters</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClustersResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeDbClustersResponse.Builder, DescribeDbClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDbClustersResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBCluster>> DB_CLUSTERS_FIELD = SdkField
            .<List<DBCluster>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDbClustersResponse::dbClusters))
            .setter(setter(Builder::dbClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBCluster")
                            .memberFieldInfo(
                                    SdkField.<DBCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBCluster").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_CLUSTERS_FIELD));

    private final String marker;

    private final List<DBCluster> dbClusters;

    private DescribeDbClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusters = builder.dbClusters;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent DescribeDBClusters request.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent DescribeDBClusters request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Contains a list of DB clusters for the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains a list of DB clusters for the user.
     */
    public List<DBCluster> dbClusters() {
        return dbClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClustersResponse)) {
            return false;
        }
        DescribeDbClustersResponse other = (DescribeDbClustersResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(dbClusters(), other.dbClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDbClustersResponse").add("Marker", marker()).add("DBClusters", dbClusters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBClusters":
            return Optional.ofNullable(clazz.cast(dbClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClustersResponse, T> g) {
        return obj -> g.apply((DescribeDbClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbClustersResponse> {
        /**
         * <p>
         * A pagination token that can be used in a subsequent DescribeDBClusters request.
         * </p>
         * 
         * @param marker
         *        A pagination token that can be used in a subsequent DescribeDBClusters request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Contains a list of DB clusters for the user.
         * </p>
         * 
         * @param dbClusters
         *        Contains a list of DB clusters for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusters(Collection<DBCluster> dbClusters);

        /**
         * <p>
         * Contains a list of DB clusters for the user.
         * </p>
         * 
         * @param dbClusters
         *        Contains a list of DB clusters for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusters(DBCluster... dbClusters);

        /**
         * <p>
         * Contains a list of DB clusters for the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBCluster>.Builder} avoiding the need to
         * create one manually via {@link List<DBCluster>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBCluster>.Builder#build()} is called immediately and its
         * result is passed to {@link #dbClusters(List<DBCluster>)}.
         * 
         * @param dbClusters
         *        a consumer that will call methods on {@link List<DBCluster>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusters(List<DBCluster>)
         */
        Builder dbClusters(Consumer<DBCluster.Builder>... dbClusters);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBCluster> dbClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClustersResponse model) {
            super(model);
            marker(model.marker);
            dbClusters(model.dbClusters);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBCluster.Builder> getDbClusters() {
            return dbClusters != null ? dbClusters.stream().map(DBCluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusters(Collection<DBCluster> dbClusters) {
            this.dbClusters = DBClusterListCopier.copy(dbClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusters(DBCluster... dbClusters) {
            dbClusters(Arrays.asList(dbClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusters(Consumer<DBCluster.Builder>... dbClusters) {
            dbClusters(Stream.of(dbClusters).map(c -> DBCluster.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusters(Collection<DBCluster.BuilderImpl> dbClusters) {
            this.dbClusters = DBClusterListCopier.copyFromBuilder(dbClusters);
        }

        @Override
        public DescribeDbClustersResponse build() {
            return new DescribeDbClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
