/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyEventSubscriptionRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyEventSubscriptionRequest.Builder, ModifyEventSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEventSubscriptionRequest::subscriptionName)).setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEventSubscriptionRequest::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEventSubscriptionRequest::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyEventSubscriptionRequest::eventCategories))
            .setter(setter(Builder::eventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyEventSubscriptionRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD,
            SNS_TOPIC_ARN_FIELD, SOURCE_TYPE_FIELD, EVENT_CATEGORIES_FIELD, ENABLED_FIELD));

    private final String subscriptionName;

    private final String snsTopicArn;

    private final String sourceType;

    private final List<String> eventCategories;

    private final Boolean enabled;

    private ModifyEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The name of the event notification subscription.
     * </p>
     * 
     * @return The name of the event notification subscription.
     */
    public String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS
     * when you create a topic and subscribe to it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
     *         Amazon SNS when you create a topic and subscribe to it.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The type of source that is generating the events. For example, if you want to be notified of events generated by
     * a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are
     * returned.
     * </p>
     * <p>
     * Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
     * </p>
     * 
     * @return The type of source that is generating the events. For example, if you want to be notified of events
     *         generated by a DB instance, you would set this parameter to db-instance. if this value is not specified,
     *         all events are returned.</p>
     *         <p>
     *         Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
     */
    public String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories
     * for a given SourceType by using the <b>DescribeEventCategories</b> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of event categories for a SourceType that you want to subscribe to. You can see a list of the
     *         categories for a given SourceType by using the <b>DescribeEventCategories</b> action.
     */
    public List<String> eventCategories() {
        return eventCategories;
    }

    /**
     * <p>
     * A Boolean value; set to <b>true</b> to activate the subscription.
     * </p>
     * 
     * @return A Boolean value; set to <b>true</b> to activate the subscription.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEventSubscriptionRequest)) {
            return false;
        }
        ModifyEventSubscriptionRequest other = (ModifyEventSubscriptionRequest) obj;
        return Objects.equals(subscriptionName(), other.subscriptionName()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(sourceType(), other.sourceType()) && Objects.equals(eventCategories(), other.eventCategories())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyEventSubscriptionRequest").add("SubscriptionName", subscriptionName())
                .add("SnsTopicArn", snsTopicArn()).add("SourceType", sourceType()).add("EventCategories", eventCategories())
                .add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "EventCategories":
            return Optional.ofNullable(clazz.cast(eventCategories()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEventSubscriptionRequest, T> g) {
        return obj -> g.apply((ModifyEventSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyEventSubscriptionRequest> {
        /**
         * <p>
         * The name of the event notification subscription.
         * </p>
         * 
         * @param subscriptionName
         *        The name of the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon
         * SNS when you create a topic and subscribe to it.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
         *        Amazon SNS when you create a topic and subscribe to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The type of source that is generating the events. For example, if you want to be notified of events generated
         * by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are
         * returned.
         * </p>
         * <p>
         * Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
         * </p>
         * 
         * @param sourceType
         *        The type of source that is generating the events. For example, if you want to be notified of events
         *        generated by a DB instance, you would set this parameter to db-instance. if this value is not
         *        specified, all events are returned.</p>
         *        <p>
         *        Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * A list of event categories for a SourceType that you want to subscribe to. You can see a list of the
         * categories for a given SourceType by using the <b>DescribeEventCategories</b> action.
         * </p>
         * 
         * @param eventCategories
         *        A list of event categories for a SourceType that you want to subscribe to. You can see a list of the
         *        categories for a given SourceType by using the <b>DescribeEventCategories</b> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(Collection<String> eventCategories);

        /**
         * <p>
         * A list of event categories for a SourceType that you want to subscribe to. You can see a list of the
         * categories for a given SourceType by using the <b>DescribeEventCategories</b> action.
         * </p>
         * 
         * @param eventCategories
         *        A list of event categories for a SourceType that you want to subscribe to. You can see a list of the
         *        categories for a given SourceType by using the <b>DescribeEventCategories</b> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(String... eventCategories);

        /**
         * <p>
         * A Boolean value; set to <b>true</b> to activate the subscription.
         * </p>
         * 
         * @param enabled
         *        A Boolean value; set to <b>true</b> to activate the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String subscriptionName;

        private String snsTopicArn;

        private String sourceType;

        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEventSubscriptionRequest model) {
            super(model);
            subscriptionName(model.subscriptionName);
            snsTopicArn(model.snsTopicArn);
            sourceType(model.sourceType);
            eventCategories(model.eventCategories);
            enabled(model.enabled);
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            return eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String... eventCategories) {
            eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEventSubscriptionRequest build() {
            return new ModifyEventSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
