/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <a>DescribeDBSubnetGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbSubnetGroupsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeDbSubnetGroupsResponse.Builder, DescribeDbSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDbSubnetGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBSubnetGroup>> DB_SUBNET_GROUPS_FIELD = SdkField
            .<List<DBSubnetGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDbSubnetGroupsResponse::dbSubnetGroups))
            .setter(setter(Builder::dbSubnetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSubnetGroup")
                            .memberFieldInfo(
                                    SdkField.<DBSubnetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSubnetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSubnetGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_SUBNET_GROUPS_FIELD));

    private final String marker;

    private final List<DBSubnetGroup> dbSubnetGroups;

    private DescribeDbSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSubnetGroups = builder.dbSubnetGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of <a>DBSubnetGroup</a> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>DBSubnetGroup</a> instances.
     */
    public List<DBSubnetGroup> dbSubnetGroups() {
        return dbSubnetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSubnetGroupsResponse)) {
            return false;
        }
        DescribeDbSubnetGroupsResponse other = (DescribeDbSubnetGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(dbSubnetGroups(), other.dbSubnetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDbSubnetGroupsResponse").add("Marker", marker()).add("DBSubnetGroups", dbSubnetGroups())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBSubnetGroups":
            return Optional.ofNullable(clazz.cast(dbSubnetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbSubnetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbSubnetGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>DBSubnetGroup</a> instances.
         * </p>
         * 
         * @param dbSubnetGroups
         *        A list of <a>DBSubnetGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups);

        /**
         * <p>
         * A list of <a>DBSubnetGroup</a> instances.
         * </p>
         * 
         * @param dbSubnetGroups
         *        A list of <a>DBSubnetGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroups(DBSubnetGroup... dbSubnetGroups);

        /**
         * <p>
         * A list of <a>DBSubnetGroup</a> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBSubnetGroup>.Builder} avoiding the need
         * to create one manually via {@link List<DBSubnetGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBSubnetGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbSubnetGroups(List<DBSubnetGroup>)}.
         * 
         * @param dbSubnetGroups
         *        a consumer that will call methods on {@link List<DBSubnetGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroups(List<DBSubnetGroup>)
         */
        Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder>... dbSubnetGroups);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBSubnetGroup> dbSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSubnetGroupsResponse model) {
            super(model);
            marker(model.marker);
            dbSubnetGroups(model.dbSubnetGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSubnetGroup.Builder> getDbSubnetGroups() {
            return dbSubnetGroups != null ? dbSubnetGroups.stream().map(DBSubnetGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copy(dbSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(DBSubnetGroup... dbSubnetGroups) {
            dbSubnetGroups(Arrays.asList(dbSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder>... dbSubnetGroups) {
            dbSubnetGroups(Stream.of(dbSubnetGroups).map(c -> DBSubnetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbSubnetGroups(Collection<DBSubnetGroup.BuilderImpl> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copyFromBuilder(dbSubnetGroups);
        }

        @Override
        public DescribeDbSubnetGroupsResponse build() {
            return new DescribeDbSubnetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
