/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <a>DescribeDBInstances</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbInstancesResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeDbInstancesResponse.Builder, DescribeDbInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDbInstancesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBInstance>> DB_INSTANCES_FIELD = SdkField
            .<List<DBInstance>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDbInstancesResponse::dbInstances))
            .setter(setter(Builder::dbInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBInstance")
                            .memberFieldInfo(
                                    SdkField.<DBInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBInstance").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_INSTANCES_FIELD));

    private final String marker;

    private final List<DBInstance> dbInstances;

    private DescribeDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbInstances = builder.dbInstances;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of <a>DBInstance</a> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>DBInstance</a> instances.
     */
    public List<DBInstance> dbInstances() {
        return dbInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbInstancesResponse)) {
            return false;
        }
        DescribeDbInstancesResponse other = (DescribeDbInstancesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(dbInstances(), other.dbInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDbInstancesResponse").add("Marker", marker()).add("DBInstances", dbInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBInstances":
            return Optional.ofNullable(clazz.cast(dbInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeDbInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbInstancesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>DBInstance</a> instances.
         * </p>
         * 
         * @param dbInstances
         *        A list of <a>DBInstance</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstances(Collection<DBInstance> dbInstances);

        /**
         * <p>
         * A list of <a>DBInstance</a> instances.
         * </p>
         * 
         * @param dbInstances
         *        A list of <a>DBInstance</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstances(DBInstance... dbInstances);

        /**
         * <p>
         * A list of <a>DBInstance</a> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBInstance>.Builder} avoiding the need to
         * create one manually via {@link List<DBInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBInstance>.Builder#build()} is called immediately and its
         * result is passed to {@link #dbInstances(List<DBInstance>)}.
         * 
         * @param dbInstances
         *        a consumer that will call methods on {@link List<DBInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbInstances(List<DBInstance>)
         */
        Builder dbInstances(Consumer<DBInstance.Builder>... dbInstances);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBInstance> dbInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbInstancesResponse model) {
            super(model);
            marker(model.marker);
            dbInstances(model.dbInstances);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBInstance.Builder> getDbInstances() {
            return dbInstances != null ? dbInstances.stream().map(DBInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbInstances(Collection<DBInstance> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copy(dbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(DBInstance... dbInstances) {
            dbInstances(Arrays.asList(dbInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(Consumer<DBInstance.Builder>... dbInstances) {
            dbInstances(Stream.of(dbInstances).map(c -> DBInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbInstances(Collection<DBInstance.BuilderImpl> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copyFromBuilder(dbInstances);
        }

        @Override
        public DescribeDbInstancesResponse build() {
            return new DescribeDbInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
