/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePendingMaintenanceActionsRequest extends NeptuneRequest implements
        ToCopyableBuilder<DescribePendingMaintenanceActionsRequest.Builder, DescribePendingMaintenanceActionsRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePendingMaintenanceActionsRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribePendingMaintenanceActionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePendingMaintenanceActionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePendingMaintenanceActionsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            FILTERS_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD));

    private final String resourceIdentifier;

    private final List<Filter> filters;

    private final String marker;

    private final Integer maxRecords;

    private DescribePendingMaintenanceActionsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The ARN of a resource to return pending maintenance actions for.
     * </p>
     * 
     * @return The ARN of a resource to return pending maintenance actions for.
     */
    public String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * A filter that specifies one or more resources to return pending maintenance actions for.
     * </p>
     * <p>
     * Supported filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The
     * results list will only include pending maintenance actions for the DB clusters identified by these ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will only
     * include pending maintenance actions for the DB instances identified by these ARNs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A filter that specifies one or more resources to return pending maintenance actions for.</p>
     *         <p>
     *         Supported filters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).
     *         The results list will only include pending maintenance actions for the DB clusters identified by these
     *         ARNs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will
     *         only include pending maintenance actions for the DB instances identified by these ARNs.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If
     * this parameter is specified, the response includes only records beyond the marker, up to a number of records
     * specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code>
     *         request. If this parameter is specified, the response includes only records beyond the marker, up to a
     *         number of records specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
     * remaining results can be retrieved.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
     *         remaining results can be retrieved. </p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsRequest)) {
            return false;
        }
        DescribePendingMaintenanceActionsRequest other = (DescribePendingMaintenanceActionsRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(filters(), other.filters())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePendingMaintenanceActionsRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("Filters", filters()).add("Marker", marker()).add("MaxRecords", maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePendingMaintenanceActionsRequest, T> g) {
        return obj -> g.apply((DescribePendingMaintenanceActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePendingMaintenanceActionsRequest> {
        /**
         * <p>
         * The ARN of a resource to return pending maintenance actions for.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN of a resource to return pending maintenance actions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * A filter that specifies one or more resources to return pending maintenance actions for.
         * </p>
         * <p>
         * Supported filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The
         * results list will only include pending maintenance actions for the DB clusters identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will
         * only include pending maintenance actions for the DB instances identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more resources to return pending maintenance actions for.</p>
         *        <p>
         *        Supported filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names
         *        (ARNs). The results list will only include pending maintenance actions for the DB clusters identified
         *        by these ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list
         *        will only include pending maintenance actions for the DB instances identified by these ARNs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter that specifies one or more resources to return pending maintenance actions for.
         * </p>
         * <p>
         * Supported filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The
         * results list will only include pending maintenance actions for the DB clusters identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will
         * only include pending maintenance actions for the DB instances identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more resources to return pending maintenance actions for.</p>
         *        <p>
         *        Supported filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names
         *        (ARNs). The results list will only include pending maintenance actions for the DB clusters identified
         *        by these ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list
         *        will only include pending maintenance actions for the DB instances identified by these ARNs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter that specifies one or more resources to return pending maintenance actions for.
         * </p>
         * <p>
         * Supported filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The
         * results list will only include pending maintenance actions for the DB clusters identified by these ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will
         * only include pending maintenance actions for the DB instances identified by these ARNs.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request.
         * If this parameter is specified, the response includes only records beyond the marker, up to a number of
         * records specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code>
         *        request. If this parameter is specified, the response includes only records beyond the marker, up to a
         *        number of records specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
         * remaining results can be retrieved.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        the remaining results can be retrieved. </p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            filters(model.filters);
            marker(model.marker);
            maxRecords(model.maxRecords);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePendingMaintenanceActionsRequest build() {
            return new DescribePendingMaintenanceActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
