/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.neptune.model.AddRoleToDBClusterResponse;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDBClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDBParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDBSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDBClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher;

/**
 * Service client for accessing Amazon Neptune asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Neptune</fullname>
 * <p>
 * </p>
 * <p>
 * Amazon Neptune is a fast, reliable, fully-managed graph database service that makes it easy to build and run
 * applications that work with highly connected datasets. The core of Amazon Neptune is a purpose-built,
 * high-performance graph database engine optimized for storing billions of relationships and querying the graph with
 * milliseconds latency. Amazon Neptune supports popular graph models Property Graph and W3C's RDF, and their respective
 * query languages Apache TinkerPop Gremlin and SPARQL, allowing you to easily build queries that efficiently navigate
 * highly connected datasets. Neptune powers graph use cases such as recommendation engines, fraud detection, knowledge
 * graphs, drug discovery, and network security.
 * </p>
 * <p>
 * This interface reference for Amazon Neptune contains documentation for a programming or command line interface you
 * can use to manage Amazon Neptune. Note that Amazon Neptune is asynchronous, which means that some interfaces might
 * require techniques such as polling or callback functions to determine when a command has been applied. In this
 * reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot,
 * or during the maintenance window. The reference structure is as follows, and we list following some related topics
 * from the user guide.
 * </p>
 * <p>
 * <b>Amazon Neptune API Reference</b>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface NeptuneAsyncClient extends SdkClient {
    String SERVICE_NAME = "rds";

    /**
     * Create a {@link NeptuneAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NeptuneAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptuneAsyncClient}.
     */
    static NeptuneAsyncClientBuilder builder() {
        return new DefaultNeptuneAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role from an Neptune DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddRoleToDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRoleToDBClusterResponse> addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role from an Neptune DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToDbClusterRequest.Builder} avoiding the
     * need to create one manually via {@link AddRoleToDbClusterRequest#builder()}
     * </p>
     *
     * @param addRoleToDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link AddRoleToDBClusterMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddRoleToDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRoleToDBClusterResponse> addRoleToDBCluster(
            Consumer<AddRoleToDbClusterRequest.Builder> addRoleToDbClusterRequest) {
        return addRoleToDBCluster(AddRoleToDbClusterRequest.builder().applyMutation(addRoleToDbClusterRequest).build());
    }

    /**
     * <p>
     * Adds a source identifier to an existing event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a source identifier to an existing event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddSourceIdentifierToSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link AddSourceIdentifierToSubscriptionRequest#builder()}
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link AddSourceIdentifierToSubscriptionMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            Consumer<AddSourceIdentifierToSubscriptionRequest.Builder> addSourceIdentifierToSubscriptionRequest) {
        return addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.builder()
                .applyMutation(addSourceIdentifierToSubscriptionRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to
     * track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon
     * Neptune.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to
     * track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon
     * Neptune.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceMessage.Builder} to create a request.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on {@link ApplyPendingMaintenanceActionMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest) {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CopyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            Consumer<CopyDbClusterParameterGroupRequest.Builder> copyDbClusterParameterGroupRequest) {
        return copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest.builder()
                .applyMutation(copyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another AWS Region. In that case, the AWS Region where you
     * call the <code>CopyDBClusterSnapshot</code> action is the destination AWS Region for the encrypted DB cluster
     * snapshot to be copied to. To copy an encrypted DB cluster snapshot from another AWS Region, you must provide the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The AWS Key Management System (AWS KMS) key identifier for the key to use to encrypt the
     * copy of the DB cluster snapshot in the destination AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PreSignedUrl</code> - A URL that contains a Signature Version 4 signed request for the
     * <code>CopyDBClusterSnapshot</code> action to be called in the source AWS Region where the DB cluster snapshot is
     * copied from. The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action
     * that can be executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied.
     * </p>
     * <p>
     * The pre-signed URL request must contain the following parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the copy of the DB cluster snapshot
     * in the destination AWS Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action
     * that is called in the destination AWS Region, and the action contained in the pre-signed URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationRegion</code> - The name of the AWS Region that the DB cluster snapshot will be created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS
     * Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 AWS Region, then your
     * <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example:
     * <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:neptune-cluster1-snapshot-20161115</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn how to generate a Signature Version 4 signed request, see <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests:
     * Using Query Parameters (AWS Signature Version 4)</a> and <a
     * href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing
     * Process</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source AWS Region and is the same value
     * as the <code>SourceDBClusterSnapshotIdentifier</code> in the pre-signed URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another AWS Region. In that case, the AWS Region where you
     * call the <code>CopyDBClusterSnapshot</code> action is the destination AWS Region for the encrypted DB cluster
     * snapshot to be copied to. To copy an encrypted DB cluster snapshot from another AWS Region, you must provide the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The AWS Key Management System (AWS KMS) key identifier for the key to use to encrypt the
     * copy of the DB cluster snapshot in the destination AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PreSignedUrl</code> - A URL that contains a Signature Version 4 signed request for the
     * <code>CopyDBClusterSnapshot</code> action to be called in the source AWS Region where the DB cluster snapshot is
     * copied from. The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action
     * that can be executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied.
     * </p>
     * <p>
     * The pre-signed URL request must contain the following parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the copy of the DB cluster snapshot
     * in the destination AWS Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action
     * that is called in the destination AWS Region, and the action contained in the pre-signed URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationRegion</code> - The name of the AWS Region that the DB cluster snapshot will be created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS
     * Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 AWS Region, then your
     * <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example:
     * <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:neptune-cluster1-snapshot-20161115</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn how to generate a Signature Version 4 signed request, see <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests:
     * Using Query Parameters (AWS Signature Version 4)</a> and <a
     * href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing
     * Process</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source AWS Region and is the same value
     * as the <code>SourceDBClusterSnapshotIdentifier</code> in the pre-signed URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            Consumer<CopyDbClusterSnapshotRequest.Builder> copyDbClusterSnapshotRequest) {
        return copyDBClusterSnapshot(CopyDbClusterSnapshotRequest.builder().applyMutation(copyDbClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     *
     * @param copyDbParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            CopyDbParameterGroupRequest copyDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            Consumer<CopyDbParameterGroupRequest.Builder> copyDbParameterGroupRequest) {
        return copyDBParameterGroup(CopyDbParameterGroupRequest.builder().applyMutation(copyDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Neptune DB cluster.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of
     * another DB cluster or Amazon Neptune DB instance. For cross-region replication where the DB cluster identified by
     * <code>ReplicationSourceIdentifier</code> is encrypted, you must also specify the <code>PreSignedUrl</code>
     * parameter.
     * </p>
     *
     * @param createDbClusterRequest
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Neptune DB cluster.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of
     * another DB cluster or Amazon Neptune DB instance. For cross-region replication where the DB cluster identified by
     * <code>ReplicationSourceIdentifier</code> is encrypted, you must also specify the <code>PreSignedUrl</code>
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbClusterRequest#builder()}
     * </p>
     *
     * @param createDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbClusterResponse> createDBCluster(
            Consumer<CreateDbClusterRequest.Builder> createDbClusterRequest) {
        return createDBCluster(CreateDbClusterRequest.builder().applyMutation(createDbClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <a>ModifyDBClusterParameterGroup</a>. Once you've created a DB cluster parameter group, you
     * need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster
     * parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover
     * for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the DB cluster parameter group is used as the default for a new DB
     * cluster. This is especially important for parameters that are critical when creating the default database for a
     * DB cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <a>DescribeDBClusterParameters</a>
     * command to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <a>ModifyDBClusterParameterGroup</a>. Once you've created a DB cluster parameter group, you
     * need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster
     * parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover
     * for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the DB cluster parameter group is used as the default for a new DB
     * cluster. This is especially important for parameters that are critical when creating the default database for a
     * DB cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <a>DescribeDBClusterParameters</a>
     * command to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterParameterGroupMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            Consumer<CreateDbClusterParameterGroupRequest.Builder> createDbClusterParameterGroupRequest) {
        return createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest.builder()
                .applyMutation(createDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            Consumer<CreateDbClusterSnapshotRequest.Builder> createDbClusterSnapshotRequest) {
        return createDBClusterSnapshot(CreateDbClusterSnapshotRequest.builder().applyMutation(createDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>InstanceQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         instances.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbInstanceRequest#builder()}
     * </p>
     *
     * @param createDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBInstanceMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>InstanceQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         instances.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceResponse> createDBInstance(
            Consumer<CreateDbInstanceRequest.Builder> createDbInstanceRequest) {
        return createDBInstance(CreateDbInstanceRequest.builder().applyMutation(createDbInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <i>ModifyDBParameterGroup</i>. Once you've created a DB parameter group, you need to associate it with your DB
     * instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance,
     * you need to reboot the DB instance without failover for the new DB parameter group and associated settings to
     * take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <i>ModifyDBParameterGroup</i>. Once you've created a DB parameter group, you need to associate it with your DB
     * instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance,
     * you need to reboot the DB instance without failover for the new DB parameter group and associated settings to
     * take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            Consumer<CreateDbParameterGroupRequest.Builder> createDbParameterGroupRequest) {
        return createDBParameterGroup(CreateDbParameterGroupRequest.builder().applyMutation(createDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the AWS
     * Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <i>DBSubnetGroupName</i> is already used by an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the AWS
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBSubnetGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <i>DBSubnetGroupName</i> is already used by an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            Consumer<CreateDbSubnetGroupRequest.Builder> createDbSubnetGroupRequest) {
        return createDBSubnetGroup(CreateDbSubnetGroupRequest.builder().applyMutation(createDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by
     * either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic
     * in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources
     * (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you
     * want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
     * mydbinstance2 and EventCategories = Availability, Backup.
     * </p>
     * <p>
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier =
     * myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a
     * SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all
     * your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of
     * events generated from all Neptune sources belonging to your customer account.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException</li>
     *         <li>SubscriptionAlreadyExistException</li>
     *         <li>SnsInvalidTopicException</li>
     *         <li>SnsNoAuthorizationException</li>
     *         <li>SnsTopicArnNotFoundException</li>
     *         <li>SubscriptionCategoryNotFoundException</li>
     *         <li>SourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by
     * either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic
     * in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources
     * (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you
     * want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
     * mydbinstance2 and EventCategories = Availability, Backup.
     * </p>
     * <p>
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier =
     * myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a
     * SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all
     * your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of
     * events generated from all Neptune sources belonging to your customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException</li>
     *         <li>SubscriptionAlreadyExistException</li>
     *         <li>SnsInvalidTopicException</li>
     *         <li>SnsNoAuthorizationException</li>
     *         <li>SnsTopicArnNotFoundException</li>
     *         <li>SubscriptionCategoryNotFoundException</li>
     *         <li>SourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest) {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p/>
     *
     * @param deleteDbClusterRequest
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li> <li>
     *         DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given identifier.
     *         </li> <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li> <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster
     *         snapshot state.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     *         </li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbClusterRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(
            Consumer<DeleteDbClusterRequest.Builder> deleteDbClusterRequest) {
        return deleteDBCluster(DeleteDbClusterRequest.builder().applyMutation(deleteDbClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDBClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterParameterGroupMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDBClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            Consumer<DeleteDbClusterParameterGroupRequest.Builder> deleteDbClusterParameterGroupRequest) {
        return deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest.builder()
                .applyMutation(deleteDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            Consumer<DeleteDbClusterSnapshotRequest.Builder> deleteDbClusterSnapshotRequest) {
        return deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest.builder().applyMutation(deleteDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until
     * the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * Note that when a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the
     * <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.
     * </p>
     * <p>
     * If the specified DB instance is part of a DB cluster, you can't delete the DB instance if both of the following
     * conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a Read Replica of another DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first call the <a>PromoteReadReplicaDBCluster</a> API action to promote the
     * DB cluster so it's no longer a Read Replica. After the promotion completes, then call the
     * <code>DeleteDBInstance</code> API action to delete the final instance in the DB cluster.
     * </p>
     *
     * @param deleteDbInstanceRequest
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbSnapshotAlreadyExistsException <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.
     *         </li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until
     * the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * Note that when a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the
     * <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.
     * </p>
     * <p>
     * If the specified DB instance is part of a DB cluster, you can't delete the DB instance if both of the following
     * conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a Read Replica of another DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first call the <a>PromoteReadReplicaDBCluster</a> API action to promote the
     * DB cluster so it's no longer a Read Replica. After the promotion completes, then call the
     * <code>DeleteDBInstance</code> API action to delete the final instance in the DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbInstanceRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBInstanceMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbSnapshotAlreadyExistsException <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.
     *         </li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(
            Consumer<DeleteDbInstanceRequest.Builder> deleteDbInstanceRequest) {
        return deleteDBInstance(DeleteDbInstanceRequest.builder().applyMutation(deleteDbInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDBParameterGroupResponse> deleteDBParameterGroup(
            DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB
     * instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDBParameterGroupResponse> deleteDBParameterGroup(
            Consumer<DeleteDbParameterGroupRequest.Builder> deleteDbParameterGroupRequest) {
        return deleteDBParameterGroup(DeleteDbParameterGroupRequest.builder().applyMutation(deleteDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet is not in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDBSubnetGroupResponse> deleteDBSubnetGroup(
            DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBSubnetGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet is not in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDBSubnetGroupResponse> deleteDBSubnetGroup(
            Consumer<DeleteDbSubnetGroupRequest.Builder> deleteDbSubnetGroupRequest) {
        return deleteDBSubnetGroup(DeleteDbSubnetGroupRequest.builder().applyMutation(deleteDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>InvalidEventSubscriptionStateException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>InvalidEventSubscriptionStateException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest) {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups() {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParametersMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest) {
        return describeDBClusterParameters(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other AWS accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the
     * manual DB cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code>
     * attribute, then the manual DB cluster snapshot is public and can be copied or restored by all AWS accounts.
     * </p>
     * <p>
     * To add or remove access for an AWS account to copy or restore a manual DB cluster snapshot, or to make the manual
     * DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other AWS accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the
     * manual DB cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code>
     * attribute, then the manual DB cluster snapshot is public and can be copied or restored by all AWS accounts.
     * </p>
     * <p>
     * To add or remove access for an AWS account to copy or restore a manual DB cluster snapshot, or to make the manual
     * DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotAttributesMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            Consumer<DescribeDbClusterSnapshotAttributesRequest.Builder> describeDbClusterSnapshotAttributesRequest) {
        return describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.builder()
                .applyMutation(describeDbClusterSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest) {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots() {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters. This API supports pagination.
     * </p>
     *
     * @param describeDbClustersRequest
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClustersMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) {
        return describeDBClusters(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters. This API supports pagination.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters() {
        return describeDBClusters(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBEngineVersionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().applyMutation(describeDbEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions() {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator() {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBEngineVersionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder()
                .applyMutation(describeDbEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned instances. This API supports pagination.
     * </p>
     *
     * @param describeDbInstancesRequest
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            DescribeDbInstancesRequest describeDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstancesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return describeDBInstances(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned instances. This API supports pagination.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances() {
        return describeDBInstances(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator() {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstancesMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParameterGroupsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest) {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups() {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator() {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParameterGroupsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest) {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            DescribeDbParametersRequest describeDbParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParametersMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) {
        return describeDBParameters(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParametersPublisher describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParametersMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParametersPublisher describeDBParametersPaginator(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) {
        return describeDBParametersPaginator(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSubnetGroupsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().applyMutation(describeDbSubnetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups() {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator() {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSubnetGroupsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder()
                .applyMutation(describeDbSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEngineDefaultClusterParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEngineDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultClusterParametersMessage.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            Consumer<DescribeEngineDefaultClusterParametersRequest.Builder> describeEngineDefaultClusterParametersRequest) {
        return describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.builder()
                .applyMutation(describeEngineDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultParametersMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultParametersMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventCategoriesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories() {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions() {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator() {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableDBInstanceOptionsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest) {
        return describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableDBInstanceOptionsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest) {
        return describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingMaintenanceActionsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions() {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * You can call <a>DescribeValidDBInstanceModifications</a> to learn what modifications you can make to your DB
     * instance. You can use this information when you call <a>ModifyDBInstance</a>.
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     * @return A Java Future containing the result of the DescribeValidDBInstanceModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeValidDBInstanceModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeValidDbInstanceModificationsResponse> describeValidDBInstanceModifications(
            DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can call <a>DescribeValidDBInstanceModifications</a> to learn what modifications you can make to your DB
     * instance. You can use this information when you call <a>ModifyDBInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeValidDbInstanceModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeValidDbInstanceModificationsRequest#builder()}
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeValidDBInstanceModificationsMessage.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeValidDBInstanceModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeValidDBInstanceModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeValidDbInstanceModificationsResponse> describeValidDBInstanceModifications(
            Consumer<DescribeValidDbInstanceModificationsRequest.Builder> describeValidDbInstanceModificationsRequest) {
        return describeValidDBInstanceModifications(DescribeValidDbInstanceModificationsRequest.builder()
                .applyMutation(describeValidDbInstanceModificationsRequest).build());
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the
     * primary instance (the cluster writer).
     * </p>
     * <p>
     * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails.
     * You can force a failover when you want to simulate a failure of a primary instance for testing. Because each
     * instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * </p>
     *
     * @param failoverDbClusterRequest
     * @return A Java Future containing the result of the FailoverDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.FailoverDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the
     * primary instance (the cluster writer).
     * </p>
     * <p>
     * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails.
     * You can force a failover when you want to simulate a failure of a primary instance for testing. Because each
     * instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link FailoverDbClusterRequest#builder()}
     * </p>
     *
     * @param failoverDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link FailoverDBClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the FailoverDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.FailoverDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(
            Consumer<FailoverDbClusterRequest.Builder> failoverDbClusterRequest) {
        return failoverDBCluster(FailoverDbClusterRequest.builder().applyMutation(failoverDbClusterRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an Amazon Neptune resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an Amazon Neptune resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbClusterRequest
     * @return A Java Future containing the result of the ModifyDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbClusterRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(
            Consumer<ModifyDbClusterRequest.Builder> modifyDbClusterRequest) {
        return modifyDBCluster(ModifyDbClusterRequest.builder().applyMutation(modifyDbClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB cluster associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the
     * <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or
     * modified.
     * </p>
     * </important>
     *
     * @param modifyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the ModifyDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB cluster associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the
     * <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or
     * modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterParameterGroupMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(
            Consumer<ModifyDbClusterParameterGroupRequest.Builder> modifyDbClusterParameterGroupRequest) {
        return modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest.builder()
                .applyMutation(modifyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other AWS accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the AWS
     * accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make
     * the manual DB cluster snapshot public, which means that it can be copied or restored by all AWS accounts. Do not
     * add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you
     * don't want available to all AWS accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but
     * only by specifying a list of authorized AWS account IDs for the <code>ValuesToAdd</code> parameter. You can't use
     * <code>all</code> as a value for that parameter in this case.
     * </p>
     * <p>
     * To view which AWS accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB
     * cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     * @return A Java Future containing the result of the ModifyDBClusterSnapshotAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other AWS accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the AWS
     * accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make
     * the manual DB cluster snapshot public, which means that it can be copied or restored by all AWS accounts. Do not
     * add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you
     * don't want available to all AWS accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but
     * only by specifying a list of authorized AWS account IDs for the <code>ValuesToAdd</code> parameter. You can't use
     * <code>all</code> as a value for that parameter in this case.
     * </p>
     * <p>
     * To view which AWS accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB
     * cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterSnapshotAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterSnapshotAttributeRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterSnapshotAttributeMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyDBClusterSnapshotAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(
            Consumer<ModifyDbClusterSnapshotAttributeRequest.Builder> modifyDbClusterSnapshotAttributeRequest) {
        return modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.builder()
                .applyMutation(modifyDbClusterSnapshotAttributeRequest).build());
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.
     * </p>
     *
     * @param modifyDbInstanceRequest
     * @return A Java Future containing the result of the ModifyDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>DbUpgradeDependencyFailureException The DB upgrade failed because a resource the DB depends on could
     *         not be modified.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>CertificateNotFoundException <i>CertificateIdentifier</i> does not refer to an existing certificate.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbInstanceRequest#builder()}
     * </p>
     *
     * @param modifyDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBInstanceMessage.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>DbUpgradeDependencyFailureException The DB upgrade failed because a resource the DB depends on could
     *         not be modified.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>CertificateNotFoundException <i>CertificateIdentifier</i> does not refer to an existing certificate.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(
            Consumer<ModifyDbInstanceRequest.Builder> modifyDbInstanceRequest) {
        return modifyDBInstance(ModifyDbInstanceRequest.builder().applyMutation(modifyDbInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB instance associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param modifyDbParameterGroupRequest
     * @return A Java Future containing the result of the ModifyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDbParameterGroupResponse> modifyDBParameterGroup(
            ModifyDbParameterGroupRequest modifyDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB instance associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDbParameterGroupResponse> modifyDBParameterGroup(
            Consumer<ModifyDbParameterGroupRequest.Builder> modifyDbParameterGroupRequest) {
        return modifyDBParameterGroup(ModifyDbParameterGroupRequest.builder().applyMutation(modifyDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the AWS Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     * @return A Java Future containing the result of the ModifyDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>SubnetAlreadyInUseException The DB subnet is already in use in the Availability Zone.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(
            ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBSubnetGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>SubnetAlreadyInUseException The DB subnet is already in use in the Availability Zone.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(
            Consumer<ModifyDbSubnetGroupRequest.Builder> modifyDbSubnetGroupRequest) {
        return modifyDBSubnetGroup(ModifyDbSubnetGroupRequest.builder().applyMutation(modifyDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using
     * this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and
     * <a>RemoveSourceIdentifierFromSubscription</a> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b>
     * action.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException</li>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SnsInvalidTopicException</li>
     *         <li>SnsNoAuthorizationException</li>
     *         <li>SnsTopicArnNotFoundException</li>
     *         <li>SubscriptionCategoryNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using
     * this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and
     * <a>RemoveSourceIdentifierFromSubscription</a> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b>
     * action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException</li>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SnsInvalidTopicException</li>
     *         <li>SnsNoAuthorizationException</li>
     *         <li>SnsTopicArnNotFoundException</li>
     *         <li>SubscriptionCategoryNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            Consumer<ModifyEventSubscriptionRequest.Builder> modifyEventSubscriptionRequest) {
        return modifyEventSubscription(ModifyEventSubscriptionRequest.builder().applyMutation(modifyEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Promotes a Read Replica DB cluster to a standalone DB cluster.
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     * @return A Java Future containing the result of the PromoteReadReplicaDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.PromoteReadReplicaDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PromoteReadReplicaDbClusterResponse> promoteReadReplicaDBCluster(
            PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Promotes a Read Replica DB cluster to a standalone DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PromoteReadReplicaDbClusterRequest.Builder}
     * avoiding the need to create one manually via {@link PromoteReadReplicaDbClusterRequest#builder()}
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link PromoteReadReplicaDBClusterMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PromoteReadReplicaDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.PromoteReadReplicaDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PromoteReadReplicaDbClusterResponse> promoteReadReplicaDBCluster(
            Consumer<PromoteReadReplicaDbClusterRequest.Builder> promoteReadReplicaDbClusterRequest) {
        return promoteReadReplicaDBCluster(PromoteReadReplicaDbClusterRequest.builder()
                .applyMutation(promoteReadReplicaDbClusterRequest).build());
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     *
     * @param rebootDbInstanceRequest
     * @return A Java Future containing the result of the RebootDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RebootDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link RebootDbInstanceRequest#builder()}
     * </p>
     *
     * @param rebootDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RebootDBInstanceMessage.Builder} to create a request.
     * @return A Java Future containing the result of the RebootDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RebootDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(
            Consumer<RebootDbInstanceRequest.Builder> rebootDbInstanceRequest) {
        return rebootDBInstance(RebootDbInstanceRequest.builder().applyMutation(rebootDbInstanceRequest).build());
    }

    /**
     * <p>
     * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     * @return A Java Future containing the result of the RemoveRoleFromDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleNotFoundException The specified IAM role Amazon Resource Name (ARN) is not associated
     *         with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveRoleFromDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveRoleFromDBClusterResponse> removeRoleFromDBCluster(
            RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveRoleFromDbClusterRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveRoleFromDbClusterRequest#builder()}
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link RemoveRoleFromDBClusterMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveRoleFromDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleNotFoundException The specified IAM role Amazon Resource Name (ARN) is not associated
     *         with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveRoleFromDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveRoleFromDBClusterResponse> removeRoleFromDBCluster(
            Consumer<RemoveRoleFromDbClusterRequest.Builder> removeRoleFromDbClusterRequest) {
        return removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest.builder().applyMutation(removeRoleFromDbClusterRequest)
                .build());
    }

    /**
     * <p>
     * Removes a source identifier from an existing event notification subscription.
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     * @return A Java Future containing the result of the RemoveSourceIdentifierFromSubscription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> removeSourceIdentifierFromSubscription(
            RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a source identifier from an existing event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RemoveSourceIdentifierFromSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link RemoveSourceIdentifierFromSubscriptionRequest#builder()}
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveSourceIdentifierFromSubscriptionMessage.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RemoveSourceIdentifierFromSubscription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException</li>
     *         <li>SourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> removeSourceIdentifierFromSubscription(
            Consumer<RemoveSourceIdentifierFromSubscriptionRequest.Builder> removeSourceIdentifierFromSubscriptionRequest) {
        return removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.builder()
                .applyMutation(removeSourceIdentifierFromSubscriptionRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon Neptune resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon Neptune resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromResourceMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request.
     * You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static
     * parameter to apply to.
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the ResetDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request.
     * You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static
     * parameter to apply to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ResetDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetDBClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ResetDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(
            Consumer<ResetDbClusterParameterGroupRequest.Builder> resetDbClusterParameterGroupRequest) {
        return resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest.builder()
                .applyMutation(resetDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     *
     * @param resetDbParameterGroupRequest
     * @return A Java Future containing the result of the ResetDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetDbParameterGroupResponse> resetDBParameterGroup(
            ResetDbParameterGroupRequest resetDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ResetDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetDbParameterGroupResponse> resetDBParameterGroup(
            Consumer<ResetDbParameterGroupRequest.Builder> resetDbParameterGroupRequest) {
        return resetDBParameterGroup(ResetDbParameterGroupRequest.builder().applyMutation(resetDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point
     * with the same configuration as the original source DB cluster, except that the new DB cluster is created with the
     * default security group.
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreDBClusterFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point
     * with the same configuration as the original source DB cluster, except that the new DB cluster is created with the
     * default security group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDbClusterFromSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreDbClusterFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link RestoreDBClusterFromSnapshotMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RestoreDBClusterFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(
            Consumer<RestoreDbClusterFromSnapshotRequest.Builder> restoreDbClusterFromSnapshotRequest) {
        return restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.builder()
                .applyMutation(restoreDbClusterFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <a>CreateDBInstance</a> action to create DB instances for the restored DB cluster, specifying the identifier of
     * the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the
     * <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.
     * </p>
     * </note>
     *
     * @param restoreDbClusterToPointInTimeRequest
     * @return A Java Future containing the result of the RestoreDBClusterToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <a>CreateDBInstance</a> action to create DB instances for the restored DB cluster, specifying the identifier of
     * the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the
     * <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDbClusterToPointInTimeRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreDbClusterToPointInTimeRequest#builder()}
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     *        A {@link Consumer} that will call methods on {@link RestoreDBClusterToPointInTimeMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreDBClusterToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>OptionGroupNotFoundException</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(
            Consumer<RestoreDbClusterToPointInTimeRequest.Builder> restoreDbClusterToPointInTimeRequest) {
        return restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.builder()
                .applyMutation(restoreDbClusterToPointInTimeRequest).build());
    }
}
