/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of the log types whose configuration is still pending. In other words, these log types are in the process of
 * being activated or deactivated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingCloudwatchLogsExports implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingCloudwatchLogsExports.Builder, PendingCloudwatchLogsExports> {
    private static final SdkField<List<String>> LOG_TYPES_TO_ENABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PendingCloudwatchLogsExports::logTypesToEnable))
            .setter(setter(Builder::logTypesToEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToEnable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOG_TYPES_TO_DISABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PendingCloudwatchLogsExports::logTypesToDisable))
            .setter(setter(Builder::logTypesToDisable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToDisable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPES_TO_ENABLE_FIELD,
            LOG_TYPES_TO_DISABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> logTypesToEnable;

    private final List<String> logTypesToDisable;

    private PendingCloudwatchLogsExports(BuilderImpl builder) {
        this.logTypesToEnable = builder.logTypesToEnable;
        this.logTypesToDisable = builder.logTypesToDisable;
    }

    /**
     * <p>
     * Log types that are in the process of being deactivated. After they are deactivated, these log types aren't
     * exported to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Log types that are in the process of being deactivated. After they are deactivated, these log types
     *         aren't exported to CloudWatch Logs.
     */
    public List<String> logTypesToEnable() {
        return logTypesToEnable;
    }

    /**
     * <p>
     * Log types that are in the process of being enabled. After they are enabled, these log types are exported to
     * CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Log types that are in the process of being enabled. After they are enabled, these log types are exported
     *         to CloudWatch Logs.
     */
    public List<String> logTypesToDisable() {
        return logTypesToDisable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTypesToEnable());
        hashCode = 31 * hashCode + Objects.hashCode(logTypesToDisable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingCloudwatchLogsExports)) {
            return false;
        }
        PendingCloudwatchLogsExports other = (PendingCloudwatchLogsExports) obj;
        return Objects.equals(logTypesToEnable(), other.logTypesToEnable())
                && Objects.equals(logTypesToDisable(), other.logTypesToDisable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PendingCloudwatchLogsExports").add("LogTypesToEnable", logTypesToEnable())
                .add("LogTypesToDisable", logTypesToDisable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogTypesToEnable":
            return Optional.ofNullable(clazz.cast(logTypesToEnable()));
        case "LogTypesToDisable":
            return Optional.ofNullable(clazz.cast(logTypesToDisable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingCloudwatchLogsExports, T> g) {
        return obj -> g.apply((PendingCloudwatchLogsExports) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingCloudwatchLogsExports> {
        /**
         * <p>
         * Log types that are in the process of being deactivated. After they are deactivated, these log types aren't
         * exported to CloudWatch Logs.
         * </p>
         * 
         * @param logTypesToEnable
         *        Log types that are in the process of being deactivated. After they are deactivated, these log types
         *        aren't exported to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToEnable(Collection<String> logTypesToEnable);

        /**
         * <p>
         * Log types that are in the process of being deactivated. After they are deactivated, these log types aren't
         * exported to CloudWatch Logs.
         * </p>
         * 
         * @param logTypesToEnable
         *        Log types that are in the process of being deactivated. After they are deactivated, these log types
         *        aren't exported to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToEnable(String... logTypesToEnable);

        /**
         * <p>
         * Log types that are in the process of being enabled. After they are enabled, these log types are exported to
         * CloudWatch Logs.
         * </p>
         * 
         * @param logTypesToDisable
         *        Log types that are in the process of being enabled. After they are enabled, these log types are
         *        exported to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToDisable(Collection<String> logTypesToDisable);

        /**
         * <p>
         * Log types that are in the process of being enabled. After they are enabled, these log types are exported to
         * CloudWatch Logs.
         * </p>
         * 
         * @param logTypesToDisable
         *        Log types that are in the process of being enabled. After they are enabled, these log types are
         *        exported to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToDisable(String... logTypesToDisable);
    }

    static final class BuilderImpl implements Builder {
        private List<String> logTypesToEnable = DefaultSdkAutoConstructList.getInstance();

        private List<String> logTypesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PendingCloudwatchLogsExports model) {
            logTypesToEnable(model.logTypesToEnable);
            logTypesToDisable(model.logTypesToDisable);
        }

        public final Collection<String> getLogTypesToEnable() {
            return logTypesToEnable;
        }

        @Override
        public final Builder logTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToEnable(String... logTypesToEnable) {
            logTypesToEnable(Arrays.asList(logTypesToEnable));
            return this;
        }

        public final void setLogTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
        }

        public final Collection<String> getLogTypesToDisable() {
            return logTypesToDisable;
        }

        @Override
        public final Builder logTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToDisable(String... logTypesToDisable) {
            logTypesToDisable(Arrays.asList(logTypesToDisable));
            return this;
        }

        public final void setLogTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
        }

        @Override
        public PendingCloudwatchLogsExports build() {
            return new PendingCloudwatchLogsExports(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
