/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetDbParameterGroupResponse extends NeptuneResponse implements
        ToCopyableBuilder<ResetDbParameterGroupResponse.Builder, ResetDbParameterGroupResponse> {
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetDbParameterGroupResponse::dbParameterGroupName)).setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DB_PARAMETER_GROUP_NAME_FIELD));

    private final String dbParameterGroupName;

    private ResetDbParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbParameterGroupName = builder.dbParameterGroupName;
    }

    /**
     * <p>
     * Provides the name of the DB parameter group.
     * </p>
     * 
     * @return Provides the name of the DB parameter group.
     */
    public String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDbParameterGroupResponse)) {
            return false;
        }
        ResetDbParameterGroupResponse other = (ResetDbParameterGroupResponse) obj;
        return Objects.equals(dbParameterGroupName(), other.dbParameterGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResetDbParameterGroupResponse").add("DBParameterGroupName", dbParameterGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetDbParameterGroupResponse, T> g) {
        return obj -> g.apply((ResetDbParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResetDbParameterGroupResponse> {
        /**
         * <p>
         * Provides the name of the DB parameter group.
         * </p>
         * 
         * @param dbParameterGroupName
         *        Provides the name of the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String dbParameterGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDbParameterGroupResponse model) {
            super(model);
            dbParameterGroupName(model.dbParameterGroupName);
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public ResetDbParameterGroupResponse build() {
            return new ResetDbParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
