/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameter implements SdkPojo, Serializable, ToCopyableBuilder<Parameter.Builder, Parameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::parameterValue)).setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> APPLY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::applyType)).setter(setter(Builder::applyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyType").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()).build();

    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::allowedValues)).setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()).build();

    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Parameter::isModifiable)).setter(setter(Builder::isModifiable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()).build();

    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::minimumEngineVersion)).setter(setter(Builder::minimumEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build())
            .build();

    private static final SdkField<String> APPLY_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::applyMethodAsString)).setter(setter(Builder::applyMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_VALUE_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD, APPLY_TYPE_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD,
            IS_MODIFIABLE_FIELD, MINIMUM_ENGINE_VERSION_FIELD, APPLY_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterValue;

    private final String description;

    private final String source;

    private final String applyType;

    private final String dataType;

    private final String allowedValues;

    private final Boolean isModifiable;

    private final String minimumEngineVersion;

    private final String applyMethod;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
        this.description = builder.description;
        this.source = builder.source;
        this.applyType = builder.applyType;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.applyMethod = builder.applyMethod;
    }

    /**
     * <p>
     * Specifies the name of the parameter.
     * </p>
     * 
     * @return Specifies the name of the parameter.
     */
    public String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * Specifies the value of the parameter.
     * </p>
     * 
     * @return Specifies the value of the parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    /**
     * <p>
     * Provides a description of the parameter.
     * </p>
     * 
     * @return Provides a description of the parameter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Indicates the source of the parameter value.
     * </p>
     * 
     * @return Indicates the source of the parameter value.
     */
    public String source() {
        return source;
    }

    /**
     * <p>
     * Specifies the engine specific parameters type.
     * </p>
     * 
     * @return Specifies the engine specific parameters type.
     */
    public String applyType() {
        return applyType;
    }

    /**
     * <p>
     * Specifies the valid data type for the parameter.
     * </p>
     * 
     * @return Specifies the valid data type for the parameter.
     */
    public String dataType() {
        return dataType;
    }

    /**
     * <p>
     * Specifies the valid range of values for the parameter.
     * </p>
     * 
     * @return Specifies the valid range of values for the parameter.
     */
    public String allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters
     * have security or operational implications that prevent them from being changed.
     * </p>
     * 
     * @return Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some
     *         parameters have security or operational implications that prevent them from being changed.
     */
    public Boolean isModifiable() {
        return isModifiable;
    }

    /**
     * <p>
     * The earliest engine version to which the parameter can apply.
     * </p>
     * 
     * @return The earliest engine version to which the parameter can apply.
     */
    public String minimumEngineVersion() {
        return minimumEngineVersion;
    }

    /**
     * <p>
     * Indicates when to apply parameter updates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyMethod} will
     * return {@link ApplyMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #applyMethodAsString}.
     * </p>
     * 
     * @return Indicates when to apply parameter updates.
     * @see ApplyMethod
     */
    public ApplyMethod applyMethod() {
        return ApplyMethod.fromValue(applyMethod);
    }

    /**
     * <p>
     * Indicates when to apply parameter updates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyMethod} will
     * return {@link ApplyMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #applyMethodAsString}.
     * </p>
     * 
     * @return Indicates when to apply parameter updates.
     * @see ApplyMethod
     */
    public String applyMethodAsString() {
        return applyMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(applyType());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(applyMethodAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter) obj;
        return Objects.equals(parameterName(), other.parameterName()) && Objects.equals(parameterValue(), other.parameterValue())
                && Objects.equals(description(), other.description()) && Objects.equals(source(), other.source())
                && Objects.equals(applyType(), other.applyType()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(allowedValues(), other.allowedValues()) && Objects.equals(isModifiable(), other.isModifiable())
                && Objects.equals(minimumEngineVersion(), other.minimumEngineVersion())
                && Objects.equals(applyMethodAsString(), other.applyMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Parameter").add("ParameterName", parameterName()).add("ParameterValue", parameterValue())
                .add("Description", description()).add("Source", source()).add("ApplyType", applyType())
                .add("DataType", dataType()).add("AllowedValues", allowedValues()).add("IsModifiable", isModifiable())
                .add("MinimumEngineVersion", minimumEngineVersion()).add("ApplyMethod", applyMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ApplyType":
            return Optional.ofNullable(clazz.cast(applyType()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "IsModifiable":
            return Optional.ofNullable(clazz.cast(isModifiable()));
        case "MinimumEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumEngineVersion()));
        case "ApplyMethod":
            return Optional.ofNullable(clazz.cast(applyMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameter> {
        /**
         * <p>
         * Specifies the name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        Specifies the name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * Specifies the value of the parameter.
         * </p>
         * 
         * @param parameterValue
         *        Specifies the value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);

        /**
         * <p>
         * Provides a description of the parameter.
         * </p>
         * 
         * @param description
         *        Provides a description of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates the source of the parameter value.
         * </p>
         * 
         * @param source
         *        Indicates the source of the parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Specifies the engine specific parameters type.
         * </p>
         * 
         * @param applyType
         *        Specifies the engine specific parameters type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyType(String applyType);

        /**
         * <p>
         * Specifies the valid data type for the parameter.
         * </p>
         * 
         * @param dataType
         *        Specifies the valid data type for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * Specifies the valid range of values for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        Specifies the valid range of values for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);

        /**
         * <p>
         * Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some
         * parameters have security or operational implications that prevent them from being changed.
         * </p>
         * 
         * @param isModifiable
         *        Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some
         *        parameters have security or operational implications that prevent them from being changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isModifiable(Boolean isModifiable);

        /**
         * <p>
         * The earliest engine version to which the parameter can apply.
         * </p>
         * 
         * @param minimumEngineVersion
         *        The earliest engine version to which the parameter can apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersion(String minimumEngineVersion);

        /**
         * <p>
         * Indicates when to apply parameter updates.
         * </p>
         * 
         * @param applyMethod
         *        Indicates when to apply parameter updates.
         * @see ApplyMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplyMethod
         */
        Builder applyMethod(String applyMethod);

        /**
         * <p>
         * Indicates when to apply parameter updates.
         * </p>
         * 
         * @param applyMethod
         *        Indicates when to apply parameter updates.
         * @see ApplyMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplyMethod
         */
        Builder applyMethod(ApplyMethod applyMethod);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterValue;

        private String description;

        private String source;

        private String applyType;

        private String dataType;

        private String allowedValues;

        private Boolean isModifiable;

        private String minimumEngineVersion;

        private String applyMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            parameterName(model.parameterName);
            parameterValue(model.parameterValue);
            description(model.description);
            source(model.source);
            applyType(model.applyType);
            dataType(model.dataType);
            allowedValues(model.allowedValues);
            isModifiable(model.isModifiable);
            minimumEngineVersion(model.minimumEngineVersion);
            applyMethod(model.applyMethod);
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getApplyType() {
            return applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final Boolean getIsModifiable() {
            return isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getMinimumEngineVersion() {
            return minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        public final String getApplyMethodAsString() {
            return applyMethod;
        }

        @Override
        public final Builder applyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
            return this;
        }

        @Override
        public final Builder applyMethod(ApplyMethod applyMethod) {
            this.applyMethod(applyMethod.toString());
            return this;
        }

        public final void setApplyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
        }

        @Override
        public Parameter build() {
            return new Parameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
