/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbClusterSnapshotAttributeRequest extends NeptuneRequest implements
        ToCopyableBuilder<ModifyDbClusterSnapshotAttributeRequest.Builder, ModifyDbClusterSnapshotAttributeRequest> {
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterSnapshotAttributeRequest::dbClusterSnapshotIdentifier))
            .setter(setter(Builder::dbClusterSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotIdentifier")
                    .build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterSnapshotAttributeRequest::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<List<String>> VALUES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyDbClusterSnapshotAttributeRequest::valuesToAdd))
            .setter(setter(Builder::valuesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AttributeValue")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AttributeValue").build()).build()).build()).build();

    private static final SdkField<List<String>> VALUES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyDbClusterSnapshotAttributeRequest::valuesToRemove))
            .setter(setter(Builder::valuesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AttributeValue")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AttributeValue").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_TO_ADD_FIELD, VALUES_TO_REMOVE_FIELD));

    private final String dbClusterSnapshotIdentifier;

    private final String attributeName;

    private final List<String> valuesToAdd;

    private final List<String> valuesToRemove;

    private ModifyDbClusterSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    /**
     * <p>
     * The identifier for the DB cluster snapshot to modify the attributes for.
     * </p>
     * 
     * @return The identifier for the DB cluster snapshot to modify the attributes for.
     */
    public String dbClusterSnapshotIdentifier() {
        return dbClusterSnapshotIdentifier;
    }

    /**
     * <p>
     * The name of the DB cluster snapshot attribute to modify.
     * </p>
     * <p>
     * To manage authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this value to
     * <code>restore</code>.
     * </p>
     * 
     * @return The name of the DB cluster snapshot attribute to modify.</p>
     *         <p>
     *         To manage authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this
     *         value to <code>restore</code>.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.
     * </p>
     * <p>
     * To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to include one or
     * more AWS account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any AWS account.
     * Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that
     * you don't want available to all AWS accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>
     *         .</p>
     *         <p>
     *         To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to include
     *         one or more AWS account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any
     *         AWS account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain
     *         private information that you don't want available to all AWS accounts.
     */
    public List<String> valuesToAdd() {
        return valuesToAdd;
    }

    /**
     * <p>
     * A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.
     * </p>
     * <p>
     * To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to
     * include one or more AWS account identifiers, or <code>all</code> to remove authorization for any AWS account to
     * copy or restore the DB cluster snapshot. If you specify <code>all</code>, an AWS account whose account ID is
     * explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of DB cluster snapshot attributes to remove from the attribute specified by
     *         <code>AttributeName</code>.</p>
     *         <p>
     *         To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this
     *         list to include one or more AWS account identifiers, or <code>all</code> to remove authorization for any
     *         AWS account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an AWS account
     *         whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a
     *         manual DB cluster snapshot.
     */
    public List<String> valuesToRemove() {
        return valuesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(valuesToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(valuesToRemove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDbClusterSnapshotAttributeRequest other = (ModifyDbClusterSnapshotAttributeRequest) obj;
        return Objects.equals(dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier())
                && Objects.equals(attributeName(), other.attributeName()) && Objects.equals(valuesToAdd(), other.valuesToAdd())
                && Objects.equals(valuesToRemove(), other.valuesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyDbClusterSnapshotAttributeRequest")
                .add("DBClusterSnapshotIdentifier", dbClusterSnapshotIdentifier()).add("AttributeName", attributeName())
                .add("ValuesToAdd", valuesToAdd()).add("ValuesToRemove", valuesToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotIdentifier()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ValuesToAdd":
            return Optional.ofNullable(clazz.cast(valuesToAdd()));
        case "ValuesToRemove":
            return Optional.ofNullable(clazz.cast(valuesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterSnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterSnapshotAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyDbClusterSnapshotAttributeRequest> {
        /**
         * <p>
         * The identifier for the DB cluster snapshot to modify the attributes for.
         * </p>
         * 
         * @param dbClusterSnapshotIdentifier
         *        The identifier for the DB cluster snapshot to modify the attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier);

        /**
         * <p>
         * The name of the DB cluster snapshot attribute to modify.
         * </p>
         * <p>
         * To manage authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this
         * value to <code>restore</code>.
         * </p>
         * 
         * @param attributeName
         *        The name of the DB cluster snapshot attribute to modify.</p>
         *        <p>
         *        To manage authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set
         *        this value to <code>restore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.
         * </p>
         * <p>
         * To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to include one
         * or more AWS account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any AWS
         * account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private
         * information that you don't want available to all AWS accounts.
         * </p>
         * 
         * @param valuesToAdd
         *        A list of DB cluster snapshot attributes to add to the attribute specified by
         *        <code>AttributeName</code>.</p>
         *        <p>
         *        To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to
         *        include one or more AWS account IDs, or <code>all</code> to make the manual DB cluster snapshot
         *        restorable by any AWS account. Do not add the <code>all</code> value for any manual DB cluster
         *        snapshots that contain private information that you don't want available to all AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToAdd(Collection<String> valuesToAdd);

        /**
         * <p>
         * A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.
         * </p>
         * <p>
         * To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to include one
         * or more AWS account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any AWS
         * account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private
         * information that you don't want available to all AWS accounts.
         * </p>
         * 
         * @param valuesToAdd
         *        A list of DB cluster snapshot attributes to add to the attribute specified by
         *        <code>AttributeName</code>.</p>
         *        <p>
         *        To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to
         *        include one or more AWS account IDs, or <code>all</code> to make the manual DB cluster snapshot
         *        restorable by any AWS account. Do not add the <code>all</code> value for any manual DB cluster
         *        snapshots that contain private information that you don't want available to all AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToAdd(String... valuesToAdd);

        /**
         * <p>
         * A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>
         * .
         * </p>
         * <p>
         * To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this list
         * to include one or more AWS account identifiers, or <code>all</code> to remove authorization for any AWS
         * account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an AWS account whose
         * account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB
         * cluster snapshot.
         * </p>
         * 
         * @param valuesToRemove
         *        A list of DB cluster snapshot attributes to remove from the attribute specified by
         *        <code>AttributeName</code>.</p>
         *        <p>
         *        To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set
         *        this list to include one or more AWS account identifiers, or <code>all</code> to remove authorization
         *        for any AWS account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an
         *        AWS account whose account ID is explicitly added to the <code>restore</code> attribute can still copy
         *        or restore a manual DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToRemove(Collection<String> valuesToRemove);

        /**
         * <p>
         * A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>
         * .
         * </p>
         * <p>
         * To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this list
         * to include one or more AWS account identifiers, or <code>all</code> to remove authorization for any AWS
         * account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an AWS account whose
         * account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB
         * cluster snapshot.
         * </p>
         * 
         * @param valuesToRemove
         *        A list of DB cluster snapshot attributes to remove from the attribute specified by
         *        <code>AttributeName</code>.</p>
         *        <p>
         *        To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set
         *        this list to include one or more AWS account identifiers, or <code>all</code> to remove authorization
         *        for any AWS account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an
         *        AWS account whose account ID is explicitly added to the <code>restore</code> attribute can still copy
         *        or restore a manual DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesToRemove(String... valuesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String dbClusterSnapshotIdentifier;

        private String attributeName;

        private List<String> valuesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> valuesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterSnapshotAttributeRequest model) {
            super(model);
            dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            attributeName(model.attributeName);
            valuesToAdd(model.valuesToAdd);
            valuesToRemove(model.valuesToRemove);
        }

        public final String getDbClusterSnapshotIdentifier() {
            return dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getValuesToAdd() {
            return valuesToAdd;
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String... valuesToAdd) {
            valuesToAdd(Arrays.asList(valuesToAdd));
            return this;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        public final Collection<String> getValuesToRemove() {
            return valuesToRemove;
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String... valuesToRemove) {
            valuesToRemove(Arrays.asList(valuesToRemove));
            return this;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterSnapshotAttributeRequest build() {
            return new ModifyDbClusterSnapshotAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
