/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Raised when a request fails because of insufficient memory resources. The request can be retried.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryLimitExceededException extends NeptunedataException implements
        ToCopyableBuilder<MemoryLimitExceededException.Builder, MemoryLimitExceededException> {
    private static final SdkField<String> DETAILED_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detailedMessage").getter(getter(MemoryLimitExceededException::detailedMessage))
            .setter(setter(Builder::detailedMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailedMessage").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(MemoryLimitExceededException::requestIdValue))
            .setter(setter(Builder::requestIdValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(MemoryLimitExceededException::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_MESSAGE_FIELD,
            REQUEST_ID_FIELD, CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailedMessage;

    private final String requestIdValue;

    private final String code;

    private MemoryLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.detailedMessage = builder.detailedMessage;
        this.requestIdValue = builder.requestIdValue;
        this.code = builder.code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * A detailed message describing the problem.
     * </p>
     * 
     * @return A detailed message describing the problem.
     */
    public String detailedMessage() {
        return detailedMessage;
    }

    /**
     * <p>
     * The ID of the request that failed.
     * </p>
     * 
     * @return The ID of the request that failed.
     */
    public String requestIdValue() {
        return requestIdValue;
    }

    /**
     * <p>
     * The HTTP status code returned with the exception.
     * </p>
     * 
     * @return The HTTP status code returned with the exception.
     */
    public String code() {
        return code;
    }

    @Override
    public boolean isRetryableException() {
        return true;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemoryLimitExceededException, T> g) {
        return obj -> g.apply((MemoryLimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryLimitExceededException>,
            NeptunedataException.Builder {
        /**
         * <p>
         * A detailed message describing the problem.
         * </p>
         * 
         * @param detailedMessage
         *        A detailed message describing the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedMessage(String detailedMessage);

        /**
         * <p>
         * The ID of the request that failed.
         * </p>
         * 
         * @param requestIdValue
         *        The ID of the request that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdValue(String requestIdValue);

        /**
         * <p>
         * The HTTP status code returned with the exception.
         * </p>
         * 
         * @param code
         *        The HTTP status code returned with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends NeptunedataException.BuilderImpl implements Builder {
        private String detailedMessage;

        private String requestIdValue;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryLimitExceededException model) {
            super(model);
            detailedMessage(model.detailedMessage);
            requestIdValue(model.requestIdValue);
            code(model.code);
        }

        public final String getDetailedMessage() {
            return detailedMessage;
        }

        public final void setDetailedMessage(String detailedMessage) {
            this.detailedMessage = detailedMessage;
        }

        @Override
        public final Builder detailedMessage(String detailedMessage) {
            this.detailedMessage = detailedMessage;
            return this;
        }

        public final String getRequestIdValue() {
            return requestIdValue;
        }

        public final void setRequestIdValue(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestIdValue(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public MemoryLimitExceededException build() {
            return new MemoryLimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
