/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Gremlin or openCypher change record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertygraphData implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertygraphData.Builder, PropertygraphData> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PropertygraphData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PropertygraphData::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(PropertygraphData::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Document> VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("value").getter(getter(PropertygraphData::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("from")
            .getter(getter(PropertygraphData::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<String> TO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("to")
            .getter(getter(PropertygraphData::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            KEY_FIELD, VALUE_FIELD, FROM_FIELD, TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String key;

    private final Document value;

    private final String from;

    private final String to;

    private PropertygraphData(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.key = builder.key;
        this.value = builder.value;
        this.from = builder.from;
        this.to = builder.to;
    }

    /**
     * <p>
     * The ID of the Gremlin or openCypher element.
     * </p>
     * 
     * @return The ID of the Gremlin or openCypher element.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of this Gremlin or openCypher element. Must be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>v1</code> </b>   -   Vertex label for Gremlin, or node label for openCypher.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>vp</code> </b>   -   Vertex properties for Gremlin, or node properties for openCypher.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>e</code> </b>   -   Edge and edge label for Gremlin, or relationship and relationship type for
     * openCypher.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>ep</code> </b>   -   Edge properties for Gremlin, or relationship properties for openCypher.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of this Gremlin or openCypher element. Must be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>v1</code> </b>   -   Vertex label for Gremlin, or node label for openCypher.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>vp</code> </b>   -   Vertex properties for Gremlin, or node properties for openCypher.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>e</code> </b>   -   Edge and edge label for Gremlin, or relationship and relationship type for
     *         openCypher.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>ep</code> </b>   -   Edge properties for Gremlin, or relationship properties for openCypher.
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The property name. For element labels, this is <code>label</code>.
     * </p>
     * 
     * @return The property name. For element labels, this is <code>label</code>.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * This is a JSON object that contains a value field for the value itself, and a datatype field for the JSON data
     * type of that value:
     * </p>
     * 
     * @return This is a JSON object that contains a value field for the value itself, and a datatype field for the JSON
     *         data type of that value:
     */
    public final Document value() {
        return value;
    }

    /**
     * <p>
     * If this is an edge (type = <code>e</code>), the ID of the corresponding <code>from</code> vertex or source node.
     * </p>
     * 
     * @return If this is an edge (type = <code>e</code>), the ID of the corresponding <code>from</code> vertex or
     *         source node.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * If this is an edge (type = <code>e</code>), the ID of the corresponding <code>to</code> vertex or target node.
     * </p>
     * 
     * @return If this is an edge (type = <code>e</code>), the ID of the corresponding <code>to</code> vertex or target
     *         node.
     */
    public final String to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertygraphData)) {
            return false;
        }
        PropertygraphData other = (PropertygraphData) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(type(), other.type()) && Objects.equals(key(), other.key())
                && Objects.equals(value(), other.value()) && Objects.equals(from(), other.from())
                && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertygraphData").add("Id", id()).add("Type", type()).add("Key", key()).add("Value", value())
                .add("From", from()).add("To", to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertygraphData, T> g) {
        return obj -> g.apply((PropertygraphData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertygraphData> {
        /**
         * <p>
         * The ID of the Gremlin or openCypher element.
         * </p>
         * 
         * @param id
         *        The ID of the Gremlin or openCypher element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of this Gremlin or openCypher element. Must be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>v1</code> </b>   -   Vertex label for Gremlin, or node label for openCypher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>vp</code> </b>   -   Vertex properties for Gremlin, or node properties for openCypher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>e</code> </b>   -   Edge and edge label for Gremlin, or relationship and relationship type for
         * openCypher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>ep</code> </b>   -   Edge properties for Gremlin, or relationship properties for openCypher.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of this Gremlin or openCypher element. Must be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>v1</code> </b>   -   Vertex label for Gremlin, or node label for openCypher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>vp</code> </b>   -   Vertex properties for Gremlin, or node properties for openCypher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>e</code> </b>   -   Edge and edge label for Gremlin, or relationship and relationship type
         *        for openCypher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>ep</code> </b>   -   Edge properties for Gremlin, or relationship properties for openCypher.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The property name. For element labels, this is <code>label</code>.
         * </p>
         * 
         * @param key
         *        The property name. For element labels, this is <code>label</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * This is a JSON object that contains a value field for the value itself, and a datatype field for the JSON
         * data type of that value:
         * </p>
         * 
         * @param value
         *        This is a JSON object that contains a value field for the value itself, and a datatype field for the
         *        JSON data type of that value:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Document value);

        /**
         * <p>
         * If this is an edge (type = <code>e</code>), the ID of the corresponding <code>from</code> vertex or source
         * node.
         * </p>
         * 
         * @param from
         *        If this is an edge (type = <code>e</code>), the ID of the corresponding <code>from</code> vertex or
         *        source node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * If this is an edge (type = <code>e</code>), the ID of the corresponding <code>to</code> vertex or target
         * node.
         * </p>
         * 
         * @param to
         *        If this is an edge (type = <code>e</code>), the ID of the corresponding <code>to</code> vertex or
         *        target node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String to);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String key;

        private Document value;

        private String from;

        private String to;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertygraphData model) {
            id(model.id);
            type(model.type);
            key(model.key);
            value(model.value);
            from(model.from);
            to(model.to);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Document getValue() {
            return value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getTo() {
            return to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        @Override
        public PropertygraphData build() {
            return new PropertygraphData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
