/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteOpenCypherQueryRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ExecuteOpenCypherQueryRequest.Builder, ExecuteOpenCypherQueryRequest> {
    private static final SdkField<String> OPEN_CYPHER_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("openCypherQuery").getter(getter(ExecuteOpenCypherQueryRequest::openCypherQuery))
            .setter(setter(Builder::openCypherQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameters").getter(getter(ExecuteOpenCypherQueryRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_CYPHER_QUERY_FIELD,
            PARAMETERS_FIELD));

    private final String openCypherQuery;

    private final String parameters;

    private ExecuteOpenCypherQueryRequest(BuilderImpl builder) {
        super(builder);
        this.openCypherQuery = builder.openCypherQuery;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The openCypher query string to be executed.
     * </p>
     * 
     * @return The openCypher query string to be executed.
     */
    public final String openCypherQuery() {
        return openCypherQuery;
    }

    /**
     * <p>
     * The openCypher query parameters for query execution. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html">Examples of
     * openCypher parameterized queries</a> for more information.
     * </p>
     * 
     * @return The openCypher query parameters for query execution. See <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html"
     *         >Examples of openCypher parameterized queries</a> for more information.
     */
    public final String parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(openCypherQuery());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteOpenCypherQueryRequest)) {
            return false;
        }
        ExecuteOpenCypherQueryRequest other = (ExecuteOpenCypherQueryRequest) obj;
        return Objects.equals(openCypherQuery(), other.openCypherQuery()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteOpenCypherQueryRequest").add("OpenCypherQuery", openCypherQuery())
                .add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openCypherQuery":
            return Optional.ofNullable(clazz.cast(openCypherQuery()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteOpenCypherQueryRequest, T> g) {
        return obj -> g.apply((ExecuteOpenCypherQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteOpenCypherQueryRequest> {
        /**
         * <p>
         * The openCypher query string to be executed.
         * </p>
         * 
         * @param openCypherQuery
         *        The openCypher query string to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openCypherQuery(String openCypherQuery);

        /**
         * <p>
         * The openCypher query parameters for query execution. See <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html">Examples of
         * openCypher parameterized queries</a> for more information.
         * </p>
         * 
         * @param parameters
         *        The openCypher query parameters for query execution. See <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html"
         *        >Examples of openCypher parameterized queries</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String openCypherQuery;

        private String parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteOpenCypherQueryRequest model) {
            super(model);
            openCypherQuery(model.openCypherQuery);
            parameters(model.parameters);
        }

        public final String getOpenCypherQuery() {
            return openCypherQuery;
        }

        public final void setOpenCypherQuery(String openCypherQuery) {
            this.openCypherQuery = openCypherQuery;
        }

        @Override
        public final Builder openCypherQuery(String openCypherQuery) {
            this.openCypherQuery = openCypherQuery;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteOpenCypherQueryRequest build() {
            return new ExecuteOpenCypherQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
